/*
 * Decompiled with CFR 0.152.
 */
package ca.beq.util.win32.registry;

import ca.beq.util.win32.registry.KeyIterator;
import ca.beq.util.win32.registry.RegistryValue;
import ca.beq.util.win32.registry.RootKey;
import ca.beq.util.win32.registry.ValueIterator;
import java.util.Iterator;

public class RegistryKey {
    static boolean c_initSucceeded = false;
    RootKey m_root;
    String m_path;

    static native void testInitialized();

    public static void initialize() {
        RegistryKey.initialize("jRegistryKey");
    }

    public static synchronized void initialize(String libname) {
        try {
            RegistryKey.testInitialized();
            c_initSucceeded = true;
        }
        catch (UnsatisfiedLinkError e) {
            System.loadLibrary(libname);
            RegistryKey.testInitialized();
            c_initSucceeded = true;
        }
    }

    public static boolean isInitialized() {
        return c_initSucceeded;
    }

    public static void checkInitialized() {
        if (!RegistryKey.isInitialized()) {
            throw new IllegalStateException("You must successfuly call method initialize before calling this method.");
        }
    }

    public RegistryKey() {
        RegistryKey.checkInitialized();
        this.m_root = RootKey.HKEY_CURRENT_USER;
        this.m_path = "";
    }

    public RegistryKey(RootKey root) {
        this();
        this.m_root = root;
    }

    public RegistryKey(String path) {
        this();
        this.m_path = path;
    }

    public RegistryKey(RootKey root, String path) {
        RegistryKey.checkInitialized();
        this.m_root = root;
        this.m_path = path;
    }

    public RootKey getRootKey() {
        return this.m_root;
    }

    public String getPath() {
        return this.m_path;
    }

    public String makePath(String subPath) {
        StringBuffer path = new StringBuffer(this.m_path);
        if (!"".equals(this.m_path)) {
            path.append("\\");
        }
        path.append(subPath);
        return path.toString();
    }

    public String getName() {
        return this.m_path.substring(1 + this.m_path.lastIndexOf("\\"));
    }

    public native boolean exists();

    public native void create();

    public RegistryKey createSubkey(String name) {
        RegistryKey r = new RegistryKey(this.m_root, this.makePath(name));
        r.create();
        return r;
    }

    public native void delete();

    public native boolean hasSubkeys();

    public boolean hasSubkey(String name) {
        RegistryKey r = new RegistryKey(this.m_root, this.makePath(name));
        return r.exists();
    }

    public Iterator subkeys() {
        return new KeyIterator(this);
    }

    public Iterator values() {
        return new ValueIterator(this);
    }

    public native boolean hasValue(String var1);

    public native boolean hasValues();

    public native RegistryValue getValue(String var1);

    public native void setValue(RegistryValue var1);

    public native void deleteValue(String var1);

    public String toString() {
        StringBuffer toString = new StringBuffer(this.m_root.toString());
        if (!"".equals(this.m_path)) {
            toString.append("\\");
            toString.append(this.m_path);
        }
        return toString.toString();
    }
}

