/*
 * Decompiled with CFR 0.152.
 */
package ca.beq.util.win32.registry;

import ca.beq.util.win32.registry.RegistryException;
import ca.beq.util.win32.registry.RegistryKey;
import ca.beq.util.win32.registry.ValueType;

public class RegistryValue {
    String m_name;
    ValueType m_type;
    Object m_data;

    public RegistryValue() {
        RegistryKey.checkInitialized();
        this.m_name = "";
        this.m_type = ValueType.REG_SZ;
        this.m_data = null;
    }

    public RegistryValue(Object data) {
        this();
        this.m_data = data;
    }

    public RegistryValue(String name, Object data) {
        this();
        this.m_name = name;
        this.m_data = data;
    }

    public RegistryValue(String name, ValueType type, Object data) {
        this();
        this.m_name = name;
        this.m_type = type;
        this.m_data = data;
    }

    public RegistryValue(String name, boolean data) {
        this(name, ValueType.REG_DWORD, new Boolean(data));
    }

    public RegistryValue(String name, byte data) {
        this(name, ValueType.REG_BINARY, new Byte(data));
    }

    public RegistryValue(String name, int data) {
        this(name, ValueType.REG_DWORD, new Integer(data));
    }

    public RegistryValue(String name, long data) {
        this(name, ValueType.REG_DWORD, new Long(data));
    }

    public RegistryValue(String name, float data) {
        this(name, ValueType.REG_BINARY, new Float(data));
    }

    public RegistryValue(String name, double data) {
        this(name, ValueType.REG_BINARY, new Double(data));
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public ValueType getType() {
        return this.m_type;
    }

    public void setType(ValueType type) {
        this.m_type = type;
    }

    public Object getData() {
        return this.m_data;
    }

    public void setData(Object data) {
        this.m_data = data;
    }

    public void setData(byte data) {
        this.setData(new Byte(data));
    }

    public void setData(boolean data) {
        this.setData(new Boolean(data));
    }

    public void setData(int data) {
        this.setData(new Integer(data));
    }

    public void setData(long data) {
        this.setData(new Long(data));
    }

    public void setData(float data) {
        this.setData(new Float(data));
    }

    public void setData(double data) {
        this.setData(new Double(data));
    }

    /*
     * WARNING - void declaration
     */
    public String getStringValue() {
        void var1_1;
        String stringValue;
        if (this.m_name == null || this.m_data == null) {
            throw new NullPointerException("Neither name not data may be null");
        }
        if (this.m_type == ValueType.REG_SZ || this.m_type == ValueType.REG_EXPAND_SZ) {
            stringValue = this.m_data.toString();
        } else if (this.m_type == ValueType.REG_DWORD || this.m_type == ValueType.REG_DWORD_BIG_ENDIAN) {
            stringValue = ((Integer)this.m_data).toString();
        } else if (this.m_type == ValueType.REG_NONE || this.m_type == ValueType.REG_BINARY || this.m_type == ValueType.REG_LINK || this.m_type == ValueType.REG_MULTI_SZ || this.m_type == ValueType.REG_RESOURCE_LIST || this.m_type == ValueType.REG_RESOURCE_REQUIREMENTS_LIST || this.m_type == ValueType.REG_FULL_RESOURCE_DESCRIPTOR) {
            StringBuffer sb = new StringBuffer();
            byte[] b = (byte[])this.m_data;
            for (int index = 0; index < b.length; ++index) {
                sb.append(' ').append(Byte.toString(b[index]));
            }
            stringValue = sb.toString();
        } else {
            throw new RegistryException("Unrecognized data type: " + this.m_type);
        }
        return var1_1;
    }

    public String toString() {
        return this.m_name + ':' + this.m_type.toString() + ':' + this.getStringValue();
    }
}

