/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.VerticalLayout;

public class JXCollapsiblePane
extends JXPanel {
    public static final String ANIMATION_STATE_KEY = "animationState";
    public static final String TOGGLE_ACTION = "toggle";
    public static final String COLLAPSE_ICON = "collapseIcon";
    public static final String EXPAND_ICON = "expandIcon";
    private boolean collapsed = false;
    private Timer animateTimer;
    private AnimationListener animator;
    private int currentHeight = -1;
    private WrapperContainer wrapper;
    private boolean useAnimation = true;
    private AnimationParams animationParams;

    public JXCollapsiblePane() {
        this(new BorderLayout(0, 0));
    }

    public JXCollapsiblePane(LayoutManager layout) {
        super.setLayout(layout);
        JPanel panel = new JPanel();
        panel.setLayout(new VerticalLayout(2));
        this.setContentPane(panel);
        this.animator = new AnimationListener();
        this.setAnimationParams(new AnimationParams(30, 8, 0.01f, 1.0f));
        this.getActionMap().put(TOGGLE_ACTION, new ToggleAction());
    }

    public void setContentPane(Container contentPanel) {
        if (contentPanel == null) {
            throw new IllegalArgumentException("Content pane can't be null");
        }
        if (this.wrapper != null) {
            assert (super.getComponent(0) == this.wrapper);
            super.remove(0);
        }
        this.wrapper = new WrapperContainer(contentPanel);
        super.addImpl(this.wrapper, "Center", -1);
    }

    public Container getContentPane() {
        return this.wrapper.c;
    }

    public void setLayout(LayoutManager mgr) {
        if (this.wrapper != null) {
            this.getContentPane().setLayout(mgr);
        }
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        this.getContentPane().add(comp, constraints, index);
    }

    public void remove(Component comp) {
        this.getContentPane().remove(comp);
    }

    public void remove(int index) {
        this.getContentPane().remove(index);
    }

    public void removeAll() {
        this.getContentPane().removeAll();
    }

    public void setAnimated(boolean animated) {
        if (animated != this.useAnimation) {
            this.useAnimation = animated;
            this.firePropertyChange("animated", !this.useAnimation, this.useAnimation);
        }
    }

    public boolean isAnimated() {
        return this.useAnimation;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean val) {
        if (this.collapsed != val) {
            this.collapsed = val;
            if (this.isAnimated()) {
                if (this.collapsed) {
                    this.setAnimationParams(new AnimationParams(30, Math.max(8, this.wrapper.getHeight() / 10), 1.0f, 0.01f));
                    this.animator.reinit(this.wrapper.getHeight(), 0);
                    this.animateTimer.start();
                } else {
                    this.setAnimationParams(new AnimationParams(30, Math.max(8, this.getContentPane().getPreferredSize().height / 10), 0.01f, 1.0f));
                    this.animator.reinit(this.wrapper.getHeight(), this.getContentPane().getPreferredSize().height);
                    this.animateTimer.start();
                }
            } else {
                this.wrapper.c.setVisible(!this.collapsed);
                this.invalidate();
                this.doLayout();
            }
            this.repaint();
            this.firePropertyChange("collapsed", !this.collapsed, this.collapsed);
        }
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dim;
        if (!this.isAnimated()) {
            dim = this.getContentPane().isVisible() ? this.getContentPane().getPreferredSize() : super.getPreferredSize();
        } else {
            dim = new Dimension(this.getContentPane().getPreferredSize());
            if (!this.getContentPane().isVisible() && this.currentHeight != -1) {
                dim.height = this.currentHeight;
            }
        }
        return dim;
    }

    private void setAnimationParams(AnimationParams params) {
        if (params == null) {
            throw new IllegalArgumentException("params can't be null");
        }
        if (this.animateTimer != null) {
            this.animateTimer.stop();
        }
        this.animationParams = params;
        this.animateTimer = new Timer(this.animationParams.waitTime, this.animator);
        this.animateTimer.setInitialDelay(0);
    }

    private final class WrapperContainer
    extends JXPanel {
        private BufferedImage img;
        private Container c;
        float alpha;

        public WrapperContainer(Container c) {
            super(new BorderLayout());
            this.alpha = 1.0f;
            this.c = c;
            this.add((Component)c, "Center");
            if (c instanceof JComponent && !((JComponent)c).isOpaque()) {
                ((JComponent)c).setOpaque(true);
            }
        }

        public void showImage() {
            this.makeImage();
            this.c.setVisible(false);
        }

        public void showContent() {
            JXCollapsiblePane.this.currentHeight = -1;
            this.c.setVisible(true);
        }

        void makeImage() {
            if (this.getGraphicsConfiguration() != null && this.getWidth() > 0) {
                Dimension dim = this.c.getPreferredSize();
                if (dim.height > 0) {
                    this.img = this.getGraphicsConfiguration().createCompatibleImage(this.getWidth(), dim.height);
                    this.c.setSize(this.getWidth(), dim.height);
                    this.c.paint(this.img.getGraphics());
                } else {
                    this.img = null;
                }
            }
        }

        public void paintComponent(Graphics g) {
            if (!JXCollapsiblePane.this.useAnimation || this.c.isVisible()) {
                super.paintComponent(g);
            } else {
                if (this.img == null) {
                    this.makeImage();
                }
                if (g != null && this.img != null) {
                    g.drawImage(this.img, 0, this.getHeight() - this.img.getHeight(), null);
                }
            }
        }

        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Composite oldComp = g2d.getComposite();
            AlphaComposite alphaComp = AlphaComposite.getInstance(3, this.alpha);
            g2d.setComposite(alphaComp);
            super.paint(g2d);
            g2d.setComposite(oldComp);
        }
    }

    private final class AnimationListener
    implements ActionListener {
        private final Object ANIMATION_MUTEX = "Animation Synchronization Mutex";
        private int startHeight = 0;
        private int finalHeight = 0;
        private float animateAlpha = 1.0f;

        private AnimationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            Object object = this.ANIMATION_MUTEX;
            synchronized (object) {
                if (this.startHeight == this.finalHeight) {
                    JXCollapsiblePane.this.animateTimer.stop();
                    this.animateAlpha = ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaEnd;
                    if (this.finalHeight > 0) {
                        JXCollapsiblePane.this.wrapper.showContent();
                        this.validate();
                        JXCollapsiblePane.this.firePropertyChange(JXCollapsiblePane.ANIMATION_STATE_KEY, null, "expanded");
                        return;
                    }
                    JXCollapsiblePane.this.firePropertyChange(JXCollapsiblePane.ANIMATION_STATE_KEY, null, "collapsed");
                }
                boolean contracting = this.startHeight > this.finalHeight;
                int delta_y = contracting ? -1 * ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.deltaY : ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.deltaY;
                int newHeight = JXCollapsiblePane.this.wrapper.getHeight() + delta_y;
                if (contracting) {
                    if (newHeight < this.finalHeight) {
                        newHeight = this.finalHeight;
                    }
                } else if (newHeight > this.finalHeight) {
                    newHeight = this.finalHeight;
                }
                this.animateAlpha = (float)newHeight / (float)((WrapperContainer)((JXCollapsiblePane)JXCollapsiblePane.this).wrapper).c.getPreferredSize().height;
                Rectangle bounds = JXCollapsiblePane.this.wrapper.getBounds();
                int oldHeight = bounds.height;
                bounds.height = newHeight;
                JXCollapsiblePane.this.wrapper.setBounds(bounds);
                bounds = JXCollapsiblePane.this.getBounds();
                bounds.height = bounds.height - oldHeight + newHeight;
                JXCollapsiblePane.this.currentHeight = bounds.height;
                JXCollapsiblePane.this.setBounds(bounds);
                this.startHeight = newHeight;
                if (contracting) {
                    if (this.animateAlpha < ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaEnd) {
                        this.animateAlpha = ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaEnd;
                    }
                    if (this.animateAlpha > ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaStart) {
                        this.animateAlpha = ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaStart;
                    }
                } else {
                    if (this.animateAlpha > ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaEnd) {
                        this.animateAlpha = ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaEnd;
                    }
                    if (this.animateAlpha < ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaStart) {
                        this.animateAlpha = ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaStart;
                    }
                }
                ((JXCollapsiblePane)JXCollapsiblePane.this).wrapper.alpha = this.animateAlpha;
                this.validate();
            }
        }

        void validate() {
            Container parent = SwingUtilities.getAncestorOfClass(JCollapsiblePaneContainer.class, JXCollapsiblePane.this);
            parent = parent != null ? ((JCollapsiblePaneContainer)((Object)parent)).getValidatingContainer() : JXCollapsiblePane.this.getParent();
            if (parent != null) {
                if (parent instanceof JComponent) {
                    ((JComponent)parent).revalidate();
                } else {
                    parent.invalidate();
                }
                parent.doLayout();
                parent.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reinit(int startHeight, int stopHeight) {
            Object object = this.ANIMATION_MUTEX;
            synchronized (object) {
                JXCollapsiblePane.this.firePropertyChange(JXCollapsiblePane.ANIMATION_STATE_KEY, null, "reinit");
                this.startHeight = startHeight;
                this.finalHeight = stopHeight;
                this.animateAlpha = ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaStart;
                JXCollapsiblePane.this.currentHeight = -1;
                JXCollapsiblePane.this.wrapper.showImage();
            }
        }
    }

    private static class AnimationParams {
        final int waitTime;
        final int deltaY;
        final float alphaStart;
        final float alphaEnd;

        public AnimationParams(int waitTime, int deltaY, float alphaStart, float alphaEnd) {
            this.waitTime = waitTime;
            this.deltaY = deltaY;
            this.alphaStart = alphaStart;
            this.alphaEnd = alphaEnd;
        }
    }

    public static interface JCollapsiblePaneContainer {
        public Container getValidatingContainer();
    }

    private class ToggleAction
    extends AbstractAction
    implements PropertyChangeListener {
        public ToggleAction() {
            super(JXCollapsiblePane.TOGGLE_ACTION);
            JXCollapsiblePane.this.addPropertyChangeListener("collapsed", this);
        }

        public void putValue(String key, Object newValue) {
            super.putValue(key, newValue);
            if (JXCollapsiblePane.EXPAND_ICON.equals(key) || JXCollapsiblePane.COLLAPSE_ICON.equals(key)) {
                this.updateIcon();
            }
        }

        public void actionPerformed(ActionEvent e) {
            JXCollapsiblePane.this.setCollapsed(!JXCollapsiblePane.this.isCollapsed());
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.updateIcon();
        }

        void updateIcon() {
            if (JXCollapsiblePane.this.isCollapsed()) {
                this.putValue("SmallIcon", this.getValue(JXCollapsiblePane.EXPAND_ICON));
            } else {
                this.putValue("SmallIcon", this.getValue(JXCollapsiblePane.COLLAPSE_ICON));
            }
        }
    }
}

