/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.jdesktop.swingx.JXMultiThumbSlider;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.color.ColorSelectionButton;
import org.jdesktop.swingx.color.ColorUtil;
import org.jdesktop.swingx.color.GradientPreviewPanel;
import org.jdesktop.swingx.color.GradientThumbRenderer;
import org.jdesktop.swingx.color.GradientTrackRenderer;
import org.jdesktop.swingx.multislider.Thumb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXGradientChooser
extends JXPanel {
    private JXMultiThumbSlider<Color> slider;
    public JButton deleteThumbButton;
    public JButton addThumbButton;
    public JTextField colorField;
    public ColorSelectionButton changeColorButton;
    public JSpinner colorLocationSpinner;
    public JSpinner alphaSpinner;
    public JSlider alphaSlider;
    public JComboBox styleCombo;
    public GradientPreviewPanel gradientPreview;
    public JRadioButton noCycleRadio;
    public JRadioButton reflectedRadio;
    public JRadioButton repeatedRadio;
    public JCheckBox reversedCheck;
    Paint checker_texture = null;

    public JXGradientChooser() {
        this.initComponents();
    }

    public MultipleGradientPaint getGradient() {
        List<Thumb<Color>> stops = this.slider.getModel().getSortedThumbs();
        int len = stops.size();
        float[] fractions = new float[len];
        Color[] colors = new Color[len];
        int i = 0;
        for (Thumb<Color> thumb : stops) {
            colors[i] = thumb.getObject();
            fractions[i] = thumb.getPosition();
            ++i;
        }
        Point2D.Float start = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float end = new Point2D.Float(this.getWidth(), 0.0f);
        LinearGradientPaint paint = new LinearGradientPaint((float)((Point2D)start).getX(), (float)((Point2D)start).getY(), (float)((Point2D)end).getX(), (float)((Point2D)end).getY(), fractions, colors);
        return paint;
    }

    public void setGradient(MultipleGradientPaint mgrad) {
        while (this.slider.getModel().getThumbCount() > 0) {
            this.slider.getModel().removeThumb(0);
        }
        float[] fracts = mgrad.getFractions();
        Color[] colors = mgrad.getColors();
        for (int i = 0; i < fracts.length; ++i) {
            this.slider.getModel().addThumb(fracts[i], colors[i]);
        }
        this.repaint();
    }

    private void updateFromStop(Thumb<Color> thumb) {
        if (thumb == null) {
            this.updateFromStop(-1, -1.0f, Color.black);
        } else {
            this.updateFromStop(1, thumb.getPosition(), thumb.getObject());
        }
    }

    private void updateFromStop(int thumb, float position, Color color) {
        if (thumb == -1) {
            this.colorLocationSpinner.setEnabled(false);
            this.alphaSpinner.setEnabled(false);
            this.alphaSlider.setEnabled(false);
            this.colorField.setEnabled(false);
            this.changeColorButton.setEnabled(false);
            this.changeColorButton.setBackground(Color.black);
            this.deleteThumbButton.setEnabled(false);
        } else {
            this.colorLocationSpinner.setEnabled(true);
            this.alphaSpinner.setEnabled(true);
            this.alphaSlider.setEnabled(true);
            this.colorField.setEnabled(true);
            this.changeColorButton.setEnabled(true);
            this.colorLocationSpinner.setValue((int)(100.0f * position));
            this.colorField.setText(Integer.toHexString(color.getRGB()).substring(2));
            this.alphaSpinner.setValue(color.getAlpha() * 100 / 255);
            this.alphaSlider.setValue(color.getAlpha() * 100 / 255);
            this.changeColorButton.setBackground(color);
            this.deleteThumbButton.setEnabled(true);
        }
        this.updateDeleteButtons();
        this.gradientPreview.repaint();
    }

    private void updateDeleteButtons() {
        if (this.slider.getModel().getThumbCount() <= 2) {
            this.deleteThumbButton.setEnabled(false);
        }
    }

    public JXMultiThumbSlider<Color> getSlider() {
        return this.slider;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        AddThumbAction addThumbAction = new AddThumbAction();
        DeleteThumbAction deleteThumbAction = new DeleteThumbAction();
        deleteThumbAction.setEnabled(false);
        ChangeColorAction changeColorAction = new ChangeColorAction();
        changeColorAction.setEnabled(false);
        ActionMap actions = this.getActionMap();
        actions.put("add-thumb", addThumbAction);
        actions.put("delete-thumb", deleteThumbAction);
        actions.put("change-color", changeColorAction);
        JXPanel topPanel = new JXPanel(new GridBagLayout());
        topPanel.setBorder(BorderFactory.createTitledBorder("Gradient"));
        JXPanel sliderPanel = new JXPanel(new GridBagLayout());
        this.slider = new JXMultiThumbSlider();
        this.addThumbButton = new JButton(addThumbAction);
        this.deleteThumbButton = new JButton(deleteThumbAction);
        sliderPanel.add(this.slider, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        sliderPanel.add((Component)this.addThumbButton, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 22, 0, new Insets(0, 0, 0, 3), 0, 0));
        sliderPanel.add((Component)this.deleteThumbButton, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 21, 0, new Insets(0, 3, 0, 0), 0, 0));
        topPanel.add((Component)sliderPanel, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 19, 2, new Insets(7, 7, 12, 7), 0, 0));
        JLabel label = new JLabel("Color: #");
        label.setHorizontalAlignment(11);
        this.colorField = new JTextField();
        this.colorField.setText("000");
        this.colorField.setEnabled(false);
        label.setLabelFor(this.colorField);
        this.changeColorButton = new ColorSelectionButton();
        this.changeColorButton.setAction(changeColorAction);
        this.changeColorButton.setText("");
        topPanel.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)this.colorField, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)this.changeColorButton, new GridBagConstraints(2, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("Location: %");
        label.setHorizontalAlignment(11);
        this.colorLocationSpinner = new JSpinner();
        this.colorLocationSpinner.setEnabled(false);
        this.colorLocationSpinner.addChangeListener(new ChangeLocationListener());
        label.setLabelFor(this.colorLocationSpinner);
        topPanel.add((Component)label, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)this.colorLocationSpinner, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        ChangeAlphaListener changeAlphaListener = new ChangeAlphaListener();
        label = new JLabel("Opacity: %");
        label.setHorizontalAlignment(11);
        this.alphaSpinner = new JSpinner();
        this.alphaSpinner.setEnabled(false);
        this.alphaSpinner.addChangeListener(changeAlphaListener);
        label.setLabelFor(this.alphaSpinner);
        this.alphaSlider = new JSlider();
        this.alphaSlider.setEnabled(false);
        this.alphaSlider.addChangeListener(changeAlphaListener);
        topPanel.add((Component)label, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)this.alphaSpinner, new GridBagConstraints(1, 3, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)this.alphaSlider, new GridBagConstraints(2, 3, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)topPanel, "North");
        JXPanel previewPanel = new JXPanel(new GridBagLayout());
        previewPanel.setBorder(BorderFactory.createTitledBorder("Preview"));
        RepaintOnEventListener repaintListener = new RepaintOnEventListener();
        label = new JLabel("Style:");
        this.styleCombo = new JComboBox();
        this.styleCombo.addItemListener(repaintListener);
        this.styleCombo.setModel(new DefaultComboBoxModel<GradientStyle>(GradientStyle.values()));
        label.setLabelFor(this.styleCombo);
        previewPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        previewPanel.add((Component)this.styleCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("Type");
        previewPanel.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        ButtonGroup typeGroup = new ButtonGroup();
        this.noCycleRadio = new JRadioButton("None");
        this.noCycleRadio.setSelected(true);
        this.noCycleRadio.addActionListener(repaintListener);
        typeGroup.add(this.noCycleRadio);
        previewPanel.add((Component)this.noCycleRadio, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.reflectedRadio = new JRadioButton("Reflect");
        this.reflectedRadio.addActionListener(repaintListener);
        typeGroup.add(this.reflectedRadio);
        previewPanel.add((Component)this.reflectedRadio, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.repeatedRadio = new JRadioButton("Repeat");
        this.repeatedRadio.addActionListener(repaintListener);
        typeGroup.add(this.repeatedRadio);
        previewPanel.add((Component)this.repeatedRadio, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.reversedCheck = new JCheckBox("Reverse");
        this.reversedCheck.addActionListener(repaintListener);
        previewPanel.add((Component)this.reversedCheck, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.gradientPreview = new GradientPreviewPanel();
        this.gradientPreview.picker = this;
        previewPanel.add((Component)this.gradientPreview, new GridBagConstraints(2, 0, 1, 5, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(previewPanel);
        SpinnerNumberModel alpha_model = new SpinnerNumberModel(100, 0, 100, 1);
        this.alphaSpinner.setModel(alpha_model);
        SpinnerNumberModel location_model = new SpinnerNumberModel(100, 0, 100, 1);
        this.colorLocationSpinner.setModel(location_model);
        this.checker_texture = ColorUtil.getCheckerPaint();
        this.slider.setOpaque(false);
        this.slider.setPreferredSize(new Dimension(100, 35));
        this.slider.getModel().setMinimumValue(0.0f);
        this.slider.getModel().setMaximumValue(1.0f);
        this.slider.getModel().addThumb(0.0f, Color.black);
        this.slider.getModel().addThumb(0.5f, Color.red);
        this.slider.getModel().addThumb(1.0f, Color.white);
        this.slider.setThumbRenderer(new GradientThumbRenderer(this, this.slider));
        this.slider.setTrackRenderer(new GradientTrackRenderer(this));
        this.slider.addMultiThumbListener(new StopListener(this.slider));
    }

    private void selectColorForThumb() {
        int index = this.slider.getSelectedIndex();
        if (index >= 0) {
            Color color = this.slider.getModel().getThumbAt(index).getObject();
            if ((color = JColorChooser.showDialog(this.slider, "Select A Color", color)) != null) {
                this.slider.getModel().getThumbAt(index).setObject(color);
                this.updateFromStop(index, this.slider.getModel().getThumbAt(index).getPosition(), color);
                this.slider.repaint();
                this.gradientPreview.repaint();
            }
        }
    }

    public static MultipleGradientPaint showDialog(Component comp, String title, MultipleGradientPaint mgrad) {
        Component root = SwingUtilities.getRoot(comp);
        final JDialog dialog = new JDialog((JFrame)root, title, true);
        JXGradientChooser picker = new JXGradientChooser();
        if (mgrad != null) {
            picker.setGradient(mgrad);
        }
        dialog.add(picker);
        JPanel panel = new JPanel();
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dialog.setVisible(false);
            }
        });
        JButton okay = new JButton("Okay");
        okay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dialog.setVisible(false);
            }
        });
        panel.add(cancel);
        panel.add((Component)okay, "East");
        dialog.add((Component)panel, "South");
        dialog.pack();
        dialog.setVisible(true);
        return picker.getGradient();
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        final JFrame frame = new JFrame("Gradient Picker");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BoxLayout(frame.getContentPane(), 1));
        JButton button = new JButton("Select Gradient");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color[] colors = new Color[]{Color.blue, Color.black};
                float[] vals = new float[]{0.0f, 1.0f};
                LinearGradientPaint paint = new LinearGradientPaint(0.0f, 0.0f, 10.0f, 0.0f, vals, colors);
                MultipleGradientPaint grad = JXGradientChooser.showDialog(frame, "Pick a Gradient", (MultipleGradientPaint)paint);
                System.out.println("got: " + JXGradientChooser.toString(grad));
            }
        });
        frame.add(button);
        frame.pack();
        frame.setVisible(true);
    }

    public static String toString(MultipleGradientPaint paint) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(paint.getClass().getName());
        Color[] colors = paint.getColors();
        float[] values = paint.getFractions();
        buffer.append("[");
        for (int i = 0; i < colors.length; ++i) {
            buffer.append("#" + Integer.toHexString(colors[i].getRGB()));
            buffer.append(":");
            buffer.append(values[i]);
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    private final class RepaintOnEventListener
    implements ActionListener,
    ItemListener {
        private RepaintOnEventListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JXGradientChooser.this.gradientPreview.repaint();
        }

        public void itemStateChanged(ItemEvent e) {
            JXGradientChooser.this.gradientPreview.repaint();
        }
    }

    private class StopListener
    implements JXMultiThumbSlider.ThumbListener {
        private JXMultiThumbSlider slider;

        public StopListener(JXMultiThumbSlider slider) {
            this.slider = slider;
        }

        public void thumbMoved(int thumb, float pos) {
            Color color = (Color)this.slider.getModel().getThumbAt(thumb).getObject();
            JXGradientChooser.this.updateFromStop(thumb, pos, color);
            JXGradientChooser.this.updateDeleteButtons();
        }

        public void thumbSelected(int thumb) {
            if (thumb == -1) {
                JXGradientChooser.this.updateFromStop(-1, -1.0f, Color.black);
                return;
            }
            float pos = this.slider.getModel().getThumbAt(thumb).getPosition();
            Color color = (Color)this.slider.getModel().getThumbAt(thumb).getObject();
            JXGradientChooser.this.updateFromStop(thumb, pos, color);
            JXGradientChooser.this.updateDeleteButtons();
        }

        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() > 1) {
                JXGradientChooser.this.selectColorForThumb();
            }
        }
    }

    private final class DeleteThumbAction
    extends AbstractActionExt {
        public DeleteThumbAction() {
            super("Delete");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int index = JXGradientChooser.this.slider.getSelectedIndex();
            if (index >= 0) {
                JXGradientChooser.this.slider.getModel().removeThumb(index);
                JXGradientChooser.this.updateFromStop(-1, -1.0f, null);
            }
        }
    }

    private final class AddThumbAction
    extends AbstractActionExt {
        public AddThumbAction() {
            super("Add");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            float pos = 0.2f;
            Color color = Color.black;
            for (int i = 0; i < JXGradientChooser.this.slider.getModel().getThumbCount(); ++i) {
                float pos2 = JXGradientChooser.this.slider.getModel().getThumbAt(i).getPosition();
                if (pos2 < pos) continue;
                JXGradientChooser.this.slider.getModel().insertThumb(pos, color, i);
                JXGradientChooser.this.updateFromStop(i, pos, color);
                break;
            }
        }
    }

    private final class ChangeColorAction
    extends AbstractActionExt {
        public ChangeColorAction() {
            super("Change Color");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JXGradientChooser.this.selectColorForThumb();
        }
    }

    private final class ChangeAlphaListener
    implements ChangeListener {
        private ChangeAlphaListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (JXGradientChooser.this.slider.getSelectedIndex() >= 0) {
                Thumb<Color> thumb = JXGradientChooser.this.slider.getModel().getThumbAt(JXGradientChooser.this.slider.getSelectedIndex());
                int alpha = changeEvent.getSource() == JXGradientChooser.this.alphaSpinner ? ((Integer)JXGradientChooser.this.alphaSpinner.getValue()).intValue() : JXGradientChooser.this.alphaSlider.getValue();
                Color col = (Color)thumb.getObject();
                col = ColorUtil.setAlpha(col, alpha * 255 / 100);
                thumb.setObject(col);
                if (changeEvent.getSource() == JXGradientChooser.this.alphaSpinner) {
                    JXGradientChooser.this.alphaSlider.setValue(alpha);
                } else {
                    JXGradientChooser.this.alphaSpinner.setValue(alpha);
                }
                JXGradientChooser.this.slider.repaint();
                JXGradientChooser.this.gradientPreview.repaint();
            }
        }
    }

    private final class ChangeLocationListener
    implements ChangeListener {
        private ChangeLocationListener() {
        }

        public void stateChanged(ChangeEvent evt) {
            if (JXGradientChooser.this.slider.getSelectedIndex() >= 0) {
                Thumb thumb = JXGradientChooser.this.slider.getModel().getThumbAt(JXGradientChooser.this.slider.getSelectedIndex());
                thumb.setPosition((float)((Integer)JXGradientChooser.this.colorLocationSpinner.getValue()).intValue() / 100.0f);
                JXGradientChooser.this.slider.recalc();
                JXGradientChooser.this.slider.repaint();
                JXGradientChooser.this.updateFromStop(thumb);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GradientStyle {
        Linear,
        Radial;

    }
}

