/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;
import org.jdesktop.swingx.multislider.DefaultMultiThumbModel;
import org.jdesktop.swingx.multislider.MultiThumbModel;
import org.jdesktop.swingx.multislider.ThumbDataEvent;
import org.jdesktop.swingx.multislider.ThumbDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXMultiThumbSlider<E>
extends JComponent {
    private ThumbDataListener tdl;
    public List<ThumbComp> thumbs;
    private ThumbRenderer thumbRenderer;
    private TrackRenderer trackRenderer;
    private MultiThumbModel<E> model;
    List<ThumbListener> listeners = new ArrayList<ThumbListener>();
    ThumbComp selected;

    public JXMultiThumbSlider() {
        this.thumbs = new ArrayList<ThumbComp>();
        this.setLayout(null);
        this.tdl = new ThumbDataListener(){

            public void positionChanged(ThumbDataEvent e) {
                System.out.println("position changed");
            }

            public void thumbAdded(ThumbDataEvent evt) {
                ThumbComp thumb = new ThumbComp(JXMultiThumbSlider.this);
                thumb.setLocation(0, 0);
                JXMultiThumbSlider.this.add(thumb);
                JXMultiThumbSlider.this.thumbs.add(evt.getIndex(), thumb);
                JXMultiThumbSlider.this.clipThumbPosition(thumb);
                JXMultiThumbSlider.this.setThumbXByPosition(thumb, evt.getThumb().getPosition());
                JXMultiThumbSlider.this.repaint();
            }

            public void thumbRemoved(ThumbDataEvent evt) {
                ThumbComp thumb = JXMultiThumbSlider.this.thumbs.get(evt.getIndex());
                JXMultiThumbSlider.this.remove(thumb);
                JXMultiThumbSlider.this.thumbs.remove(thumb);
                JXMultiThumbSlider.this.repaint();
            }

            public void valueChanged(ThumbDataEvent e) {
                System.out.println("value changed");
            }
        };
        this.setModel(new DefaultMultiThumbModel());
        MultiThumbMouseListener mia = new MultiThumbMouseListener(this);
        this.addMouseListener(mia);
        this.addMouseMotionListener(mia);
        Dimension dim = new Dimension(20, 20);
        this.setMaximumSize(dim);
        this.setPreferredSize(dim);
        this.setSize(dim);
        dim = new Dimension(10, 10);
        this.setMinimumSize(dim);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isVisible()) {
            if (this.trackRenderer != null) {
                this.trackRenderer.paintTrack((Graphics2D)g, this);
            } else {
                this.paintRange((Graphics2D)g);
            }
        }
    }

    private void paintRange(Graphics2D g) {
        g.setColor(Color.blue);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    private float getThumbValue(int thumbIndex) {
        return this.getModel().getThumbAt(thumbIndex).getPosition();
    }

    private float getThumbValue(ThumbComp thumb) {
        return this.getThumbValue(this.thumbs.indexOf(thumb));
    }

    private int getThumbIndex(ThumbComp thumb) {
        return this.thumbs.indexOf(thumb);
    }

    private void clipThumbPosition(ThumbComp thumb) {
        if (this.getThumbValue(thumb) < this.getModel().getMinimumValue()) {
            this.getModel().getThumbAt(this.getThumbIndex(thumb)).setPosition(this.getModel().getMinimumValue());
        }
        if (this.getThumbValue(thumb) > this.getModel().getMaximumValue()) {
            this.getModel().getThumbAt(this.getThumbIndex(thumb)).setPosition(this.getModel().getMaximumValue());
        }
    }

    public ThumbRenderer getThumbRenderer() {
        return this.thumbRenderer;
    }

    public void setThumbRenderer(ThumbRenderer thumbRenderer) {
        this.thumbRenderer = thumbRenderer;
    }

    public TrackRenderer getTrackRenderer() {
        return this.trackRenderer;
    }

    public void setTrackRenderer(TrackRenderer trackRenderer) {
        this.trackRenderer = trackRenderer;
    }

    private void setThumbPositionByX(ThumbComp selected) {
        float range = this.getModel().getMaximumValue() - this.getModel().getMinimumValue();
        int x = selected.getX();
        x += selected.getWidth() / 2;
        int w = this.getWidth();
        float delta = (float)(x -= selected.getWidth() / 2) / (float)(w -= selected.getWidth());
        int thumb_index = this.getThumbIndex(selected);
        float value = delta * range;
        this.getModel().getThumbAt(thumb_index).setPosition(value);
        this.clipThumbPosition(selected);
    }

    private void setThumbXByPosition(ThumbComp thumb, float pos) {
        float tu = pos;
        float lp = this.getWidth() - thumb.getWidth();
        float lu = this.getModel().getMaximumValue() - this.getModel().getMinimumValue();
        float tp = tu * lp / lu;
        thumb.setLocation((int)tp - thumb.getWidth() / 2 + thumb.getWidth() / 2, thumb.getY());
    }

    public void recalc() {
        for (ThumbComp th : this.thumbs) {
            this.setThumbXByPosition(th, this.getModel().getThumbAt(this.getThumbIndex(th)).getPosition());
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.recalc();
    }

    public ThumbComp getSelectedThumb() {
        return this.selected;
    }

    public int getSelectedIndex() {
        return this.getThumbIndex(this.selected);
    }

    public MultiThumbModel<E> getModel() {
        return this.model;
    }

    public void setModel(MultiThumbModel<E> model) {
        if (this.model != null) {
            this.model.removeThumbDataListener(this.tdl);
        }
        this.model = model;
        this.model.addThumbDataListener(this.tdl);
    }

    public void addMultiThumbListener(ThumbListener listener) {
        this.listeners.add(listener);
    }

    public class ThumbComp
    extends JComponent {
        private JXMultiThumbSlider slider;
        private boolean selected;

        public ThumbComp(JXMultiThumbSlider slider) {
            this.slider = slider;
            Dimension dim = new Dimension(11, 22);
            this.setSize(dim);
            this.setMinimumSize(dim);
            this.setPreferredSize(dim);
            this.setMaximumSize(dim);
        }

        public void paintComponent(Graphics g) {
            if (this.slider.getThumbRenderer() != null) {
                this.slider.getThumbRenderer().paintThumb((Graphics2D)g, this, this.slider.getThumbIndex(this), this.isSelected());
            } else {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (this.isSelected()) {
                    g.setColor(Color.black);
                    g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                }
            }
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }

    public static interface TrackRenderer {
        public void paintTrack(Graphics2D var1, JXMultiThumbSlider var2);
    }

    public static interface ThumbRenderer {
        public void paintThumb(Graphics2D var1, ThumbComp var2, int var3, boolean var4);
    }

    public static interface ThumbListener {
        public void thumbMoved(int var1, float var2);

        public void thumbSelected(int var1);

        public void mousePressed(MouseEvent var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MultiThumbMouseListener
    extends MouseInputAdapter {
        private JXMultiThumbSlider slider;

        public MultiThumbMouseListener(JXMultiThumbSlider slider) {
            this.slider = slider;
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            ThumbComp handle = this.findHandle(evt);
            if (handle != null) {
                JXMultiThumbSlider.this.selected = handle;
                JXMultiThumbSlider.this.selected.setSelected(true);
                int thumb_index = JXMultiThumbSlider.this.getThumbIndex(JXMultiThumbSlider.this.selected);
                for (ThumbListener tl : JXMultiThumbSlider.this.listeners) {
                    tl.thumbSelected(thumb_index);
                }
                JXMultiThumbSlider.this.repaint();
            } else {
                JXMultiThumbSlider.this.selected = null;
                for (ThumbListener tl : JXMultiThumbSlider.this.listeners) {
                    tl.thumbSelected(-1);
                }
                JXMultiThumbSlider.this.repaint();
            }
            for (ThumbListener tl : JXMultiThumbSlider.this.listeners) {
                tl.mousePressed(evt);
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (JXMultiThumbSlider.this.selected != null) {
                JXMultiThumbSlider.this.selected.setSelected(false);
            }
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            if (JXMultiThumbSlider.this.selected != null) {
                int nx = (int)evt.getPoint().getX() - JXMultiThumbSlider.this.selected.getWidth() / 2;
                if (nx < 0) {
                    nx = 0;
                }
                if (nx > JXMultiThumbSlider.this.getWidth() - JXMultiThumbSlider.this.selected.getWidth()) {
                    nx = JXMultiThumbSlider.this.getWidth() - JXMultiThumbSlider.this.selected.getWidth();
                }
                JXMultiThumbSlider.this.selected.setLocation(nx, (int)JXMultiThumbSlider.this.selected.getLocation().getY());
                JXMultiThumbSlider.this.setThumbPositionByX(JXMultiThumbSlider.this.selected);
                int thumb_index = JXMultiThumbSlider.this.getThumbIndex(JXMultiThumbSlider.this.selected);
                for (ThumbListener mtl : JXMultiThumbSlider.this.listeners) {
                    mtl.thumbMoved(thumb_index, JXMultiThumbSlider.this.getModel().getThumbAt(thumb_index).getPosition());
                }
                JXMultiThumbSlider.this.repaint();
            }
        }

        private ThumbComp findHandle(MouseEvent evt) {
            for (ThumbComp hand : JXMultiThumbSlider.this.thumbs) {
                Point p2 = new Point();
                p2.setLocation(evt.getPoint().getX() - (double)hand.getX(), evt.getPoint().getY() - (double)hand.getY());
                if (!hand.contains(p2)) continue;
                return hand;
            }
            return null;
        }
    }
}

