/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class JXRadioGroup
extends JPanel {
    private static final long serialVersionUID = 3257285842266567986L;
    private ButtonGroup buttonGroup;
    private List<Object> values = new ArrayList<Object>();
    private ActionSelectionListener actionHandler;
    private List<ActionListener> actionListeners;
    private int gapWidth;

    public JXRadioGroup() {
        this(0);
    }

    public JXRadioGroup(int gapWidth) {
        this.setLayout(new BoxLayout(this, 0));
        this.buttonGroup = new ButtonGroup();
        this.gapWidth = gapWidth;
    }

    public JXRadioGroup(Object[] radioValues) {
        this();
        for (int i = 0; i < radioValues.length; ++i) {
            this.add(radioValues[i]);
        }
    }

    public void setValues(Object[] radioValues) {
        this.clearAll();
        for (int i = 0; i < radioValues.length; ++i) {
            this.add(radioValues[i]);
        }
    }

    private void clearAll() {
        this.values.clear();
        this.removeAll();
        this.buttonGroup = new ButtonGroup();
    }

    public void add(Object radioValue) {
        this.values.add(radioValue);
        this.addButton(new JRadioButton(radioValue.toString()));
    }

    public void add(AbstractButton button) {
        this.values.add(button.getText());
        this.addButton(button);
    }

    private void addButton(AbstractButton button) {
        this.buttonGroup.add(button);
        super.add(button);
        if (this.actionHandler == null) {
            this.actionHandler = new ActionSelectionListener();
        }
        button.addActionListener(this.actionHandler);
        button.addItemListener(this.actionHandler);
    }

    private void checkGap() {
        if (this.getGapWidth() > 0 && this.getComponentCount() > 0) {
            this.add(Box.createHorizontalStrut(this.getGapWidth()));
        }
    }

    private int getGapWidth() {
        return this.gapWidth;
    }

    public AbstractButton getSelectedButton() {
        ButtonModel selectedModel = this.buttonGroup.getSelection();
        AbstractButton[] children = this.getButtonComponents();
        for (int i = 0; i < children.length; ++i) {
            AbstractButton button = children[i];
            if (button.getModel() != selectedModel) continue;
            return button;
        }
        return null;
    }

    private AbstractButton[] getButtonComponents() {
        Component[] children = this.getComponents();
        ArrayList<Component> buttons = new ArrayList<Component>();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof AbstractButton)) continue;
            buttons.add(children[i]);
        }
        return buttons.toArray(new AbstractButton[buttons.size()]);
    }

    private int getSelectedIndex() {
        ButtonModel selectedModel = this.buttonGroup.getSelection();
        AbstractButton[] children = this.getButtonComponents();
        for (int i = 0; i < children.length; ++i) {
            AbstractButton button = children[i];
            if (button.getModel() != selectedModel) continue;
            return i;
        }
        return -1;
    }

    public Object getSelectedValue() {
        int index = this.getSelectedIndex();
        return index < 0 || index >= this.values.size() ? null : this.values.get(index);
    }

    public void setSelectedValue(Object value) {
        int index = this.values.indexOf(value);
        AbstractButton button = this.getButtonComponents()[index];
        button.setSelected(true);
    }

    public void addActionListener(ActionListener l) {
        if (this.actionListeners == null) {
            this.actionListeners = new ArrayList<ActionListener>();
        }
        this.actionListeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        if (this.actionListeners != null) {
            this.actionListeners.remove(l);
        }
    }

    public ActionListener[] getActionListeners() {
        if (this.actionListeners != null) {
            return this.actionListeners.toArray(new ActionListener[0]);
        }
        return new ActionListener[0];
    }

    protected void fireActionEvent(ActionEvent e) {
        if (this.actionListeners != null) {
            for (int i = 0; i < this.actionListeners.size(); ++i) {
                ActionListener l = this.actionListeners.get(i);
                l.actionPerformed(e);
            }
        }
    }

    private class ActionSelectionListener
    implements ActionListener,
    ItemListener {
        private ActionSelectionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JXRadioGroup.this.fireActionEvent(e);
        }

        public void itemStateChanged(ItemEvent e) {
            JXRadioGroup.this.fireActionEvent(null);
        }
    }
}

