/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JSeparator;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.plaf.JXStatusBarAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.StatusBarUI;

public class JXStatusBar
extends JXPanel {
    public static final String uiClassID = "StatusBarUI";

    public JXStatusBar() {
        this.setLayout(new Layout());
    }

    public StatusBarUI getUI() {
        return (StatusBarUI)this.ui;
    }

    public void setUI(StatusBarUI ui) {
        super.setUI(ui);
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void updateUI() {
        this.setUI((StatusBarUI)LookAndFeelAddons.getUI(this, StatusBarUI.class));
    }

    public void addSeparator() {
        JSeparator sep = new JSeparator(1);
        this.add((Component)sep, new Constraint(new Insets(1, 5, 1, 5)));
    }

    static {
        LookAndFeelAddons.contribute(new JXStatusBarAddon());
    }

    public static class Layout
    implements LayoutManager2 {
        private Map<Component, Constraint> constraints = new HashMap<Component, Constraint>();

        public void addLayoutComponent(String name, Component comp) {
            this.addLayoutComponent(comp, null);
        }

        public void addLayoutComponent(Component comp, Object constraint) {
            this.constraints.put(comp, (Constraint)constraint);
        }

        public void removeLayoutComponent(Component comp) {
            this.constraints.remove(comp);
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension prefSize = new Dimension();
            for (Component comp : this.constraints.keySet()) {
                Dimension d = comp.getPreferredSize();
                Constraint c = this.constraints.get(comp);
                if (c != null) {
                    Insets i = c.getInsets();
                    d.width += i.left + i.right;
                    d.height += i.top + i.bottom;
                }
                prefSize.height = Math.max(prefSize.height, d.height);
                prefSize.width += d.width;
            }
            Insets insets = parent.getInsets();
            prefSize.height += insets.top + insets.bottom;
            prefSize.width += insets.left + insets.right;
            return prefSize;
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public Dimension maximumLayoutSize(Container target) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.5f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.5f;
        }

        public void invalidateLayout(Container target) {
        }

        public void layoutContainer(Container parent) {
            double maxWeight = 0.0;
            for (Component comp : parent.getComponents()) {
                if (!comp.isVisible()) continue;
                Constraint c = this.constraints.get(comp);
                maxWeight += c == null ? 0.0 : c.getWeight();
            }
            maxWeight = maxWeight == 0.0 ? 1.0 : maxWeight;
            Insets parentInsets = parent.getInsets();
            int availableSpace = parent.getWidth() - this.preferredLayoutSize((Container)parent).width;
            int nextX = parentInsets.left;
            int height = parent.getHeight() - parentInsets.top - parentInsets.bottom;
            for (Component comp : parent.getComponents()) {
                if (!comp.isVisible()) continue;
                Constraint c = this.constraints.get(comp);
                double weight = c == null ? 0.0 : c.getWeight();
                Insets insets = c == null ? new Insets(0, 0, 0, 0) : c.getInsets();
                int spaceToTake = availableSpace > 0 ? (int)(weight / maxWeight * (double)availableSpace) : 0;
                availableSpace -= spaceToTake;
                int width = comp.getPreferredSize().width + spaceToTake;
                int x = nextX + insets.left;
                int y = parentInsets.top + insets.top;
                comp.setSize(width, height);
                comp.setLocation(x, y);
                nextX = x + width + insets.right;
            }
        }
    }

    public static class Constraint {
        private Insets insets;
        private double weight;

        public Constraint(Insets insets) {
            this(0.0, insets);
        }

        public Constraint(double weight) {
            this(weight, new Insets(0, 0, 0, 0));
        }

        public Constraint(double weight, Insets insets) {
            this.weight = weight;
            this.insets = insets;
        }

        public double getWeight() {
            return this.weight;
        }

        public Insets getInsets() {
            return new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
        }
    }
}

