/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.ColumnHeaderRenderer;

public class JXTableHeader
extends JTableHeader {
    private SortGestureRecognizer sortGestureRecognizer;
    private MouseInputListener headerListener;

    public JXTableHeader() {
    }

    public JXTableHeader(TableColumnModel columnModel) {
        super(columnModel);
    }

    public void setTable(JTable table) {
        super.setTable(table);
        if (this.getXTable() != null) {
            this.installHeaderListener();
        } else {
            this.uninstallHeaderListener();
        }
    }

    public JXTable getXTable() {
        if (!(this.getTable() instanceof JXTable)) {
            return null;
        }
        return (JXTable)this.getTable();
    }

    public void updateUI() {
        super.updateUI();
        if (this.getDefaultRenderer() instanceof JComponent) {
            ((JComponent)((Object)this.getDefaultRenderer())).updateUI();
        }
    }

    private int getViewIndexForColumn(TableColumn aColumn) {
        if (aColumn == null) {
            return -1;
        }
        TableColumnModel cm = this.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    protected TableCellRenderer createDefaultRenderer() {
        return ColumnHeaderRenderer.createColumnHeaderRenderer();
    }

    public SortGestureRecognizer getSortGestureRecognizer() {
        if (this.sortGestureRecognizer == null) {
            this.sortGestureRecognizer = this.createSortGestureRecognizer();
        }
        return this.sortGestureRecognizer;
    }

    public void setSortGestureRecognizer(SortGestureRecognizer recognizer) {
        this.sortGestureRecognizer = recognizer;
    }

    protected SortGestureRecognizer createSortGestureRecognizer() {
        return new SortGestureRecognizer();
    }

    protected void installHeaderListener() {
        if (this.headerListener == null) {
            this.headerListener = new HeaderListener();
            this.addMouseListener(this.headerListener);
            this.addMouseMotionListener(this.headerListener);
        }
    }

    protected void uninstallHeaderListener() {
        if (this.headerListener != null) {
            this.removeMouseListener(this.headerListener);
            this.removeMouseMotionListener(this.headerListener);
            this.headerListener = null;
        }
    }

    public static class SortGestureRecognizer {
        public boolean isResetSortOrderGesture(MouseEvent e) {
            return this.isSortOrderGesture(e) && this.isResetModifier(e);
        }

        protected boolean isResetModifier(MouseEvent e) {
            return (e.getModifiersEx() & 0x40) == 64;
        }

        public boolean isToggleSortOrderGesture(MouseEvent e) {
            return this.isSortOrderGesture(e) && !this.isResetModifier(e);
        }

        public boolean isSortOrderGesture(MouseEvent e) {
            return e.getClickCount() == 1;
        }
    }

    private class HeaderListener
    implements MouseInputListener {
        private TableColumn cachedResizingColumn;

        private HeaderListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (this.shouldIgnore(e)) {
                return;
            }
            if (this.isInResizeRegion(e)) {
                this.doResize(e);
            } else {
                this.doSort(e);
            }
        }

        private boolean shouldIgnore(MouseEvent e) {
            return !SwingUtilities.isLeftMouseButton(e) || !JXTableHeader.this.table.isEnabled();
        }

        private void doSort(MouseEvent e) {
            JXTable table = JXTableHeader.this.getXTable();
            if (!table.isSortable()) {
                return;
            }
            if (JXTableHeader.this.getSortGestureRecognizer().isResetSortOrderGesture(e)) {
                table.resetSortOrder();
                JXTableHeader.this.repaint();
            } else if (JXTableHeader.this.getSortGestureRecognizer().isToggleSortOrderGesture(e)) {
                int column = JXTableHeader.this.columnAtPoint(e.getPoint());
                if (column >= 0) {
                    table.toggleSortOrder(column);
                }
                this.uncacheResizingColumn();
                JXTableHeader.this.repaint();
            }
        }

        private void doResize(MouseEvent e) {
            if (e.getClickCount() != 2) {
                return;
            }
            int column = JXTableHeader.this.getViewIndexForColumn(this.cachedResizingColumn);
            if (column >= 0) {
                JXTableHeader.this.getXTable().packColumn(column, 5);
            }
            this.uncacheResizingColumn();
        }

        public void mouseReleased(MouseEvent e) {
            this.cacheResizingColumn(e);
        }

        public void mousePressed(MouseEvent e) {
            this.cacheResizingColumn(e);
        }

        private void cacheResizingColumn(MouseEvent e) {
            if (!JXTableHeader.this.getSortGestureRecognizer().isSortOrderGesture(e)) {
                return;
            }
            TableColumn column = JXTableHeader.this.getResizingColumn();
            if (column != null) {
                this.cachedResizingColumn = column;
            }
        }

        private void uncacheResizingColumn() {
            this.cachedResizingColumn = null;
        }

        private boolean isInResizeRegion(MouseEvent e) {
            return this.cachedResizingColumn != null;
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            this.uncacheResizingColumn();
        }

        public void mouseDragged(MouseEvent e) {
            this.uncacheResizingColumn();
        }

        public void mouseMoved(MouseEvent e) {
        }
    }
}

