/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.EventObject;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.UIAction;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableCellEditor;
import org.jdesktop.swingx.treetable.TreeTableModel;

public class JXTreeTable
extends JXTable {
    public static final String DRAG_HACK_FLAG_KEY = "treeTable.dragHackFlag";
    private TreeTableCellRenderer renderer;
    private static final Dimension spacing = new Dimension(0, 2);

    public JXTreeTable() {
        this(new DefaultTreeTableModel());
    }

    public JXTreeTable(TreeTableModel treeModel) {
        this(treeModel, new TreeTableCellRenderer(treeModel));
    }

    private JXTreeTable(TreeTableModel treeModel, TreeTableCellRenderer renderer) {
        super(new TreeTableModelAdapter(treeModel, renderer));
        if (treeModel != renderer.getModel()) {
            throw new IllegalArgumentException("Mismatched TreeTableModel");
        }
        this.init(renderer);
        this.initActions();
        super.setSortable(false);
        this.setDefaultEditor(AbstractTreeTableModel.hierarchicalColumnClass, new TreeTableCellEditor(renderer));
        this.setShowGrid(false);
        this.setIntercellSpacing(spacing);
        this.adminSetRowHeight(this.getRowHeight());
        this.setRowMargin(this.getRowMargin());
    }

    private void initActions() {
        ActionMap map = this.getActionMap();
        map.put("expand-all", new Actions("expand-all"));
        map.put("collapse-all", new Actions("collapse-all"));
    }

    public void setSortable(boolean sortable) {
    }

    public void setShowHorizontalLines(boolean show) {
        super.setShowHorizontalLines(show);
    }

    public void setShowVerticalLines(boolean show) {
        super.setShowVerticalLines(show);
    }

    public boolean editCellAt(int row, int column, EventObject e) {
        this.expandOrCollapseNode(column, e);
        boolean canEdit = super.editCellAt(row, column, e);
        if (canEdit && this.isHierarchical(column)) {
            this.repaint(this.getCellRect(row, column, false));
        }
        return canEdit;
    }

    private void expandOrCollapseNode(int column, EventObject e) {
        if (!(e instanceof MouseEvent)) {
            return;
        }
        if (!this.isHierarchical(column)) {
            return;
        }
        MouseEvent me = (MouseEvent)e;
        if (this.hackAroundDragEnabled(me)) {
            me = new MouseEvent((Component)me.getSource(), 501, me.getWhen(), me.getModifiers(), me.getX(), me.getY(), me.getClickCount(), me.isPopupTrigger());
        }
        if (me.getModifiers() == 0 || me.getModifiers() == 16) {
            int savedHeight = this.renderer.getRowHeight();
            this.renderer.setRowHeight(this.getRowHeight());
            MouseEvent pressed = new MouseEvent(this.renderer, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - this.getCellRect((int)0, (int)column, (boolean)false).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
            this.renderer.dispatchEvent(pressed);
            MouseEvent released = new MouseEvent(this.renderer, 502, pressed.getWhen(), pressed.getModifiers(), pressed.getX(), pressed.getY(), pressed.getClickCount(), pressed.isPopupTrigger());
            this.renderer.dispatchEvent(released);
            this.renderer.setRowHeight(savedHeight);
        }
    }

    protected boolean hackAroundDragEnabled(MouseEvent me) {
        Boolean dragHackFlag = (Boolean)this.getClientProperty(DRAG_HACK_FLAG_KEY);
        if (dragHackFlag == null) {
            String priority = null;
            try {
                priority = System.getProperty("sun.swing.enableImprovedDragGesture");
            }
            catch (Exception ex) {
                // empty catch block
            }
            dragHackFlag = priority == null;
            this.putClientProperty(DRAG_HACK_FLAG_KEY, dragHackFlag);
        }
        return this.getDragEnabled() && dragHackFlag != false;
    }

    public int getEditingRow() {
        return this.isHierarchical(this.editingColumn) ? -1 : this.editingRow;
    }

    private int realEditingRow() {
        return this.editingRow;
    }

    public void setTreeTableModel(TreeTableModel treeModel) {
        TreeTableModel old = this.getTreeTableModel();
        this.renderer.setModel(treeModel);
        ((TreeTableModelAdapter)this.getModel()).setTreeTableModel(treeModel);
        if (treeModel != this.renderer.getModel()) {
            throw new IllegalArgumentException("Mismatched TreeTableModel");
        }
        this.setDefaultEditor(AbstractTreeTableModel.hierarchicalColumnClass, new TreeTableCellEditor(this.renderer));
        this.adminSetRowHeight(this.getRowHeight());
        this.setRowMargin(this.getRowMargin());
        this.firePropertyChange("treeTableModel", old, this.getTreeTableModel());
    }

    public TreeTableModel getTreeTableModel() {
        return ((TreeTableModelAdapter)this.getModel()).getTreeTableModel();
    }

    public final void setModel(TableModel tableModel) {
        if (tableModel instanceof TreeTableModelAdapter) {
            if (((TreeTableModelAdapter)tableModel).getTreeTable() != null) {
                throw new IllegalArgumentException("model already bound");
            }
        } else {
            throw new IllegalArgumentException("unsupported model type");
        }
        super.setModel(tableModel);
        ((TreeTableModelAdapter)tableModel).bind(this);
    }

    public final void setRowHeight(int row, int rowHeight) {
        throw new UnsupportedOperationException("variable height rows not supported");
    }

    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        this.adjustTreeRowHeight();
    }

    public void setColumnMargin(int columnMargin) {
        super.setColumnMargin(columnMargin);
    }

    public void setRowMargin(int rowMargin) {
        super.setRowMargin(rowMargin);
        this.adjustTreeRowHeight();
    }

    private void adjustTreeRowHeight() {
        int treeRowHeight = this.rowHeight + (this.rowMargin << 1);
        if (this.renderer != null && this.renderer.getRowHeight() != treeRowHeight) {
            this.renderer.setRowHeight(treeRowHeight);
        }
    }

    public void setSelectionMode(int mode) {
        if (this.renderer != null) {
            switch (mode) {
                case 1: {
                    this.renderer.getSelectionModel().setSelectionMode(2);
                    break;
                }
                case 2: {
                    this.renderer.getSelectionModel().setSelectionMode(4);
                    break;
                }
                default: {
                    this.renderer.getSelectionModel().setSelectionMode(1);
                }
            }
        }
        super.setSelectionMode(mode);
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component component = super.prepareRenderer(renderer, row, column);
        ComponentAdapter adapter = this.getComponentAdapter();
        adapter.row = row;
        adapter.column = column;
        return this.applyRenderer(component, adapter);
    }

    protected Component applyRenderer(Component component, ComponentAdapter adapter) {
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        if (adapter == null) {
            throw new IllegalArgumentException("null component data adapter");
        }
        if (this.isHierarchical(adapter.column)) {
            TreeCellRenderer tcr = this.renderer.getCellRenderer();
            if (tcr instanceof JXTree.DelegatingRenderer) {
                tcr = ((JXTree.DelegatingRenderer)tcr).getDelegateRenderer();
            }
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                if (adapter.isSelected()) {
                    dtcr.setTextSelectionColor(component.getForeground());
                    dtcr.setBackgroundSelectionColor(component.getBackground());
                } else {
                    dtcr.setTextNonSelectionColor(component.getForeground());
                    dtcr.setBackgroundNonSelectionColor(component.getBackground());
                }
            }
        }
        return component;
    }

    public void setTreeCellRenderer(TreeCellRenderer cellRenderer) {
        if (this.renderer != null) {
            this.renderer.setCellRenderer(cellRenderer);
        }
    }

    public TreeCellRenderer getTreeCellRenderer() {
        return this.renderer.getCellRenderer();
    }

    public String getToolTipText(MouseEvent event) {
        int column = this.columnAtPoint(event.getPoint());
        if (this.isHierarchical(column)) {
            int row = this.rowAtPoint(event.getPoint());
            return this.renderer.getToolTipText(event, row, column);
        }
        return super.getToolTipText(event);
    }

    public void setCollapsedIcon(Icon icon) {
        this.renderer.setCollapsedIcon(icon);
    }

    public void setExpandedIcon(Icon icon) {
        this.renderer.setExpandedIcon(icon);
    }

    public void setOpenIcon(Icon icon) {
        this.renderer.setOpenIcon(icon);
    }

    public void setClosedIcon(Icon icon) {
        this.renderer.setClosedIcon(icon);
    }

    public void setLeafIcon(Icon icon) {
        this.renderer.setLeafIcon(icon);
    }

    public void clearSelection() {
        if (this.renderer != null) {
            this.renderer.clearSelection();
        }
        super.clearSelection();
    }

    public void collapseAll() {
        this.renderer.collapseAll();
    }

    public void expandAll() {
        this.renderer.expandAll();
    }

    public void collapsePath(TreePath path) {
        this.renderer.collapsePath(path);
    }

    public void expandPath(TreePath path) {
        this.renderer.expandPath(path);
    }

    public void scrollPathToVisible(TreePath path) {
        if (path == null) {
            return;
        }
        this.renderer.makeVisible(path);
        int row = this.getRowForPath(path);
        this.scrollRowToVisible(row);
    }

    public void collapseRow(int row) {
        this.renderer.collapseRow(row);
    }

    public void expandRow(int row) {
        this.renderer.expandRow(row);
    }

    public void setRootVisible(boolean visible) {
        this.renderer.setRootVisible(visible);
        this.revalidate();
        this.repaint();
    }

    public boolean isRootVisible() {
        return this.renderer.isRootVisible();
    }

    public boolean isVisible(TreePath path) {
        return this.renderer.isVisible(path);
    }

    public boolean isExpanded(TreePath path) {
        return this.renderer.isExpanded(path);
    }

    public boolean isExpanded(int row) {
        return this.renderer.isExpanded(row);
    }

    public boolean isCollapsed(TreePath path) {
        return this.renderer.isCollapsed(path);
    }

    public boolean isCollapsed(int row) {
        return this.renderer.isCollapsed(row);
    }

    public Enumeration getExpandedDescendants(TreePath parent) {
        return this.renderer.getExpandedDescendants(parent);
    }

    public void setExpandsSelectedPaths(boolean expand) {
        this.renderer.setExpandsSelectedPaths(expand);
    }

    public boolean getExpandsSelectedPaths() {
        return this.renderer.getExpandsSelectedPaths();
    }

    public TreePath getPathForLocation(int x, int y) {
        int row = this.rowAtPoint(new Point(x, y));
        if (row == -1) {
            return null;
        }
        return this.renderer.getPathForRow(row);
    }

    public TreePath getPathForRow(int row) {
        return this.renderer.getPathForRow(row);
    }

    public int getRowForPath(TreePath path) {
        return this.renderer.getRowForPath(path);
    }

    public void setScrollsOnExpand(boolean scroll) {
        this.renderer.setScrollsOnExpand(scroll);
    }

    public boolean getScrollsOnExpand() {
        return this.renderer.getScrollsOnExpand();
    }

    public void setShowsRootHandles(boolean visible) {
        this.renderer.setShowsRootHandles(visible);
        this.repaint();
    }

    public boolean getShowsRootHandles() {
        return this.renderer.getShowsRootHandles();
    }

    public void addTreeExpansionListener(TreeExpansionListener tel) {
        this.renderer.addTreeExpansionListener(tel);
    }

    public void removeTreeExpansionListener(TreeExpansionListener tel) {
        this.renderer.removeTreeExpansionListener(tel);
    }

    public void addTreeSelectionListener(TreeSelectionListener tsl) {
        this.renderer.addTreeSelectionListener(tsl);
    }

    public void removeTreeSelectionListener(TreeSelectionListener tsl) {
        this.renderer.removeTreeSelectionListener(tsl);
    }

    public void addTreeWillExpandListener(TreeWillExpandListener tel) {
        this.renderer.addTreeWillExpandListener(tel);
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener tel) {
        this.renderer.removeTreeWillExpandListener(tel);
    }

    public TreeSelectionModel getTreeSelectionModel() {
        return this.renderer.getSelectionModel();
    }

    public void sizeColumnsToFit(int resizingColumn) {
        super.sizeColumnsToFit(resizingColumn);
        if (this.getEditingColumn() != -1 && this.isHierarchical(this.editingColumn)) {
            Rectangle cellRect = this.getCellRect(this.realEditingRow(), this.getEditingColumn(), false);
            Component component = this.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this.renderer != null) {
            this.renderer.updateUI();
            this.setDefaultEditor(AbstractTreeTableModel.hierarchicalColumnClass, new TreeTableCellEditor(this.renderer));
            if (this.getBackground() == null || this.getBackground() instanceof UIResource) {
                this.setBackground(this.renderer.getBackground());
            }
        }
    }

    public boolean isHierarchical(int column) {
        return AbstractTreeTableModel.hierarchicalColumnClass.isAssignableFrom(this.getColumnClass(column));
    }

    private final void init(TreeTableCellRenderer renderer) {
        this.renderer = renderer;
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        if (renderer != null) {
            renderer.bind(this);
            renderer.setSelectionModel(selectionWrapper);
        }
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.setDefaultRenderer(AbstractTreeTableModel.hierarchicalColumnClass, renderer);
        PropertyChangeListener l = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JXTreeTable.this.renderer.putClientProperty(evt.getPropertyName(), evt.getNewValue());
            }
        };
        this.addPropertyChangeListener("JTree.lineStyle", l);
    }

    protected ComponentAdapter getComponentAdapter() {
        if (this.dataAdapter == null) {
            this.dataAdapter = new TreeTableDataAdapter(this);
        }
        return this.dataAdapter;
    }

    protected static class TreeTableDataAdapter
    extends JXTable.TableAdapter {
        private final JXTreeTable table;

        public TreeTableDataAdapter(JXTreeTable component) {
            super(component);
            this.table = component;
        }

        public JXTreeTable getTreeTable() {
            return this.table;
        }

        public boolean isExpanded() {
            return super.isExpanded();
        }

        public boolean hasFocus() {
            boolean focus = super.hasFocus();
            return focus;
        }

        public boolean isLeaf() {
            return super.isLeaf();
        }

        public boolean isHierarchical() {
            return this.table.isHierarchical(this.column);
        }
    }

    static class TreeTableCellRenderer
    extends JXTree
    implements TableCellRenderer {
        protected Border highlightBorder = null;
        protected JXTreeTable treeTable = null;
        protected int visibleRow = 0;
        private int hierarchicalColumnWidth = 0;

        public TreeTableCellRenderer(TreeTableModel model) {
            super(model);
            this.putClientProperty("JTree.lineStyle", "None");
            this.setRootVisible(false);
            this.setShowsRootHandles(true);
            this.setOverwriteRendererIcons(true);
            this.setCellRenderer(new ClippedTreeCellRenderer());
        }

        private String getToolTipText(MouseEvent event, int row, int column) {
            TreePath path;
            Object lastPath;
            if (row < 0) {
                return null;
            }
            TreeCellRenderer renderer = this.getCellRenderer();
            Component rComponent = renderer.getTreeCellRendererComponent(this, lastPath = (path = this.getPathForRow(row)).getLastPathComponent(), this.isRowSelected(row), this.isExpanded(row), this.getModel().isLeaf(lastPath), row, true);
            if (rComponent instanceof JComponent) {
                Rectangle pathBounds = this.getPathBounds(path);
                Rectangle cellRect = this.treeTable.getCellRect(row, column, false);
                Point mousePoint = event.getPoint();
                mousePoint.translate(-cellRect.x, -cellRect.y);
                mousePoint.translate(-pathBounds.x, 0);
                MouseEvent newEvent = new MouseEvent(rComponent, event.getID(), event.getWhen(), event.getModifiers(), mousePoint.x, mousePoint.y, event.getClickCount(), event.isPopupTrigger());
                return ((JComponent)rComponent).getToolTipText(newEvent);
            }
            return null;
        }

        public final void bind(JXTreeTable treeTable) {
            if (treeTable == null) {
                throw new IllegalArgumentException("null treeTable");
            }
            if (this.treeTable != null) {
                throw new IllegalArgumentException("renderer already bound");
            }
            this.treeTable = treeTable;
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                dtcr.setBorderSelectionColor(null);
                dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        public void setRowHeight(int rowHeight) {
            super.setRowHeight(rowHeight);
            if (rowHeight > 0 && this.treeTable != null) {
                int tableRowMargin = this.treeTable.getRowMargin();
                assert (tableRowMargin >= 0);
                int tableRowHeight = rowHeight - (tableRowMargin << 1);
                if (this.treeTable.getRowHeight() != tableRowHeight) {
                    this.treeTable.adminSetRowHeight(tableRowHeight);
                }
            }
        }

        public void setBounds(int x, int y, int w, int h) {
            if (this.treeTable != null) {
                y = 0;
                h = this.treeTable.getRowCount() * this.getRowHeight();
            }
            super.setBounds(x, y, w, h);
        }

        public void paint(Graphics g) {
            int rowMargin = this.treeTable.getRowMargin();
            int margins = rowMargin + (rowMargin >> 1) + rowMargin % 2;
            int translationOffset = margins + this.visibleRow * this.getRowHeight();
            g.translate(0, -translationOffset);
            this.hierarchicalColumnWidth = this.getWidth();
            super.paint(g);
            if (this.highlightBorder != null) {
                this.highlightBorder.paintBorder(this, g, 0, translationOffset, this.getWidth(), this.getRowHeight() - (rowMargin << 1) - rowMargin);
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            assert (table == this.treeTable);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.highlightBorder = null;
            if (this.treeTable != null && (this.treeTable.realEditingRow() != row || this.treeTable.getEditingColumn() != column) && hasFocus) {
                this.highlightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            this.visibleRow = row;
            return this;
        }

        private class ClippedTreeCellRenderer
        extends DefaultTreeCellRenderer {
            private final Rectangle iconRect = new Rectangle();
            private final Rectangle textRect = new Rectangle();
            private final Rectangle itemRect = new Rectangle();

            private ClippedTreeCellRenderer() {
            }

            public void paint(Graphics g) {
                String fullText = super.getText();
                String shortText = SwingUtilities.layoutCompoundLabel(this, g.getFontMetrics(), fullText, this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), this.getItemRect(this.itemRect), this.iconRect, this.textRect, this.getIconTextGap());
                this.setText(shortText);
                super.paint(g);
                this.setText(fullText);
            }

            private Rectangle getItemRect(Rectangle itemRect) {
                this.getBounds(itemRect);
                itemRect.width = TreeTableCellRenderer.this.hierarchicalColumnWidth - itemRect.x;
                return itemRect;
            }
        }
    }

    private static class TreeTableModelAdapter
    extends AbstractTableModel {
        private TreeModelListener treeModelListener;
        private TreeTableModel model;
        private final JTree tree;
        private JXTreeTable treeTable = null;

        TreeTableModelAdapter(TreeTableModel model, JTree tree) {
            assert (model != null);
            assert (tree != null);
            this.tree = tree;
            this.setTreeTableModel(model);
            tree.addTreeExpansionListener(new TreeExpansionListener(){

                public void treeExpanded(TreeExpansionEvent event) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }

                public void treeCollapsed(TreeExpansionEvent event) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
            });
        }

        public void setTreeTableModel(TreeTableModel model) {
            TreeTableModel old = this.getTreeTableModel();
            if (old != null) {
                old.removeTreeModelListener(this.getTreeModelListener());
            }
            this.model = model;
            model.addTreeModelListener(this.getTreeModelListener());
            this.fireTableStructureChanged();
        }

        private TreeModelListener getTreeModelListener() {
            if (this.treeModelListener == null) {
                this.treeModelListener = new TreeModelListener(){

                    public void treeNodesChanged(TreeModelEvent e) {
                        TreeTableModelAdapter.this.delayedFireTableDataChanged(e, 0);
                    }

                    public void treeNodesInserted(TreeModelEvent e) {
                        TreeTableModelAdapter.this.delayedFireTableDataChanged(e, 1);
                    }

                    public void treeNodesRemoved(TreeModelEvent e) {
                        TreeTableModelAdapter.this.delayedFireTableDataChanged(e, 2);
                    }

                    public void treeStructureChanged(TreeModelEvent e) {
                        TreeTableModelAdapter.this.delayedFireTableDataChanged();
                    }
                };
            }
            return this.treeModelListener;
        }

        public TreeTableModel getTreeTableModel() {
            return this.model;
        }

        protected JXTreeTable getTreeTable() {
            return this.treeTable;
        }

        protected final void bind(JXTreeTable treeTable) {
            if (treeTable == null) {
                throw new IllegalArgumentException("null treeTable");
            }
            if (this.treeTable != null) {
                throw new IllegalArgumentException("adapter already bound");
            }
            this.treeTable = treeTable;
        }

        public Class getColumnClass(int column) {
            return this.model.getColumnClass(column);
        }

        public int getColumnCount() {
            return this.model.getColumnCount();
        }

        public String getColumnName(int column) {
            return this.model.getColumnName(column);
        }

        public int getRowCount() {
            return this.tree.getRowCount();
        }

        public Object getValueAt(int row, int column) {
            return this.model.getValueAt(this.nodeForRow(row), column);
        }

        public boolean isCellEditable(int row, int column) {
            return this.model.isCellEditable(this.nodeForRow(row), column);
        }

        public void setValueAt(Object value, int row, int column) {
            this.model.setValueAt(value, this.nodeForRow(row), column);
        }

        protected Object nodeForRow(int row) {
            return this.tree.getPathForRow(row).getLastPathComponent();
        }

        private void delayedFireTableDataChanged() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
            });
        }

        private void delayedFireTableDataChanged(final TreeModelEvent tme, final int typeChange) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int[] indices = tme.getChildIndices();
                    TreePath path = tme.getTreePath();
                    if (indices != null) {
                        if (TreeTableModelAdapter.this.tree.isExpanded(path)) {
                            int startingRow = TreeTableModelAdapter.this.tree.getRowForPath(path) + 1;
                            int min = Integer.MAX_VALUE;
                            int max = Integer.MIN_VALUE;
                            for (int i = 0; i < indices.length; ++i) {
                                if (indices[i] < min) {
                                    min = indices[i];
                                }
                                if (indices[i] <= max) continue;
                                max = indices[i];
                            }
                            switch (typeChange) {
                                case 0: {
                                    TreeTableModelAdapter.this.fireTableRowsUpdated(startingRow + min, startingRow + max);
                                    break;
                                }
                                case 1: {
                                    TreeTableModelAdapter.this.fireTableRowsInserted(startingRow + min, startingRow + max);
                                    break;
                                }
                                case 2: {
                                    TreeTableModelAdapter.this.fireTableRowsDeleted(startingRow + min, startingRow + max);
                                }
                            }
                        } else {
                            int row = TreeTableModelAdapter.this.tree.getRowForPath(path);
                            if (row >= 0) {
                                TreeTableModelAdapter.this.fireTableRowsUpdated(row, row);
                            }
                        }
                    } else {
                        TreeTableModelAdapter.this.fireTableDataChanged();
                    }
                }
            });
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (min != -1 && max != -1) {
                        for (int counter = min; counter <= max; ++counter) {
                            TreePath selPath;
                            if (!this.listSelectionModel.isSelectedIndex(counter) || (selPath = JXTreeTable.this.renderer.getPathForRow(counter)) == null) continue;
                            this.addSelectionPath(selPath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    private class Actions
    extends UIAction {
        Actions(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent evt) {
            if ("expand-all".equals(this.getName())) {
                JXTreeTable.this.expandAll();
            } else if ("collapse-all".equals(this.getName())) {
                JXTreeTable.this.collapseAll();
            }
        }
    }
}

