/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.auth;

import java.beans.PropertyChangeSupport;
import java.util.prefs.Preferences;
import org.jdesktop.swingx.auth.UserNameStore;

public class DefaultUserNameStore
extends UserNameStore {
    private static final String USER_KEY = "usernames";
    private static final String NUM_KEY = "usernames.length";
    private static final String DEFAULT_APP_NAME = "default";
    private Preferences prefs;
    private String[] userNames;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public DefaultUserNameStore() {
        this.userNames = new String[0];
    }

    public void loadUserNames() {
        this.initPrefs();
        if (this.prefs != null) {
            int n = this.prefs.getInt(NUM_KEY, 0);
            String[] names = new String[n];
            for (int i = 0; i < n; ++i) {
                names[i] = this.prefs.get("usernames." + i, null);
            }
            this.setUserNames(names);
        }
    }

    public void saveUserNames() {
        this.initPrefs();
        if (this.prefs != null) {
            this.prefs.putInt(NUM_KEY, this.userNames.length);
            for (int i = 0; i < this.userNames.length; ++i) {
                this.prefs.put("usernames." + i, this.userNames[i]);
            }
        }
    }

    public String[] getUserNames() {
        return this.userNames;
    }

    public void setUserNames(String[] userNames) {
        if (this.userNames != userNames) {
            String[] old = this.userNames;
            this.userNames = userNames == null ? new String[]{} : userNames;
            this.pcs.firePropertyChange("userNames", old, this.userNames);
        }
    }

    public void addUserName(String name) {
        if (!this.containsUserName(name)) {
            String[] newNames = new String[this.userNames.length + 1];
            for (int i = 0; i < this.userNames.length; ++i) {
                newNames[i] = this.userNames[i];
            }
            newNames[newNames.length - 1] = name;
            this.setUserNames(newNames);
        }
    }

    public void removeUserName(String name) {
        if (this.containsUserName(name)) {
            String[] newNames = new String[this.userNames.length - 1];
            int index = 0;
            for (String s : this.userNames) {
                if (s.equals(name)) continue;
                newNames[index++] = s;
            }
            this.setUserNames(newNames);
        }
    }

    public boolean containsUserName(String name) {
        for (String s : this.userNames) {
            if (!s.equals(name)) continue;
            return true;
        }
        return false;
    }

    public Preferences getPreferences() {
        return this.prefs;
    }

    public void setPreferences(Preferences prefs) {
        this.initPrefs();
        if (this.prefs != prefs) {
            Preferences old = this.prefs;
            this.prefs = prefs;
            this.pcs.firePropertyChange("preferences", old, prefs);
            this.loadUserNames();
        }
    }

    private void initPrefs() {
        if (this.prefs == null) {
            this.prefs = Preferences.userNodeForPackage(DefaultUserNameStore.class);
            this.prefs = this.prefs.node("DefaultUserNameStore");
        }
    }
}

