/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.calendar;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jdesktop.swingx.calendar.DateSpan;
import org.jdesktop.swingx.calendar.DateUtils;

public class JXMonthView
extends JComponent {
    public static final int NO_SELECTION = 0;
    public static final int SINGLE_SELECTION = 1;
    public static final int MULTIPLE_SELECTION = 2;
    public static final int WEEK_SELECTION = 3;
    public static final int MONTH_DOWN = 1;
    public static final int MONTH_UP = 2;
    protected static final SimpleDateFormat _dayOfMonthFormatter = new SimpleDateFormat("d");
    protected Insets _monthStringInsets = new Insets(0, 0, 0, 0);
    private static final int MONTH_DROP_SHADOW = 1;
    private static final int MONTH_LINE_DROP_SHADOW = 2;
    private static final int WEEK_DROP_SHADOW = 4;
    private int _boxPaddingX = 3;
    private int _boxPaddingY = 3;
    private int _arrowPaddingX = 3;
    private int _arrowPaddingY = 3;
    private static final int CALENDAR_SPACING = 10;
    private static final int DAYS_IN_WEEK = 7;
    private static final int MONTHS_IN_YEAR = 12;
    private long _firstDisplayedDate;
    private int _firstDisplayedMonth;
    private int _firstDisplayedYear;
    private long _lastDisplayedDate;
    private Font _derivedFont;
    private long _startSelectedDate = -1L;
    private long _endSelectedDate = -1L;
    private long _pivotDate = -1L;
    private int _numCalCols = 1;
    private int _numCalRows = 1;
    private int _minCalCols = 1;
    private int _minCalRows = 1;
    private long _today;
    private HashSet<Long> _flaggedDates;
    private int _selectionMode = 1;
    private int _boxHeight;
    private int _boxWidth;
    private int _monthBoxHeight;
    private int _calendarWidth;
    private int _calendarHeight;
    private int _firstDayOfWeek = 1;
    private int _startX;
    private int _startY;
    private int _dropShadowMask = 0;
    private boolean _dirty = false;
    private boolean _antiAlias = false;
    private boolean _ltr;
    private boolean _traversable = false;
    private boolean _usingKeyboard = false;
    private boolean _asKirkWouldSay_FIRE = false;
    private Calendar _cal;
    private String[] _daysOfTheWeek;
    private static String[] _monthsOfTheYear;
    private Dimension _dim = new Dimension();
    private Rectangle _bounds = new Rectangle();
    private Rectangle _dirtyRect = new Rectangle();
    private Color _todayBackgroundColor;
    private Color _monthStringBackground;
    private Color _monthStringForeground;
    private Color _daysOfTheWeekForeground;
    private Color _selectedBackground;
    private String _actionCommand = "selectionChanged";
    private Timer _todayTimer = null;
    private ImageIcon _monthDownImage;
    private ImageIcon _monthUpImage;
    private Hashtable<Integer, Color> _dayToColorTable = new Hashtable();
    private DateSpan _originalDateSpan = null;

    public JXMonthView() {
        this(new Date().getTime());
    }

    public JXMonthView(long initialTime) {
        this._ltr = this.getComponentOrientation().isLeftToRight();
        this._cal = Calendar.getInstance(this.getLocale());
        this._cal.setFirstDayOfWeek(this._firstDayOfWeek);
        this._cal.setMinimalDaysInFirstWeek(1);
        this._cal.set(11, 0);
        this._cal.set(12, 0);
        this._cal.set(13, 0);
        this._cal.set(14, 0);
        this._today = this._cal.getTimeInMillis();
        this._cal.setTimeInMillis(initialTime);
        this.setFirstDisplayedDate(this._cal.getTimeInMillis());
        _monthsOfTheYear = new DateFormatSymbols().getMonths();
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.setFocusable(true);
        this._todayBackgroundColor = this.getForeground();
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        this.enableEvents(16L);
        this.enableEvents(32L);
        InputMap inputMap = this.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(10, 0, false), "acceptSelection");
        inputMap.put(KeyStroke.getKeyStroke(27, 0, false), "cancelSelection");
        inputMap.put(KeyStroke.getKeyStroke(37, 0, false), "selectPreviousDay");
        inputMap.put(KeyStroke.getKeyStroke(39, 0, false), "selectNextDay");
        inputMap.put(KeyStroke.getKeyStroke(38, 0, false), "selectDayInPreviousWeek");
        inputMap.put(KeyStroke.getKeyStroke(40, 0, false), "selectDayInNextWeek");
        inputMap.put(KeyStroke.getKeyStroke(37, 1, false), "addPreviousDay");
        inputMap.put(KeyStroke.getKeyStroke(39, 1, false), "addNextDay");
        inputMap.put(KeyStroke.getKeyStroke(38, 1, false), "addToPreviousWeek");
        inputMap.put(KeyStroke.getKeyStroke(40, 1, false), "addToNextWeek");
        inputMap = this.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(10, 0, false), "acceptSelection");
        inputMap.put(KeyStroke.getKeyStroke(27, 0, false), "cancelSelection");
        inputMap.put(KeyStroke.getKeyStroke(37, 0, false), "selectPreviousDay");
        inputMap.put(KeyStroke.getKeyStroke(39, 0, false), "selectNextDay");
        inputMap.put(KeyStroke.getKeyStroke(38, 0, false), "selectDayInPreviousWeek");
        inputMap.put(KeyStroke.getKeyStroke(40, 0, false), "selectDayInNextWeek");
        inputMap.put(KeyStroke.getKeyStroke(37, 1, false), "addPreviousDay");
        inputMap.put(KeyStroke.getKeyStroke(39, 1, false), "addNextDay");
        inputMap.put(KeyStroke.getKeyStroke(38, 1, false), "addToPreviousWeek");
        inputMap.put(KeyStroke.getKeyStroke(40, 1, false), "addToNextWeek");
        ActionMap actionMap = this.getActionMap();
        actionMap.put("acceptSelection", new KeyboardAction(0));
        actionMap.put("cancelSelection", new KeyboardAction(1));
        actionMap.put("selectPreviousDay", new KeyboardAction(2));
        actionMap.put("selectNextDay", new KeyboardAction(3));
        actionMap.put("selectDayInPreviousWeek", new KeyboardAction(4));
        actionMap.put("selectDayInNextWeek", new KeyboardAction(5));
        actionMap.put("addPreviousDay", new KeyboardAction(6));
        actionMap.put("addNextDay", new KeyboardAction(7));
        actionMap.put("addToPreviousWeek", new KeyboardAction(8));
        actionMap.put("addToNextWeek", new KeyboardAction(9));
        this.updateUI();
    }

    public void updateUI() {
        super.updateUI();
        String[] daysOfTheWeek = (String[])UIManager.get("JXMonthView.daysOfTheWeek");
        if (daysOfTheWeek == null) {
            String[] dateFormatSymbols = new DateFormatSymbols().getShortWeekdays();
            daysOfTheWeek = new String[7];
            for (int i = 1; i <= 7; ++i) {
                daysOfTheWeek[i - 1] = dateFormatSymbols[i];
            }
        }
        this.setDaysOfTheWeek(daysOfTheWeek);
        Color color = UIManager.getColor("JXMonthView.monthStringBackground");
        if (color == null) {
            color = new Color(138, 173, 209);
        }
        this.setMonthStringBackground(color);
        color = UIManager.getColor("JXMonthView.monthStringForeground");
        if (color == null) {
            color = new Color(68, 68, 68);
        }
        this.setMonthStringForeground(color);
        color = UIManager.getColor("JXMonthView.daysOfTheWeekForeground");
        if (color == null) {
            color = new Color(68, 68, 68);
        }
        this.setDaysOfTheWeekForeground(color);
        color = UIManager.getColor("JXMonthView.selectedBackground");
        if (color == null) {
            color = new Color(197, 220, 240);
        }
        this.setSelectedBackground(color);
        Font font = UIManager.getFont("JXMonthView.font");
        if (font == null) {
            font = UIManager.getFont("Button.font");
        }
        this.setFont(font);
        String imageLocation = UIManager.getString("JXMonthView.monthDownFileName");
        if (imageLocation == null) {
            imageLocation = "resources/month-down.png";
        }
        this._monthDownImage = new ImageIcon(JXMonthView.class.getResource(imageLocation));
        imageLocation = UIManager.getString("JXMonthView.monthUpFileName");
        if (imageLocation == null) {
            imageLocation = "resources/month-up.png";
        }
        this._monthUpImage = new ImageIcon(JXMonthView.class.getResource(imageLocation));
    }

    public long getFirstDisplayedDate() {
        return this._firstDisplayedDate;
    }

    public void setFirstDisplayedDate(long date) {
        long old = this._firstDisplayedDate;
        this._cal.setTimeInMillis(date);
        this._cal.set(5, 1);
        this._cal.set(11, 0);
        this._cal.set(12, 0);
        this._cal.set(13, 0);
        this._cal.set(14, 0);
        this._firstDisplayedDate = this._cal.getTimeInMillis();
        this._firstDisplayedMonth = this._cal.get(2);
        this._firstDisplayedYear = this._cal.get(1);
        this.calculateLastDisplayedDate();
        this.firePropertyChange("firstDisplayedDate", old, this._firstDisplayedDate);
        this.repaint();
    }

    public long getLastDisplayedDate() {
        return this._lastDisplayedDate;
    }

    private void calculateLastDisplayedDate() {
        long old = this._lastDisplayedDate;
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        this._cal.add(2, this._numCalCols * this._numCalRows - 1);
        this._cal.set(5, this._cal.getActualMaximum(5));
        this._cal.set(11, 23);
        this._cal.set(12, 59);
        this._cal.set(13, 59);
        this._lastDisplayedDate = this._cal.getTimeInMillis();
        this.firePropertyChange("lastDisplayedDate", old, this._lastDisplayedDate);
    }

    public void ensureDateVisible(long date) {
        if (date < this._firstDisplayedDate) {
            this.setFirstDisplayedDate(date);
        } else if (date > this._lastDisplayedDate) {
            this._cal.setTimeInMillis(date);
            int month = this._cal.get(2);
            int year = this._cal.get(1);
            this._cal.setTimeInMillis(this._lastDisplayedDate);
            int lastMonth = this._cal.get(2);
            int lastYear = this._cal.get(1);
            int diffMonths = month - lastMonth + (year - lastYear) * 12;
            this._cal.setTimeInMillis(this._firstDisplayedDate);
            this._cal.add(2, diffMonths);
            this.setFirstDisplayedDate(this._cal.getTimeInMillis());
        }
        if (this._startSelectedDate != -1L || this._endSelectedDate != -1L) {
            this.calculateDirtyRectForSelection();
        }
    }

    public DateSpan getSelectedDateSpan() {
        DateSpan result = null;
        if (this._startSelectedDate != -1L) {
            result = new DateSpan(new Date(this._startSelectedDate), new Date(this._endSelectedDate));
        }
        return result;
    }

    public void setSelectedDateSpan(DateSpan dateSpan) {
        DateSpan oldSpan = null;
        if (this._startSelectedDate != -1L && this._endSelectedDate != -1L) {
            oldSpan = new DateSpan(this._startSelectedDate, this._endSelectedDate);
        }
        if (dateSpan == null) {
            this._startSelectedDate = -1L;
            this._endSelectedDate = -1L;
        } else {
            this._cal.setTimeInMillis(dateSpan.getStart());
            this._cal.set(11, 0);
            this._cal.set(12, 0);
            this._cal.set(13, 0);
            this._cal.set(14, 0);
            this._startSelectedDate = this._cal.getTimeInMillis();
            if (this._selectionMode == 1) {
                this._endSelectedDate = this._startSelectedDate;
            } else {
                this._cal.setTimeInMillis(dateSpan.getEnd());
                this._cal.set(11, 0);
                this._cal.set(12, 0);
                this._cal.set(13, 0);
                this._cal.set(14, 0);
                this._endSelectedDate = this._cal.getTimeInMillis();
                if (this._selectionMode == 3) {
                    this._cal.setTimeInMillis(this._startSelectedDate);
                    int count = 1;
                    while (this._cal.getTimeInMillis() < this._endSelectedDate) {
                        this._cal.add(5, 1);
                        ++count;
                    }
                    if (count > 7) {
                        int remainder;
                        this._cal.setTimeInMillis(this._startSelectedDate);
                        int dayOfWeek = this._cal.get(7);
                        if (dayOfWeek != this._firstDayOfWeek) {
                            int daysFromStart = dayOfWeek - this._firstDayOfWeek;
                            if (daysFromStart < 0) {
                                daysFromStart += 7;
                            }
                            this._cal.add(5, -daysFromStart);
                            count += daysFromStart;
                            this._startSelectedDate = this._cal.getTimeInMillis();
                        }
                        if ((remainder = count % 7) != 0) {
                            this._cal.setTimeInMillis(this._endSelectedDate);
                            this._cal.add(5, 7 - remainder);
                            this._endSelectedDate = this._cal.getTimeInMillis();
                        }
                    }
                }
            }
            this._cal.setTimeInMillis(this._firstDisplayedDate);
        }
        this.repaint(this._dirtyRect);
        this.calculateDirtyRectForSelection();
        this.repaint(this._dirtyRect);
        this.firePropertyChange("selectedDates", oldSpan, dateSpan);
    }

    public int getSelectionMode() {
        return this._selectionMode;
    }

    public void setSelectionMode(int mode) throws IllegalArgumentException {
        if (mode != 1 && mode != 2 && mode != 3 && mode != 0) {
            throw new IllegalArgumentException(mode + " is not a valid selection mode");
        }
        this._selectionMode = mode;
    }

    protected boolean isFlaggedDate(long date) {
        boolean result = false;
        if (this._flaggedDates != null) {
            result = this._flaggedDates.contains(date);
        }
        return result;
    }

    public void setFlaggedDates(long[] flaggedDates) {
        if (flaggedDates == null) {
            this._flaggedDates = null;
        } else {
            this._flaggedDates = new HashSet();
            for (long flaggedDate : flaggedDates) {
                this._cal.setTimeInMillis(flaggedDate);
                this._cal.set(11, 0);
                this._cal.set(12, 0);
                this._cal.set(13, 0);
                this._cal.set(14, 0);
                this._flaggedDates.add(this._cal.getTimeInMillis());
            }
            this._cal.setTimeInMillis(this._firstDisplayedDate);
        }
        this.repaint();
    }

    public int getBoxPaddingX() {
        return this._boxPaddingX;
    }

    public void setBoxPaddingX(int _boxPaddingX) {
        this._boxPaddingX = _boxPaddingX;
        this._dirty = true;
    }

    public int getBoxPaddingY() {
        return this._boxPaddingY;
    }

    public void setBoxPaddingY(int _boxPaddingY) {
        this._boxPaddingY = _boxPaddingY;
        this._dirty = true;
    }

    public boolean getTraversable() {
        return this._traversable;
    }

    public void setTraversable(boolean traversable) {
        this._traversable = traversable;
        this._dirty = true;
        this.repaint();
    }

    public void setDaysOfTheWeek(String[] days) throws IllegalArgumentException, NullPointerException {
        if (days == null) {
            throw new NullPointerException("Array of days is null.");
        }
        if (days.length != 7) {
            throw new IllegalArgumentException("Array of days is not of length 7 as expected.");
        }
        this._daysOfTheWeek = days;
        this._dirty = true;
        this.repaint();
    }

    public String[] getDaysOfTheWeek() {
        String[] days = new String[7];
        System.arraycopy(this._daysOfTheWeek, 0, days, 0, 7);
        return days;
    }

    public int getFirstDayOfWeek() {
        return this._firstDayOfWeek;
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        if (firstDayOfWeek == this._firstDayOfWeek) {
            return;
        }
        this._firstDayOfWeek = firstDayOfWeek;
        this._cal.setFirstDayOfWeek(this._firstDayOfWeek);
        this.repaint();
    }

    public TimeZone getTimeZone() {
        return this._cal.getTimeZone();
    }

    public void setTimeZone(TimeZone tz) {
        this._cal.setTimeZone(tz);
    }

    public boolean getAntialiased() {
        return this._antiAlias;
    }

    public void setAntialiased(boolean antiAlias) {
        if (this._antiAlias == antiAlias) {
            return;
        }
        this._antiAlias = antiAlias;
        this.repaint();
    }

    public Color getSelectedBackground() {
        return this._selectedBackground;
    }

    public void setSelectedBackground(Color c) {
        this._selectedBackground = c;
    }

    public Color getTodayBackground() {
        return this._todayBackgroundColor;
    }

    public void setTodayBackground(Color c) {
        this._todayBackgroundColor = c;
        this.repaint();
    }

    public Color getMonthStringBackground() {
        return this._monthStringBackground;
    }

    public void setMonthStringBackground(Color c) {
        this._monthStringBackground = c;
        this.repaint();
    }

    public Color getMonthStringForeground() {
        return this._monthStringForeground;
    }

    public void setMonthStringForeground(Color c) {
        this._monthStringForeground = c;
        this.repaint();
    }

    public void setDaysOfTheWeekForeground(Color c) {
        this._daysOfTheWeekForeground = c;
        this.repaint();
    }

    public Color getDaysOfTheWeekForeground() {
        return this._daysOfTheWeekForeground;
    }

    public void setDayForeground(int dayOfWeek, Color c) {
        this._dayToColorTable.put(dayOfWeek, c);
    }

    public Color getDayForeground(int dayOfWeek) {
        Color c = this._dayToColorTable.get(dayOfWeek);
        if (c == null) {
            c = this.getForeground();
        }
        return c;
    }

    protected int getDayOfTheWeek() {
        return this._cal.get(7);
    }

    public Insets getMonthStringInsets() {
        return (Insets)this._monthStringInsets.clone();
    }

    public void setMonthStringInsets(Insets insets) {
        if (insets == null) {
            this._monthStringInsets.top = 0;
            this._monthStringInsets.left = 0;
            this._monthStringInsets.bottom = 0;
            this._monthStringInsets.right = 0;
        } else {
            this._monthStringInsets.top = insets.top;
            this._monthStringInsets.left = insets.left;
            this._monthStringInsets.bottom = insets.bottom;
            this._monthStringInsets.right = insets.right;
        }
        this.repaint();
    }

    public int getPreferredCols() {
        return this._minCalCols;
    }

    public void setPreferredCols(int cols) {
        if (cols <= 0) {
            return;
        }
        this._minCalCols = cols;
        this._dirty = true;
        this.revalidate();
        this.repaint();
    }

    public int getPreferredRows() {
        return this._minCalRows;
    }

    public void setPreferredRows(int rows) {
        if (rows <= 0) {
            return;
        }
        this._minCalRows = rows;
        this._dirty = true;
        this.revalidate();
        this.repaint();
    }

    private void updateIfNecessary() {
        if (this._dirty) {
            this.update();
            this._dirty = false;
        }
    }

    private void update() {
        int newHeight;
        int currWidth;
        int longestMonth = 0;
        int daysInLongestMonth = 0;
        int longestMonthWidth = 0;
        this._derivedFont = this.getFont().deriveFont(1);
        FontMetrics fm = this.getFontMetrics(this._derivedFont);
        this._cal.set(2, this._cal.getMinimum(2));
        this._cal.set(5, this._cal.getActualMinimum(5));
        for (int i = 0; i < this._cal.getMaximum(2); ++i) {
            int currDays;
            currWidth = fm.stringWidth(_monthsOfTheYear[i]);
            if (currWidth > longestMonthWidth) {
                longestMonthWidth = currWidth;
            }
            if ((currDays = this._cal.getActualMaximum(5)) > daysInLongestMonth) {
                longestMonth = this._cal.get(2);
                daysInLongestMonth = currDays;
            }
            this._cal.add(2, 1);
        }
        this._boxHeight = fm.getHeight();
        for (String dayOfTheWeek : this._daysOfTheWeek) {
            currWidth = fm.stringWidth(dayOfTheWeek);
            if (currWidth <= this._boxWidth) continue;
            this._boxWidth = currWidth;
        }
        this._cal.set(2, longestMonth);
        this._cal.set(5, this._cal.getActualMinimum(5));
        for (int i = 0; i < daysInLongestMonth; ++i) {
            currWidth = fm.stringWidth(_dayOfMonthFormatter.format(this._cal.getTime()));
            if (currWidth > this._boxWidth) {
                this._boxWidth = currWidth;
            }
            this._cal.add(5, 1);
        }
        this._monthBoxHeight = this._boxHeight;
        if (this._traversable && (newHeight = this._monthDownImage.getIconHeight() + this._arrowPaddingY + this._arrowPaddingY) > this._monthBoxHeight) {
            this._monthBoxHeight = newHeight;
        }
        this._dim.width = (this._boxWidth + 2 * this._boxPaddingX) * 7;
        if (this._dim.width < longestMonthWidth) {
            double diff = longestMonthWidth - this._dim.width;
            if (this._traversable) {
                diff += (double)(this._monthDownImage.getIconWidth() + this._monthUpImage.getIconWidth() + this._arrowPaddingX * 4);
            }
            this._boxWidth = (int)((double)this._boxWidth + Math.ceil(diff / 7.0));
            this._dim.width = (this._boxWidth + 2 * this._boxPaddingX) * 7;
        }
        this._calendarWidth = (this._boxWidth + 2 * this._boxPaddingX) * 7;
        this._calendarHeight = (this._boxPaddingY + this._boxHeight + this._boxPaddingY) * 7 + (this._boxPaddingY + this._monthBoxHeight + this._boxPaddingY);
        this._dim.height = this._calendarHeight * this._minCalRows + 10 * (this._minCalRows - 1);
        this._dim.width = this._calendarWidth * this._minCalCols + 10 * (this._minCalCols - 1);
        Insets insets = this.getInsets();
        this._dim.width += insets.left + insets.right;
        this._dim.height += insets.top + insets.bottom;
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        this.calculateNumDisplayedCals();
        this.calculateStartPosition();
        if (this._startSelectedDate != -1L || this._endSelectedDate != -1L) {
            if (this._startSelectedDate > this._lastDisplayedDate || this._startSelectedDate < this._firstDisplayedDate) {
                this.ensureDateVisible(this._startSelectedDate);
            } else {
                this.calculateDirtyRectForSelection();
            }
        }
    }

    private void updateToday() {
        this._cal.setTimeInMillis(this._today);
        this._cal.add(5, 1);
        this._today = this._cal.getTimeInMillis();
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        this.repaint();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        this.updateIfNecessary();
        return new Dimension(this._dim);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void setBorder(Border border) {
        super.setBorder(border);
        this._dirty = true;
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this._dirty = true;
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setComponentOrientation(ComponentOrientation o) {
        super.setComponentOrientation(o);
        this._ltr = o.isLeftToRight();
        this.calculateStartPosition();
        this.calculateDirtyRectForSelection();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this._dirty = true;
    }

    public void removeNotify() {
        this._todayTimer.stop();
        super.removeNotify();
    }

    public void addNotify() {
        super.addNotify();
        int secondsTillTomorrow = 86400;
        if (this._todayTimer == null) {
            this._todayTimer = new Timer(secondsTillTomorrow * 1000, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JXMonthView.this.updateToday();
                }
            });
        }
        this._cal.setTimeInMillis(System.currentTimeMillis());
        secondsTillTomorrow = secondsTillTomorrow - this._cal.get(11) * 3600 - this._cal.get(12) * 60 - this._cal.get(13);
        this._todayTimer.setInitialDelay(secondsTillTomorrow * 1000);
        this._todayTimer.start();
        this._cal.setTimeInMillis(this._firstDisplayedDate);
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2;
        Object oldAAValue = null;
        Graphics2D graphics2D = g2 = g instanceof Graphics2D ? (Graphics2D)g : null;
        if (g2 != null && this._antiAlias) {
            oldAAValue = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        Rectangle clip = g.getClipBounds();
        this.updateIfNecessary();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
        }
        g.setColor(this.getForeground());
        Color shadowColor = g.getColor();
        shadowColor = new Color(shadowColor.getRed(), shadowColor.getGreen(), shadowColor.getBlue(), 51);
        FontMetrics fm = g.getFontMetrics();
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        int y = this._startY;
        for (int row = 0; row < this._numCalRows; ++row) {
            int x = this._startX;
            this._bounds.x = 0;
            this._bounds.y = this._startY + row * (this._calendarHeight + 10);
            this._bounds.width = this.getWidth();
            this._bounds.height = this._calendarHeight;
            if (!this._bounds.intersects(clip)) {
                this._cal.add(2, this._numCalCols);
                y += this._calendarHeight + 10;
                continue;
            }
            for (int column = 0; column < this._numCalCols; ++column) {
                int tmpY;
                int tmpX;
                String monthName = _monthsOfTheYear[this._cal.get(2)];
                monthName = monthName + " " + this._cal.get(1);
                this._bounds.x = this._ltr ? x : x - this._calendarWidth;
                this._bounds.y = y + this._boxPaddingY;
                this._bounds.width = this._calendarWidth;
                this._bounds.height = this._monthBoxHeight;
                if (this._bounds.intersects(clip)) {
                    this.paintMonthStringBackground(g, this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
                    if (this._traversable) {
                        tmpX = this._bounds.x + this._arrowPaddingX;
                        tmpY = this._bounds.y + (this._bounds.height - this._monthDownImage.getIconHeight()) / 2;
                        g.drawImage(this._monthDownImage.getImage(), tmpX, tmpY, null);
                        tmpX = this._bounds.x + this._bounds.width - this._arrowPaddingX - this._monthUpImage.getIconWidth();
                        g.drawImage(this._monthUpImage.getImage(), tmpX, tmpY, null);
                    }
                    Font oldFont = this.getFont();
                    FontMetrics oldFM = fm;
                    g.setFont(this._derivedFont);
                    fm = this.getFontMetrics(this._derivedFont);
                    g.setColor(this._monthStringForeground);
                    tmpX = this._ltr ? x + this._calendarWidth / 2 - fm.stringWidth(monthName) / 2 : x - this._calendarWidth / 2 - fm.stringWidth(monthName) / 2 - 1;
                    tmpY = this._bounds.y + (this._monthBoxHeight - this._boxHeight) / 2 + fm.getAscent();
                    if ((this._dropShadowMask & 1) != 0) {
                        g.setColor(shadowColor);
                        g.drawString(monthName, tmpX + 1, tmpY + 1);
                        g.setColor(this._monthStringForeground);
                    }
                    g.drawString(monthName, tmpX, tmpY);
                    g.setFont(oldFont);
                    fm = oldFM;
                }
                g.setColor(this.getDaysOfTheWeekForeground());
                this._bounds.x = this._ltr ? x : x - this._calendarWidth;
                this._bounds.y = y + this._boxPaddingY + this._monthBoxHeight + this._boxPaddingY + this._boxPaddingY;
                this._bounds.width = this._calendarWidth;
                this._bounds.height = this._boxHeight;
                if (this._bounds.intersects(clip)) {
                    this._cal.set(5, this._cal.getActualMinimum(5));
                    int dayIndex = this._firstDayOfWeek - 1;
                    Font oldFont = g.getFont();
                    FontMetrics oldFM = fm;
                    g.setFont(this._derivedFont);
                    fm = this.getFontMetrics(this._derivedFont);
                    for (int i = 0; i < 7; ++i) {
                        tmpX = this._ltr ? x + i * (this._boxPaddingX + this._boxWidth + this._boxPaddingX) + this._boxPaddingX + this._boxWidth / 2 - fm.stringWidth(this._daysOfTheWeek[dayIndex]) / 2 : x - i * (this._boxPaddingX + this._boxWidth + this._boxPaddingX) - this._boxPaddingX - this._boxWidth / 2 - fm.stringWidth(this._daysOfTheWeek[dayIndex]) / 2;
                        tmpY = this._bounds.y + fm.getAscent();
                        if ((this._dropShadowMask & 4) != 0) {
                            g.setColor(shadowColor);
                            g.drawString(this._daysOfTheWeek[dayIndex], tmpX + 1, tmpY + 1);
                            g.setColor(this.getDaysOfTheWeekForeground());
                        }
                        g.drawString(this._daysOfTheWeek[dayIndex], tmpX, tmpY);
                        if (++dayIndex != 7) continue;
                        dayIndex = 0;
                    }
                    g.setFont(oldFont);
                    fm = oldFM;
                }
                this._bounds.x = this._startX + (this._ltr ? column * (this._calendarWidth + 10) : -(column * (this._calendarWidth + 10) + this._calendarWidth));
                this._bounds.y = this._startY + row * (this._calendarHeight + 10);
                this._bounds.width = this._calendarWidth;
                this._bounds.height = this._calendarHeight;
                if (this._bounds.intersects(clip)) {
                    this.paintMonth(g);
                } else {
                    this._cal.add(2, 1);
                }
                x += this._ltr ? this._calendarWidth + 10 : -(this._calendarWidth + 10);
            }
            y += this._calendarHeight + 10;
        }
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        if (g2 != null && this._antiAlias) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAAValue);
        }
    }

    private void paintMonth(Graphics g) {
        int days = this._cal.getActualMaximum(5);
        Rectangle clip = g.getClipBounds();
        for (int i = 0; i < days; ++i) {
            this.calculateBoundsForDay(this._bounds);
            if (this._bounds.intersects(clip)) {
                long day = this._cal.getTimeInMillis();
                if (this.isSelectedDate(day) && this._selectionMode == 1) {
                    this._dirtyRect.x = this._bounds.x;
                    this._dirtyRect.y = this._bounds.y;
                    this._dirtyRect.width = this._bounds.width;
                    this._dirtyRect.height = this._bounds.height;
                }
                this.paintDayBackground(g, this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height, day);
                this.paintDayForeground(g, this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height, day);
            }
            this._cal.add(5, 1);
        }
    }

    protected void paintMonthStringBackground(Graphics g, int x, int y, int width, int height) {
        x = this._ltr ? x + this._monthStringInsets.left : x + this._monthStringInsets.right;
        width = width - this._monthStringInsets.left - this._monthStringInsets.right;
        height = height - this._monthStringInsets.top - this._monthStringInsets.bottom;
        Graphics2D g2 = (Graphics2D)g;
        GradientPaint gp = new GradientPaint(x, (y += this._monthStringInsets.top) + height, new Color(238, 238, 238), x, y, new Color(204, 204, 204));
        g2.setPaint(gp);
        g2.fillRect(x, y, width - 1, height - 1);
        g2.setPaint(new Color(153, 153, 153));
        g2.drawRect(x, y, width - 1, height - 1);
    }

    protected void paintDayBackground(Graphics g, int x, int y, int width, int height, long date) {
        if (this.isSelectedDate(date)) {
            g.setColor(this.getSelectedBackground());
            g.fillRect(x, y, width, height);
        }
        if (this.isToday(date)) {
            GradientPaint gp = new GradientPaint(x, y, new Color(91, 123, 145), x, y + height, new Color(68, 86, 98));
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(gp);
            g2.drawRect(x, y, width - 1, height - 1);
        }
    }

    protected void paintDayForeground(Graphics g, int x, int y, int width, int height, long date) {
        String numericDay = _dayOfMonthFormatter.format(date);
        g.setColor(this.getDayForeground(this.getDayOfTheWeek()));
        if (this.isFlaggedDate(date)) {
            Font oldFont = this.getFont();
            g.setFont(this._derivedFont);
            FontMetrics fm = this.getFontMetrics(this._derivedFont);
            g.drawString(numericDay, this._ltr ? x + this._boxPaddingX + this._boxWidth - fm.stringWidth(numericDay) : x + this._boxPaddingX + this._boxWidth - fm.stringWidth(numericDay) - 1, y + this._boxPaddingY + fm.getAscent());
            g.setFont(oldFont);
        } else {
            FontMetrics fm = g.getFontMetrics();
            g.drawString(numericDay, this._ltr ? x + this._boxPaddingX + this._boxWidth - fm.stringWidth(numericDay) : x + this._boxPaddingX + this._boxWidth - fm.stringWidth(numericDay) - 1, y + this._boxPaddingY + fm.getAscent());
        }
    }

    protected boolean isSelectedDate(long date) {
        return date >= this._startSelectedDate && date <= this._endSelectedDate;
    }

    protected boolean isToday(long date) {
        return date == this._today;
    }

    private void calculateNumDisplayedCals() {
        int oldNumCalCols = this._numCalCols;
        int oldNumCalRows = this._numCalRows;
        this._numCalCols = 1;
        this._numCalCols += (this.getWidth() - this._calendarWidth) / (this._calendarWidth + 10);
        this._numCalRows = 1;
        this._numCalRows += (this.getHeight() - this._calendarHeight) / (this._calendarHeight + 10);
        if (oldNumCalCols != this._numCalCols || oldNumCalRows != this._numCalRows) {
            this.calculateLastDisplayedDate();
        }
    }

    private void calculateStartPosition() {
        this._startX = (this.getWidth() - (this._calendarWidth * this._numCalCols + 10 * (this._numCalCols - 1))) / 2;
        if (!this._ltr) {
            this._startX = this.getWidth() - this._startX;
        }
        this._startY = (this.getHeight() - (this._calendarHeight * this._numCalRows + 10 * (this._numCalRows - 1))) / 2;
    }

    private void calculateBoundsForDay(Rectangle bounds) {
        int year = this._cal.get(1);
        int month = this._cal.get(2);
        int dayOfWeek = this._cal.get(7);
        int weekOfMonth = this._cal.get(4);
        int diffMonths = month - this._firstDisplayedMonth + (year - this._firstDisplayedYear) * 12;
        int calRowIndex = diffMonths / this._numCalCols;
        int calColIndex = diffMonths - calRowIndex * this._numCalCols;
        bounds.x = dayOfWeek - this._firstDayOfWeek;
        if (bounds.x < 0) {
            bounds.x += 7;
        }
        bounds.x = this._ltr ? bounds.x * (this._boxPaddingX + this._boxWidth + this._boxPaddingX) : (bounds.x + 1) * (this._boxPaddingX + this._boxWidth + this._boxPaddingX);
        bounds.x += calColIndex * (this._calendarWidth + 10);
        bounds.x = this._ltr ? this._startX + bounds.x : this._startX - bounds.x;
        bounds.y = this._boxPaddingY + this._monthBoxHeight + this._boxPaddingY + this._boxPaddingY + this._boxHeight + this._boxPaddingY;
        bounds.y += this._startY + calRowIndex * (this._calendarHeight + 10);
        bounds.y += (weekOfMonth - 1) * (this._boxPaddingY + this._boxHeight + this._boxPaddingY);
        bounds.width = this._boxPaddingX + this._boxWidth + this._boxPaddingX;
        bounds.height = this._boxPaddingY + this._boxHeight + this._boxPaddingY;
    }

    public long getDayAt(int x, int y) {
        int daysToAdd;
        if (this._ltr ? this._startX > x : this._startX < x || this._startY > y) {
            return -1L;
        }
        int calCol = (this._ltr ? x - this._startX : this._startX - x) / (this._calendarWidth + 10);
        int calRow = (y - this._startY) / (this._calendarHeight + 10);
        if (calRow > this._numCalRows - 1 || calCol > this._numCalCols - 1) {
            return -1L;
        }
        int row = 1;
        row += (y - this._startY - calRow * (this._calendarHeight + 10) - (this._boxPaddingY + this._monthBoxHeight + this._boxPaddingY)) / (this._boxPaddingY + this._boxHeight + this._boxPaddingY);
        if ((row -= 2) < 0 || row > 5) {
            return -1L;
        }
        int col = ((this._ltr ? x - this._startX : this._startX - x) - calCol * (this._calendarWidth + 10)) / (this._boxPaddingX + this._boxWidth + this._boxPaddingX);
        if (col > 6) {
            return -1L;
        }
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        this._cal.add(2, calCol + calRow * this._numCalCols);
        int dayOfWeek = this._cal.get(7);
        int firstDayIndex = dayOfWeek - this._firstDayOfWeek;
        if (firstDayIndex < 0) {
            firstDayIndex += 7;
        }
        if ((daysToAdd = row * 7 + (col - firstDayIndex)) < 0 || daysToAdd > this._cal.getActualMaximum(5) - 1) {
            return -1L;
        }
        this._cal.add(5, daysToAdd);
        long selected = this._cal.getTimeInMillis();
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        return selected;
    }

    protected int getTraversableButtonAt(int x, int y) {
        if (this._ltr ? this._startX > x : this._startX < x || this._startY > y) {
            return -1;
        }
        int calCol = (this._ltr ? x - this._startX : this._startX - x) / (this._calendarWidth + 10);
        int calRow = (y - this._startY) / (this._calendarHeight + 10);
        if (calRow > this._numCalRows - 1 || calCol > this._numCalCols - 1) {
            return -1;
        }
        if ((y = y - this._startY - calRow * (this._calendarHeight + 10) - this._boxPaddingY) < this._arrowPaddingY || y > this._monthBoxHeight - this._arrowPaddingY) {
            return -1;
        }
        x = (this._ltr ? x - this._startX : this._startX - x) - calCol * (this._calendarWidth + 10);
        if (x > this._arrowPaddingX && x < this._arrowPaddingX + this._monthDownImage.getIconWidth() + this._arrowPaddingX) {
            return 1;
        }
        if (x > this._calendarWidth - this._arrowPaddingX * 2 - this._monthUpImage.getIconWidth() && x < this._calendarWidth - this._arrowPaddingX) {
            return 2;
        }
        return -1;
    }

    private void calculateDirtyRectForSelection() {
        if (this._startSelectedDate == -1L || this._endSelectedDate == -1L) {
            this._dirtyRect.x = 0;
            this._dirtyRect.y = 0;
            this._dirtyRect.width = 0;
            this._dirtyRect.height = 0;
        } else {
            this._cal.setTimeInMillis(this._startSelectedDate);
            this.calculateBoundsForDay(this._dirtyRect);
            this._cal.add(5, 1);
            while (this._cal.getTimeInMillis() <= this._endSelectedDate) {
                this.calculateBoundsForDay(this._bounds);
                Rectangle tmpRect = this._dirtyRect.union(this._bounds);
                this._dirtyRect.x = tmpRect.x;
                this._dirtyRect.y = tmpRect.y;
                this._dirtyRect.width = tmpRect.width;
                this._dirtyRect.height = tmpRect.height;
                this._cal.add(5, 1);
            }
            this._cal.setTimeInMillis(this._firstDisplayedDate);
        }
    }

    public String getActionCommand() {
        return this._actionCommand;
    }

    public void setActionCommand(String actionCommand) {
        this._actionCommand = actionCommand;
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionPerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                e = new ActionEvent(this, 1001, this._actionCommand);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        int id;
        this._usingKeyboard = false;
        if (!this.isEnabled()) {
            return;
        }
        if (!this.hasFocus() && this.isFocusable()) {
            this.requestFocusInWindow();
        }
        if ((id = e.getID()) == 501 && this._traversable) {
            int arrowType = this.getTraversableButtonAt(e.getX(), e.getY());
            if (arrowType == 1) {
                this.setFirstDisplayedDate(DateUtils.getPreviousMonth(this.getFirstDisplayedDate()));
                return;
            }
            if (arrowType == 2) {
                this.setFirstDisplayedDate(DateUtils.getNextMonth(this.getFirstDisplayedDate()));
                return;
            }
        }
        if (this._selectionMode == 0) {
            return;
        }
        if (id == 501) {
            long selected = this.getDayAt(e.getX(), e.getY());
            if (selected == -1L) {
                return;
            }
            this._startSelectedDate = selected;
            this._endSelectedDate = selected;
            if (this._selectionMode == 2 || this._selectionMode == 3) {
                this._pivotDate = selected;
            }
            this._cal.setTimeInMillis(selected);
            this.calculateBoundsForDay(this._bounds);
            this._cal.setTimeInMillis(this._firstDisplayedDate);
            this.repaint(this._dirtyRect);
            this.repaint(this._bounds);
            this._dirtyRect.x = this._bounds.x;
            this._dirtyRect.y = this._bounds.y;
            this._dirtyRect.width = this._bounds.width;
            this._dirtyRect.height = this._bounds.height;
            this._asKirkWouldSay_FIRE = true;
        } else if (id == 502) {
            if (this._asKirkWouldSay_FIRE) {
                this.fireActionPerformed();
            }
            this._asKirkWouldSay_FIRE = false;
        }
        super.processMouseEvent(e);
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        this._usingKeyboard = false;
        if (!this.isEnabled() || this._selectionMode == 0) {
            return;
        }
        int id = e.getID();
        if (id == 506) {
            int y;
            int x = e.getX();
            long selected = this.getDayAt(x, y = e.getY());
            if (selected == -1L) {
                return;
            }
            long oldStart = this._startSelectedDate;
            long oldEnd = this._endSelectedDate;
            if (this._selectionMode == 1) {
                if (selected == oldStart) {
                    return;
                }
                this._startSelectedDate = selected;
                this._endSelectedDate = selected;
            } else if (selected <= this._pivotDate) {
                this._startSelectedDate = selected;
                this._endSelectedDate = this._pivotDate;
            } else if (selected > this._pivotDate) {
                this._startSelectedDate = this._pivotDate;
                this._endSelectedDate = selected;
            }
            if (this._selectionMode == 3) {
                long start = selected > this._pivotDate ? this._pivotDate : selected;
                long end = selected > this._pivotDate ? selected : this._pivotDate;
                this._cal.setTimeInMillis(start);
                int count = 1;
                while (this._cal.getTimeInMillis() < end) {
                    this._cal.add(5, 1);
                    ++count;
                }
                if (count > 7) {
                    int daysTillEnd;
                    this._cal.setTimeInMillis(start);
                    int dayOfWeek = this._cal.get(7);
                    int daysFromStart = dayOfWeek - this._firstDayOfWeek;
                    if (daysFromStart < 0) {
                        daysFromStart += 7;
                    }
                    this._cal.add(5, -daysFromStart);
                    this._startSelectedDate = this._cal.getTimeInMillis();
                    this._cal.setTimeInMillis(end);
                    dayOfWeek = this._cal.get(7);
                    int lastDayOfWeek = this._firstDayOfWeek - 1;
                    if (lastDayOfWeek == 0) {
                        lastDayOfWeek = 7;
                    }
                    if ((daysTillEnd = lastDayOfWeek - dayOfWeek) < 0) {
                        daysTillEnd += 7;
                    }
                    this._cal.add(5, daysTillEnd);
                    this._endSelectedDate = this._cal.getTimeInMillis();
                }
            }
            if (oldStart == this._startSelectedDate && oldEnd == this._endSelectedDate) {
                return;
            }
            this.repaint(this._dirtyRect);
            this.calculateDirtyRectForSelection();
            this.repaint(this._dirtyRect);
            this._asKirkWouldSay_FIRE = true;
        }
        super.processMouseMotionEvent(e);
    }

    private class KeyboardAction
    extends AbstractAction {
        public static final int ACCEPT_SELECTION = 0;
        public static final int CANCEL_SELECTION = 1;
        public static final int SELECT_PREVIOUS_DAY = 2;
        public static final int SELECT_NEXT_DAY = 3;
        public static final int SELECT_DAY_PREVIOUS_WEEK = 4;
        public static final int SELECT_DAY_NEXT_WEEK = 5;
        public static final int ADD_PREVIOUS_DAY = 6;
        public static final int ADD_NEXT_DAY = 7;
        public static final int ADD_TO_PREVIOUS_WEEK = 8;
        public static final int ADD_TO_NEXT_WEEK = 9;
        private int action;

        public KeyboardAction(int action) {
            this.action = action;
        }

        public void actionPerformed(ActionEvent ev) {
            int selectionMode = JXMonthView.this.getSelectionMode();
            if (JXMonthView.this._startSelectedDate != -1L && selectionMode != 0) {
                if (!JXMonthView.this._usingKeyboard) {
                    JXMonthView.this._originalDateSpan = JXMonthView.this.getSelectedDateSpan();
                }
                if (this.action >= 0 && this.action <= 1 && JXMonthView.this._usingKeyboard) {
                    if (this.action == 1) {
                        JXMonthView.this.setSelectedDateSpan(JXMonthView.this._originalDateSpan);
                        JXMonthView.this.fireActionPerformed();
                    } else {
                        JXMonthView.this.setSelectedDateSpan(JXMonthView.this.getSelectedDateSpan());
                        JXMonthView.this.fireActionPerformed();
                    }
                    JXMonthView.this._usingKeyboard = false;
                } else if (this.action >= 2 && this.action <= 5) {
                    JXMonthView.this._usingKeyboard = true;
                    this.traverse(this.action);
                } else if (selectionMode >= 2 && this.action >= 6 && this.action <= 9) {
                    JXMonthView.this._usingKeyboard = true;
                    this.addToSelection(this.action);
                }
            }
        }

        private void traverse(int action) {
            JXMonthView.this._cal.setTimeInMillis(JXMonthView.this._startSelectedDate);
            switch (action) {
                case 2: {
                    JXMonthView.this._cal.add(5, -1);
                    break;
                }
                case 3: {
                    JXMonthView.this._cal.add(5, 1);
                    break;
                }
                case 4: {
                    JXMonthView.this._cal.add(5, -7);
                    break;
                }
                case 5: {
                    JXMonthView.this._cal.add(5, 7);
                }
            }
            long newStartDate = JXMonthView.this._cal.getTimeInMillis();
            if (newStartDate != JXMonthView.this._startSelectedDate) {
                JXMonthView.this.setSelectedDateSpan(new DateSpan(newStartDate, newStartDate));
                JXMonthView.this.ensureDateVisible(newStartDate);
            }
            JXMonthView.this._cal.setTimeInMillis(JXMonthView.this._firstDisplayedDate);
        }

        private void addToSelection(int action) {
            long newStartDate = JXMonthView.this._startSelectedDate;
            long newEndDate = JXMonthView.this._endSelectedDate;
            boolean isForward = true;
            switch (action) {
                case 6: {
                    JXMonthView.this._cal.setTimeInMillis(JXMonthView.this._startSelectedDate);
                    JXMonthView.this._cal.add(5, -1);
                    newStartDate = JXMonthView.this._cal.getTimeInMillis();
                    isForward = false;
                    break;
                }
                case 7: {
                    JXMonthView.this._cal.setTimeInMillis(JXMonthView.this._endSelectedDate);
                    JXMonthView.this._cal.add(5, 1);
                    newEndDate = JXMonthView.this._cal.getTimeInMillis();
                    break;
                }
                case 8: {
                    JXMonthView.this._cal.setTimeInMillis(JXMonthView.this._startSelectedDate);
                    JXMonthView.this._cal.add(5, -7);
                    newStartDate = JXMonthView.this._cal.getTimeInMillis();
                    isForward = false;
                    break;
                }
                case 9: {
                    JXMonthView.this._cal.setTimeInMillis(JXMonthView.this._endSelectedDate);
                    JXMonthView.this._cal.add(5, 7);
                    newEndDate = JXMonthView.this._cal.getTimeInMillis();
                }
            }
            if (newStartDate != JXMonthView.this._startSelectedDate || newEndDate != JXMonthView.this._endSelectedDate) {
                JXMonthView.this.setSelectedDateSpan(new DateSpan(newStartDate, newEndDate));
                JXMonthView.this.ensureDateVisible(isForward ? newEndDate : newStartDate);
            }
            JXMonthView.this._cal.setTimeInMillis(JXMonthView.this._firstDisplayedDate);
        }
    }
}

