/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.color;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.color.ColorUtil;

public class ColorSelectionButton
extends JButton {
    JDialog dialog = null;
    private JColorChooser chooser = null;
    BufferedImage colorwell;

    public ColorSelectionButton() {
        this.setBackground(Color.red);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("new color selection button");
                if (ColorSelectionButton.this.dialog == null) {
                    ColorSelectionButton.this.dialog = JColorChooser.createDialog(ColorSelectionButton.this, "Choose a color", true, ColorSelectionButton.this.getChooser(), new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                        }
                    }, new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                        }
                    });
                    ColorSelectionButton.this.dialog.getContentPane().add(ColorSelectionButton.this.getChooser());
                    ColorSelectionButton.this.getChooser().getSelectionModel().addChangeListener(new ColorChangeListener(ColorSelectionButton.this));
                }
                ColorSelectionButton.this.dialog.setVisible(true);
                Color color = ColorSelectionButton.this.getChooser().getColor();
                if (color != null) {
                    ColorSelectionButton.this.setBackground(color);
                }
            }
        });
        this.setContentAreaFilled(false);
        this.setOpaque(false);
        try {
            this.colorwell = ImageIO.read(this.getClass().getResourceAsStream("colorwell.png"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void paintComponent(Graphics g) {
        Insets ins = new Insets(5, 5, 5, 5);
        if (this.colorwell != null) {
            ColorUtil.tileStretchPaint(g, this, this.colorwell, ins);
        }
        g.setColor(ColorUtil.removeAlpha(this.getBackground()));
        g.fillRect(ins.left, ins.top, this.getWidth() - ins.left - ins.right, this.getHeight() - ins.top - ins.bottom);
        g.setColor(ColorUtil.setBrightness(this.getBackground(), 0.85f));
        g.drawRect(ins.left, ins.top, this.getWidth() - ins.left - ins.right - 1, this.getHeight() - ins.top - ins.bottom - 1);
        g.drawRect(ins.left + 1, ins.top + 1, this.getWidth() - ins.left - ins.right - 3, this.getHeight() - ins.top - ins.bottom - 3);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Color Button Test");
        frame.setDefaultCloseOperation(3);
        JPanel panel = new JPanel();
        panel.add(new ColorSelectionButton());
        panel.add(new JLabel("ColorSelectionButton test"));
        frame.add(panel);
        frame.pack();
        frame.setVisible(true);
    }

    public JColorChooser getChooser() {
        if (this.chooser == null) {
            this.chooser = new JColorChooser();
        }
        return this.chooser;
    }

    private class ColorChangeListener
    implements ChangeListener {
        public ColorSelectionButton button;

        public ColorChangeListener(ColorSelectionButton button) {
            this.button = button;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            System.out.println("color changed");
            this.button.setBackground(this.button.getChooser().getColor());
        }
    }
}

