/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.Filter;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.SortKey;
import org.jdesktop.swingx.decorator.SortOrder;

public abstract class Sorter
extends Filter {
    private boolean ascending = true;
    private Collator collator;
    private Locale currentLocale;
    private Comparator comparator;

    public Sorter() {
        this(0, true);
    }

    public Sorter(int col, boolean ascending) {
        this(col, ascending, null);
    }

    public Sorter(int col, boolean ascending, Comparator comparator) {
        super(col);
        this.comparator = comparator;
        this.setAscending(ascending);
    }

    protected void refresh(boolean reset) {
        this.refreshCollator();
        super.refresh(reset);
    }

    protected void refreshCollator() {
        if (!Locale.getDefault().equals(this.currentLocale)) {
            this.currentLocale = Locale.getDefault();
            this.collator = Collator.getInstance();
        }
    }

    protected Collator getCollator() {
        return this.collator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
        this.refresh();
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    protected abstract void adopt(Sorter var1);

    public void interpose(FilterPipeline filters, ComponentAdapter adapter, Sorter oldSorter) {
        if (filters != null) {
            filters.setSorter(this);
        } else {
            this.releasePipeline();
            this.assign(adapter);
            this.adopt(oldSorter);
            this.assign(filters);
            this.refresh(oldSorter == null);
        }
    }

    protected void releasePipeline() {
        if (this.getPipeline() != null) {
            this.getPipeline().setSorter(null);
            this.assign((FilterPipeline)null);
        }
    }

    public int compare(int row1, int row2) {
        int result = this.compare(row1, row2, this.getColumnIndex());
        return this.ascending ? result : -result;
    }

    private int compare(int row1, int row2, int col) {
        Object o1 = this.getInputValue(row1, col);
        Object o2 = this.getInputValue(row2, col);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (this.comparator != null) {
            return this.comparator.compare(o1, o2);
        }
        if (o1.getClass() == String.class && o2.getClass() == String.class) {
            return this.collator.compare((String)o1, (String)o2);
        }
        if (o1.getClass().isInstance(o2) && o1 instanceof Comparable) {
            Comparable c1 = (Comparable)o1;
            return c1.compareTo(o2);
        }
        if (o2.getClass().isInstance(o1) && o2 instanceof Comparable) {
            Comparable c2 = (Comparable)o2;
            return -c2.compareTo(o1);
        }
        return this.collator.compare(o1.toString(), o2.toString());
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
        this.refresh();
    }

    public SortOrder getSortOrder() {
        return this.isAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING;
    }

    public void setSortKey(SortKey sortKey) {
        if (sortKey == null || !sortKey.getSortOrder().isSorted()) {
            throw new IllegalArgumentException("SortKey must not be null with sorted SortOrder");
        }
        boolean forceRefresh = false;
        if (this.ascending != sortKey.getSortOrder().isAscending()) {
            forceRefresh = true;
            this.ascending = sortKey.getSortOrder().isAscending();
        }
        if (this.comparator != null && !((Object)this.comparator).equals(sortKey.getComparator()) || this.comparator == null && sortKey.getComparator() != null) {
            forceRefresh = true;
            this.comparator = sortKey.getComparator();
        }
        if (this.getColumnIndex() != sortKey.getColumn()) {
            forceRefresh = false;
            this.setColumnIndex(sortKey.getColumn());
        }
        if (forceRefresh) {
            this.refresh();
        }
    }

    public SortKey getSortKey() {
        return new SortKey(this.getSortOrder(), this.getColumnIndex(), this.getComparator());
    }

    public void toggle() {
        this.ascending = !this.ascending;
        this.refresh();
    }
}

