/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter.gradient;

import java.awt.Paint;
import java.awt.geom.Point2D;
import org.apache.batik.ext.awt.RadialGradientPaint;
import org.jdesktop.swingx.painter.gradient.AbstractGradientPainter;
import org.jdesktop.swingx.util.Resize;

public class RadialGradientPainter
extends AbstractGradientPainter {
    private RadialGradientPaint paint;
    private Resize resizeRadius = Resize.BOTH;

    public RadialGradientPainter() {
    }

    public RadialGradientPainter(RadialGradientPaint paint) {
        this.paint = paint;
    }

    public void setGradientPaint(RadialGradientPaint paint) {
        RadialGradientPaint old = this.getGradientPaint();
        this.paint = paint;
        this.firePropertyChange("gradientPaint", old, this.getGradientPaint());
    }

    public RadialGradientPaint getGradientPaint() {
        return this.paint;
    }

    public void setResizeRadius(Resize r) {
        Resize old = this.getResizeRadius();
        this.resizeRadius = r;
        this.firePropertyChange("resizeRadius", (Object)old, (Object)this.getResizeRadius());
    }

    public Resize getResizeRadius() {
        return this.resizeRadius;
    }

    protected Paint calculateSizedPaint(int width, int height) {
        RadialGradientPaint paint = this.getGradientPaint();
        if (paint == null) {
            return null;
        }
        Point2D centerPoint = paint.getCenterPoint();
        Point2D focusPoint = paint.getFocusPoint();
        double x1 = this.isResizeHorizontal() ? centerPoint.getX() * (double)width : centerPoint.getX();
        double y1 = this.isResizeVertical() ? centerPoint.getY() * (double)height : centerPoint.getY();
        double x2 = this.isResizeHorizontal() ? focusPoint.getX() * (double)width : focusPoint.getX();
        double y2 = this.isResizeVertical() ? focusPoint.getY() * (double)height : focusPoint.getY();
        centerPoint = new Point2D.Double(x1, y1);
        focusPoint = new Point2D.Double(x2, y2);
        float radius = paint.getRadius();
        Resize r = this.getResizeRadius();
        r = r == null ? Resize.BOTH : r;
        switch (r) {
            case HORIZONTAL: {
                radius *= (float)width;
                break;
            }
            case VERTICAL: {
                radius *= (float)height;
                break;
            }
            case BOTH: {
                radius *= (float)Math.min(width, height);
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new AssertionError((Object)"Cannot happen");
            }
        }
        return new RadialGradientPaint(centerPoint, radius, focusPoint, paint.getFractions(), paint.getColors(), paint.getCycleMethod(), paint.getColorSpace(), paint.getTransform());
    }
}

