/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXStatusBar;
import org.jdesktop.swingx.plaf.StatusBarUI;

public class BasicStatusBarUI
extends StatusBarUI {
    private JXStatusBar statusBar;
    private BufferedImage leftImage;
    private BufferedImage middleImage;
    private BufferedImage rightImage;

    public BasicStatusBarUI() {
        try {
            this.leftImage = ImageIO.read(this.getClass().getResource("resources/statusbar-left.png"));
            this.middleImage = ImageIO.read(this.getClass().getResource("resources/statusbar-middle.png"));
            this.rightImage = ImageIO.read(this.getClass().getResource("resources/statusbar-right.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicStatusBarUI();
    }

    public void installUI(JComponent c) {
        assert (c instanceof JXStatusBar);
        this.statusBar = (JXStatusBar)c;
        this.statusBar.setBorder(BorderFactory.createEmptyBorder(4, 5, 4, 22));
    }

    public void uninstallUI(JComponent c) {
        assert (c instanceof JXStatusBar);
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        if (this.statusBar.isOpaque()) {
            Graphics2D g2 = (Graphics2D)g;
            g2.drawImage(this.leftImage, 0, 0, this.leftImage.getWidth(), this.statusBar.getHeight(), null);
            g2.drawImage(this.middleImage, this.leftImage.getWidth(), 0, this.statusBar.getWidth() - this.leftImage.getWidth() - this.rightImage.getWidth(), this.statusBar.getHeight(), null);
            g2.drawImage(this.rightImage, this.statusBar.getWidth() - this.rightImage.getWidth(), 0, this.rightImage.getWidth(), this.statusBar.getHeight(), null);
        }
    }
}

