/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class DefaultTableColumnModelExt
extends DefaultTableColumnModel
implements TableColumnModelExt {
    private static final String IGNORE_EVENT = "TableColumnModelExt.ignoreEvent";
    private List allColumns = new ArrayList();
    private Set invisibleColumns = new HashSet();
    private Map oldIndexes = new HashMap();
    private VisibilityListener visibilityListener = new VisibilityListener();

    public List getColumns(boolean includeHidden) {
        if (includeHidden) {
            return new ArrayList(this.allColumns);
        }
        return Collections.list(this.getColumns());
    }

    public int getColumnCount(boolean includeHidden) {
        if (includeHidden) {
            return this.allColumns.size();
        }
        return this.getColumnCount();
    }

    public TableColumnExt getColumnExt(Object identifier) {
        for (TableColumn column : this.allColumns) {
            if (!(column instanceof TableColumnExt) || !identifier.equals(column.getIdentifier())) continue;
            return (TableColumnExt)column;
        }
        return null;
    }

    public Set getInvisibleColumns() {
        return new HashSet(this.invisibleColumns);
    }

    public boolean isRemovedToInvisibleEvent(int oldIndex) {
        Integer index = new Integer(oldIndex);
        return this.oldIndexes.containsValue(index);
    }

    public boolean isAddedFromInvisibleEvent(int newIndex) {
        if (!(this.getColumn(newIndex) instanceof TableColumnExt)) {
            return false;
        }
        return Boolean.TRUE.equals(((TableColumnExt)this.getColumn(newIndex)).getClientProperty(IGNORE_EVENT));
    }

    public void removeColumn(TableColumn column) {
        if (column instanceof TableColumnExt) {
            ((TableColumnExt)column).removePropertyChangeListener(this.visibilityListener);
        }
        this.invisibleColumns.remove(column);
        this.allColumns.remove(column);
        super.removeColumn(column);
    }

    public void addColumn(TableColumn aColumn) {
        boolean oldVisible = true;
        if (aColumn instanceof TableColumnExt) {
            TableColumnExt xColumn = (TableColumnExt)aColumn;
            oldVisible = xColumn.isVisible();
            xColumn.setVisible(true);
            xColumn.addPropertyChangeListener(this.visibilityListener);
        }
        this.allColumns.add(aColumn);
        super.addColumn(aColumn);
        if (aColumn instanceof TableColumnExt) {
            ((TableColumnExt)aColumn).setVisible(oldVisible);
        }
    }

    protected void moveToInvisible(TableColumnExt col) {
        int oldIndex = this.tableColumns.indexOf(col);
        this.invisibleColumns.add(col);
        this.oldIndexes.put(col, new Integer(oldIndex));
        super.removeColumn(col);
    }

    protected void moveToVisible(TableColumnExt col) {
        this.invisibleColumns.remove(col);
        Integer oldIndexInteger = (Integer)this.oldIndexes.get(col);
        int oldIndex = oldIndexInteger == null ? this.getColumnCount() : oldIndexInteger.intValue();
        this.oldIndexes.remove(col);
        col.putClientProperty(IGNORE_EVENT, Boolean.TRUE);
        super.addColumn(col);
        this.moveColumn(this.getColumnCount() - 1, Math.min(this.getColumnCount() - 1, oldIndex));
        col.putClientProperty(IGNORE_EVENT, null);
    }

    private final class VisibilityListener
    implements PropertyChangeListener {
        private VisibilityListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("visible")) {
                boolean oldValue = (Boolean)evt.getOldValue();
                boolean newValue = (Boolean)evt.getNewValue();
                TableColumnExt col = (TableColumnExt)evt.getSource();
                if (oldValue && !newValue) {
                    DefaultTableColumnModelExt.this.moveToInvisible(col);
                } else if (!oldValue && newValue) {
                    DefaultTableColumnModelExt.this.moveToVisible(col);
                }
            }
        }
    }
}

