/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.util.Date;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.LinkModel;

public class TableCellRenderers {
    private static HashMap typeMap = new HashMap();

    private static String getRendererClassName(Class columnClass) {
        String rendererClassName = (String)typeMap.get(columnClass);
        return rendererClassName != null ? rendererClassName : "javax.swing.table.DefaultTableCellRenderer";
    }

    public static void setDefaultRenderer(Class columnClass, String rendererClassName) {
        typeMap.put(columnClass, rendererClassName);
    }

    public static TableCellRenderer getNewDefaultRenderer(Class columnClass) {
        TableCellRenderer renderer = null;
        String rendererClassName = TableCellRenderers.getRendererClassName(columnClass);
        try {
            Class<?> rendererClass = Class.forName(rendererClassName);
            renderer = (TableCellRenderer)rendererClass.newInstance();
        }
        catch (Exception e) {
            renderer = new DefaultTableCellRenderer();
        }
        return renderer;
    }

    TableCellRenderers() {
    }

    static {
        typeMap.put(Number.class, "org.jdesktop.swingx.JXTable$NumberRenderer");
        typeMap.put(Double.class, "org.jdesktop.swingx.JXTable$DoubleRenderer");
        typeMap.put(Float.class, "org.jdesktop.swingx.JXTable$DoubleRenderer");
        typeMap.put(Date.class, "org.jdesktop.swingx.JXTable$DateRenderer");
        typeMap.put(Icon.class, "org.jdesktop.swingx.JXTable$IconRenderer");
        typeMap.put(Boolean.class, "org.jdesktop.swingx.JXTable$BooleanRenderer");
        typeMap.put(LinkModel.class, "org.jdesktop.swingx.LinkRenderer");
    }
}

