/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AccumulativeRunnable<T>
implements Runnable {
    private List<T> arguments = null;
    private Class<?> componentType = null;

    AccumulativeRunnable() {
    }

    protected abstract void run(T ... var1);

    @Override
    public final void run() {
        this.run(this.flush());
    }

    public final synchronized void add(T ... args) {
        if (this.componentType == null) {
            this.componentType = args.getClass().getComponentType();
        }
        boolean isSubmitted = true;
        if (this.arguments == null) {
            isSubmitted = false;
            this.arguments = new ArrayList<T>();
        }
        Collections.addAll(this.arguments, args);
        if (!isSubmitted) {
            this.submit();
        }
    }

    protected void submit() {
        SwingUtilities.invokeLater(this);
    }

    private final synchronized T[] flush() {
        List<Object> list = this.arguments;
        this.arguments = null;
        if (this.componentType == null) {
            this.componentType = Object.class;
        }
        Object[] args = (Object[])Array.newInstance(this.componentType, list.size());
        list.toArray(args);
        return args;
    }
}

