/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.Host;
import ch.kronospace.tools.DOSCommands;
import ch.kronospace.tools.JDOMTools;
import java.io.File;
import java.util.Vector;

public class ConfigParser {
    public static File app_data_dir = new File(DOSCommands.getUserApplicationDataDir(), "LogPsychoAnalyst");
    public static File hosts_dir = new File(app_data_dir, "hosts");
    public static Vector configs;
    private Host host = null;
    private File current_dir = null;
    private static String config_file_filename;

    static {
        if (!app_data_dir.exists()) {
            app_data_dir.mkdir();
        }
        configs = new Vector();
        config_file_filename = "config.xml";
    }

    public ConfigParser() {
        configs.clear();
        if (!hosts_dir.exists()) {
            return;
        }
        File[] f = hosts_dir.listFiles();
        int i = 0;
        while (i < f.length) {
            this.current_dir = f[i];
            File config_file = new File(this.current_dir, config_file_filename);
            if (config_file.exists()) {
                System.out.println(this.current_dir);
                this.parse(config_file);
            }
            ++i;
        }
        System.out.println("number of configurations: " + configs.size() + ".");
    }

    public static void addHost(Host h) {
        configs.add(h);
    }

    public static void removeHost(int index) {
        Host h = (Host)configs.remove(index);
        File config_file = new File(h.getConfigDirectory(), config_file_filename);
        File config_file_bak = new File(h.getConfigDirectory(), String.valueOf(config_file_filename) + ".bak");
        if (config_file_bak.exists()) {
            config_file_bak.delete();
        }
        config_file.renameTo(config_file_bak);
    }

    public void parse(File f) {
        if (!f.exists()) {
            return;
        }
        try {
            this.host = (Host)JDOMTools.createObject("ch.kronospace.logpsychoanalyst", f);
            this.host.setCurrentDirectory(this.current_dir);
            configs.add(this.host);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

