/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.CovadisTerminal;
import ch.kronospace.logpsychoanalyst.DailyActivityStorage;
import ch.kronospace.logpsychoanalyst.DailyActivityStorageOwner;
import ch.kronospace.logpsychoanalyst.HTTPStatisticElement;
import ch.kronospace.logpsychoanalyst.StatisticElement;
import ch.kronospace.logpsychoanalyst.StatisticElementArrayGetter;
import ch.kronospace.logpsychoanalyst.StatisticsTable;
import ch.kronospace.logpsychoanalyst.TerminalValidationStatus;
import ch.kronospace.logpsychoanalyst.TerminalValidationStatusGrantedFilter;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;

public class CovadisTerminalGroup
implements DailyActivityStorageOwner {
    private DailyActivityStorage daily_activity_card = new DailyActivityStorage();
    private DailyActivityStorage daily_activity_terminal = new DailyActivityStorage();
    private StatisticsTable terminals;
    private String name;
    public long nbr_granted;
    public static final Comparator COMPARATOR_GRANTED = new Comparator(){

        public int compare(Object o1, Object o2) {
            CovadisTerminalGroup t1 = (CovadisTerminalGroup)o1;
            CovadisTerminalGroup t2 = (CovadisTerminalGroup)o2;
            return (int)(t1.nbr_granted - t2.nbr_granted);
        }
    };
    public static final StatisticElementArrayGetter getter = new StatisticElementArrayGetter(){

        public String getValueName() {
            return "Cards";
        }

        public double[] getValues(DailyActivityStorage das, long first_date, long last_date) {
            StatisticElement[] full = das.getRange(first_date, last_date);
            double[] visits = new double[full.length];
            int i = 0;
            while (i < visits.length) {
                HTTPStatisticElement el = (HTTPStatisticElement)full[i];
                visits[i] = el.nbr_visits;
                ++i;
            }
            return visits;
        }
    };

    public CovadisTerminalGroup() {
        this.daily_activity_card.setEmptyActivity(new TerminalValidationStatus());
        this.daily_activity_terminal.setEmptyActivity(new TerminalValidationStatus());
        this.terminals = new StatisticsTable("Terminal authentication per terminal", "IFD", new TerminalValidationStatusGrantedFilter());
        this.nbr_granted = 0L;
    }

    public DailyActivityStorage getDailyActivityStorage() {
        return this.daily_activity_terminal;
    }

    public DailyActivityStorage getCardDailyActivityStorage() {
        return this.daily_activity_card;
    }

    public void mergeDailyActivity() {
        this.daily_activity_card.reset();
        this.daily_activity_terminal.reset();
        this.nbr_granted = 0L;
        Enumeration e = this.terminals.elements();
        while (e.hasMoreElements()) {
            CovadisTerminal t = (CovadisTerminal)e.nextElement();
            this.nbr_granted += t.nbr_granted;
            this.daily_activity_card.merge(t.getCardDailyActivityStorage());
            this.daily_activity_terminal.merge(t.getDailyActivityStorage());
        }
    }

    public void addCovadisTerminal(CovadisTerminal g) {
        this.terminals.put(g.getIFD(), g);
    }

    public Vector getCovadisTerminal() {
        return new Vector(this.terminals.values());
    }

    public CovadisTerminal getCovadisTerminal(String ifd) {
        return (CovadisTerminal)this.terminals.get(ifd);
    }

    public void setName(String name) {
        this.name = name;
        this.daily_activity_card.setName(name);
        this.daily_activity_terminal.setName(name);
    }

    public String getName() {
        return this.name;
    }
}

