/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.HTTPStatisticElement;
import ch.kronospace.logpsychoanalyst.StatisticElement;
import ch.kronospace.logpsychoanalyst.StatisticElementUpdater;
import ch.kronospace.logpsychoanalyst.logformat.LogFormat;
import java.util.Calendar;

public class DailyActivityStorage {
    int nbr_days_in_year = 366;
    private StatisticElement empty_activity = new HTTPStatisticElement();
    private long first_date = 0L;
    private int first_date_key = Integer.MAX_VALUE;
    private StatisticElement[] activity_days = new StatisticElement[0];
    private String name = "Untitled";
    private String short_name = null;
    private boolean debug = false;

    public DailyActivityStorage() {
    }

    public DailyActivityStorage(String name) {
        this.setName(name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setShortName(String short_name) {
        this.short_name = short_name;
    }

    public String getShortName() {
        if (this.short_name != null) {
            return this.short_name;
        }
        return this.getName();
    }

    public void setEmptyActivity(StatisticElement elem) {
        this.empty_activity = elem;
    }

    private final int getKey(long date) {
        return (int)(date / 86400000L);
    }

    private final int getKey(Calendar date) {
        return this.getKey(date.getTimeInMillis());
    }

    public void update(long date, StatisticElementUpdater updater) {
        int index = this.ensureCapacity(date);
        StatisticElement stored_elem = this.activity_days[index];
        if (stored_elem == null) {
            this.activity_days[index] = stored_elem = (StatisticElement)this.empty_activity.clone();
            if (this.debug) {
                System.out.println("in update:" + this.empty_activity.clone().getClass().getName() + " " + stored_elem.getClass().getName());
            }
        }
        updater.update(stored_elem);
    }

    public void reset() {
        int i = 0;
        while (i < this.activity_days.length) {
            this.activity_days[i].reset();
            ++i;
        }
    }

    public void merge(StatisticElement elem, Calendar date) {
        int index = this.ensureCapacity(date.getTimeInMillis());
        StatisticElement stored_elem = this.activity_days[index];
        if (stored_elem == null) {
            this.activity_days[index] = stored_elem = (StatisticElement)this.empty_activity.clone();
        }
        stored_elem.merge(elem);
    }

    public void merge(DailyActivityStorage das) {
        StatisticElement[] das_activity = das.getRange();
        Calendar das_current_date = das.getFirstDate();
        int i = 0;
        while (i < das_activity.length) {
            this.merge(das_activity[i], das_current_date);
            das_current_date.add(6, 1);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private int ensureCapacity(long date) {
        block2: {
            current_date_key = this.getKey(date);
            index = current_date_key - this.first_date_key;
            if (index >= 0) ** GOTO lbl17
            increment = -index;
            if (this.first_date_key == 0x7FFFFFFF) {
                increment = this.nbr_days_in_year;
            }
            array_temp = new StatisticElement[this.activity_days.length + increment];
            System.arraycopy(this.activity_days, 0, array_temp, increment, this.activity_days.length);
            this.activity_days = array_temp;
            this.first_date_key = current_date_key;
            index = 0;
            this.first_date = date;
            break block2;
lbl-1000:
            // 1 sources

            {
                array_temp = new StatisticElement[this.activity_days.length + this.activity_days.length];
                System.arraycopy(this.activity_days, 0, array_temp, 0, this.activity_days.length);
                this.activity_days = array_temp;
lbl17:
                // 2 sources

                ** while (index >= this.activity_days.length)
            }
        }
        return index;
    }

    public StatisticElement get(Calendar date) {
        int current_date_key = this.getKey(date);
        int index = current_date_key - this.first_date_key;
        if (index < 0 || index >= this.activity_days.length) {
            this.empty_activity.reset();
            return this.empty_activity;
        }
        StatisticElement elem = this.activity_days[index];
        if (elem == null) {
            this.empty_activity.reset();
            return this.empty_activity;
        }
        return elem;
    }

    public StatisticElement getForUpdate(Calendar date) {
        int index = this.ensureCapacity(date.getTimeInMillis());
        StatisticElement stored_elem = this.activity_days[index];
        if (stored_elem == null) {
            this.activity_days[index] = stored_elem = (StatisticElement)this.empty_activity.clone();
        }
        return stored_elem;
    }

    public StatisticElement[] getRange(Calendar range_date_start, Calendar range_date_stop) {
        return this.getRange(range_date_start.getTimeInMillis(), range_date_stop.getTimeInMillis());
    }

    public StatisticElement[] getRange(long range_date_start, long range_date_stop) {
        int index_start;
        int range_date_start_key = this.getKey(range_date_start);
        int range_date_stop_key = this.getKey(range_date_stop);
        int index_stop = range_date_stop_key - this.first_date_key;
        int number_of_days = index_stop - (index_start = range_date_start_key - this.first_date_key) + 1;
        if (number_of_days <= 0) {
            throw new RuntimeException("range_date_stop cannot be before range_date_start");
        }
        StatisticElement[] result = new StatisticElement[number_of_days];
        int index_start_ad = Math.max(0, index_start);
        int index_stop_ad = Math.min(this.activity_days.length - 1, index_stop);
        int index_start_res = Math.max(0, -index_start);
        int len = Math.min(result.length - index_start_res, Math.min(this.activity_days.length - index_start_ad, index_start_ad + index_stop_ad + 1));
        try {
            if (index_start_res >= 0 && index_start_res < result.length && index_start_ad < this.activity_days.length) {
                System.arraycopy(this.activity_days, index_start_ad, result, index_start_res, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Calendar first_date = Calendar.getInstance();
            Calendar end_date = Calendar.getInstance();
            first_date.setTimeInMillis(range_date_start);
            end_date.setTimeInMillis(range_date_stop);
            System.out.println("requested      range=" + LogFormat.df.format(first_date.getTime()) + " - " + LogFormat.df.format(end_date.getTime()));
            first_date.setTimeInMillis(this.first_date);
            end_date.setTimeInMillis(this.first_date);
            end_date.add(6, this.activity_days.length);
            System.out.println("array_activity range=" + LogFormat.df.format(first_date.getTime()) + " - " + LogFormat.df.format(end_date.getTime()));
            System.out.println("number_of_days=" + number_of_days);
            System.out.println("activity_days.length=" + this.activity_days.length);
            System.out.println("result.length=" + result.length);
            System.out.println("index_start_ad=" + index_start_ad);
            System.out.println("index_start_res=" + index_start_res);
            System.out.println("len=" + len);
            System.exit(-1);
        }
        int i = 0;
        while (i < result.length) {
            if (result[i] == null) {
                result[i] = this.empty_activity;
            }
            ++i;
        }
        this.empty_activity.reset();
        return result;
    }

    public StatisticElement[] getRange() {
        StatisticElement[] result = new StatisticElement[this.activity_days.length];
        System.arraycopy(this.activity_days, 0, result, 0, this.activity_days.length);
        int i = 0;
        while (i < result.length) {
            if (result[i] == null) {
                result[i] = this.empty_activity;
            }
            ++i;
        }
        this.empty_activity.reset();
        return result;
    }

    public Calendar getFirstDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.first_date);
        return cal;
    }

    public Calendar getLastDate() {
        Calendar c = this.getFirstDate();
        c.add(6, this.activity_days.length + 1);
        return c;
    }

    public String getName() {
        return this.name;
    }
}

