/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.DailyActivityStorage;
import ch.kronospace.logpsychoanalyst.HTTPStatisticElement;
import ch.kronospace.logpsychoanalyst.StatisticElement;
import ch.kronospace.logpsychoanalyst.StatisticElementArrayGetter;
import ch.kronospace.logpsychoanalyst.StatisticElementFullUpdater;
import java.util.Calendar;

public class DailyDownloadSpeed {
    StatisticElementFullUpdater stat_el_full_updater = new StatisticElementFullUpdater();
    public DailyActivityStorage total_download_speed_per_day;
    public StatisticElementArrayGetter getter_download_speed;

    public DailyDownloadSpeed() {
        this.stat_el_full_updater.nbr_visits = 1L;
        this.stat_el_full_updater.nbr_pages = 0L;
        this.stat_el_full_updater.nbr_hits = 0L;
        this.total_download_speed_per_day = new DailyActivityStorage();
        this.getter_download_speed = new StatisticElementArrayGetter(){

            public String getValueName() {
                return "Download speed";
            }

            public double[] getValues(DailyActivityStorage das, long first_date, long last_date) {
                StatisticElement[] full = das.getRange(first_date, last_date);
                double[] mean_download_speed = new double[full.length];
                int i = 0;
                while (i < mean_download_speed.length) {
                    HTTPStatisticElement el = (HTTPStatisticElement)full[i];
                    if (el.nbr_visits != 0L) {
                        mean_download_speed[i] = (double)el.size / (double)el.nbr_visits;
                    }
                    ++i;
                }
                return mean_download_speed;
            }
        };
    }

    public DailyActivityStorage getDailyActivityStorage() {
        return this.total_download_speed_per_day;
    }

    public void addVisit(long date, float download_speed) {
        this.stat_el_full_updater.size = (long)download_speed;
        this.total_download_speed_per_day.update(date, this.stat_el_full_updater);
    }

    public StatisticElement[] getMeanDownloadSpeed(Calendar date_start, Calendar date_stop) {
        StatisticElement[] full = this.total_download_speed_per_day.getRange(date_start, date_stop);
        StatisticElement[] mean_download_speed = new HTTPStatisticElement[full.length];
        int i = 0;
        while (i < mean_download_speed.length) {
            HTTPStatisticElement el = (HTTPStatisticElement)full[i];
            mean_download_speed[i] = new HTTPStatisticElement();
            if (el.nbr_visits != 0L) {
                ((HTTPStatisticElement)mean_download_speed[i]).nbr_visits = el.size / el.nbr_visits;
            }
            ++i;
        }
        return mean_download_speed;
    }
}

