/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.DailyActivityStorage;
import ch.kronospace.logpsychoanalyst.DailyActivityStorageOwner;
import ch.kronospace.logpsychoanalyst.HTTPStatisticElement;
import ch.kronospace.logpsychoanalyst.StatisticElement;
import ch.kronospace.logpsychoanalyst.StatisticElementArrayGetter;
import ch.kronospace.logpsychoanalyst.StatisticElementFullUpdater;
import java.util.Calendar;

public class DailyVisitDuration
implements DailyActivityStorageOwner {
    StatisticElementFullUpdater stat_el_full_updater = new StatisticElementFullUpdater();
    public DailyActivityStorage total_visit_time_per_day;
    public StatisticElementArrayGetter getter;

    public DailyVisitDuration() {
        this.stat_el_full_updater.nbr_visits = 1L;
        this.stat_el_full_updater.nbr_pages = 0L;
        this.stat_el_full_updater.nbr_hits = 0L;
        this.total_visit_time_per_day = new DailyActivityStorage();
        this.getter = new StatisticElementArrayGetter(){

            public String getValueName() {
                return "Mean visit duration [s]";
            }

            public double[] getValues(DailyActivityStorage das, long first_date, long last_date) {
                StatisticElement[] full = das.getRange(first_date, last_date);
                double[] mean_visit_duration = new double[full.length];
                int i = 0;
                while (i < mean_visit_duration.length) {
                    HTTPStatisticElement el = (HTTPStatisticElement)full[i];
                    if (el.nbr_visits != 0L) {
                        mean_visit_duration[i] = el.size / (1000L * el.nbr_visits);
                    }
                    ++i;
                }
                return mean_visit_duration;
            }
        };
    }

    public DailyActivityStorage getDailyActivityStorage() {
        return this.total_visit_time_per_day;
    }

    public void addVisit(long date, long visit_duration) {
        this.stat_el_full_updater.size = visit_duration;
        this.total_visit_time_per_day.update(date, this.stat_el_full_updater);
    }

    public HTTPStatisticElement[] getMeanVisitDuration(Calendar date_start, Calendar date_stop) {
        StatisticElement[] full = this.total_visit_time_per_day.getRange(date_start, date_stop);
        HTTPStatisticElement[] mean_visit_duration = new HTTPStatisticElement[full.length];
        int i = 0;
        while (i < mean_visit_duration.length) {
            mean_visit_duration[i] = new HTTPStatisticElement();
            HTTPStatisticElement el = (HTTPStatisticElement)full[i];
            if (el.nbr_visits != 0L) {
                mean_visit_duration[i].nbr_visits = el.size / (1000L * el.nbr_visits);
            }
            ++i;
        }
        return mean_visit_duration;
    }
}

