/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.Alias;
import ch.kronospace.logpsychoanalyst.DefaultPage;
import ch.kronospace.logpsychoanalyst.FileLogEntryFile;
import ch.kronospace.logpsychoanalyst.GZipFileLogEntryFile;
import ch.kronospace.logpsychoanalyst.Host;
import ch.kronospace.logpsychoanalyst.InputStreamVector;
import ch.kronospace.logpsychoanalyst.RobotTrap;
import ch.kronospace.logpsychoanalyst.ZipEntryLogEntryFile;
import ch.kronospace.logpsychoanalyst.logformat.ApacheCombined3;
import ch.kronospace.logpsychoanalyst.logformat.LogFormat;
import ch.kronospace.logpsychoanalyst.report.StatisticsBuilder;
import ch.kronospace.tools.XMLCommentedElement;
import java.io.File;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class DataSource
implements XMLCommentedElement {
    public String source_name;
    public String country = null;
    public TimeZone timezone = null;
    public boolean is_selected = false;
    public Host host = null;
    private LogFormat log_format;
    private StatisticsBuilder stats_builder = null;
    private Class stat_class = null;
    private Vector aliases = new Vector();
    private Vector default_pages = new Vector();
    private Vector robot_traps = new Vector();
    private boolean auto_download = true;
    protected String xml_comment = null;

    public void setData(DataSource ds) {
        this.source_name = ds.source_name;
        this.country = ds.country;
        this.timezone = ds.timezone;
        this.is_selected = ds.is_selected;
        this.host = ds.host;
        this.log_format = ds.log_format;
        this.stats_builder = ds.stats_builder;
        this.stat_class = ds.stat_class;
        this.aliases = ds.aliases;
        this.default_pages = ds.default_pages;
        this.robot_traps = ds.robot_traps;
    }

    public abstract void setHost(Host var1);

    public String getXMLComment() {
        return this.xml_comment;
    }

    public void setDefaultXMLComment(String comment) {
        this.xml_comment = comment;
    }

    public boolean isAlias(String host_name) {
        int i = 0;
        while (i < this.aliases.size()) {
            Alias a = (Alias)this.aliases.get(i);
            if (a.getName().equals(host_name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addAlias(Alias alias) {
        this.aliases.add(alias);
    }

    public Vector getAlias() {
        return this.aliases;
    }

    public Enumeration aliases() {
        return this.aliases.elements();
    }

    public void addDefaultPage(String page) {
        throw new RuntimeException("deprecated, replaced by #addDefaultPage(DefaultPage)");
    }

    public void addDefaultPage(DefaultPage page) {
        this.default_pages.add(page);
    }

    public Vector getDefaultPage() {
        return this.default_pages;
    }

    public boolean isDefaultPage(String page) {
        Enumeration e = this.default_pages.elements();
        while (e.hasMoreElements()) {
            DefaultPage p = (DefaultPage)e.nextElement();
            if (!page.equals(p.getName())) continue;
            return true;
        }
        return false;
    }

    public Class getStatisticsClass() {
        return this.stat_class;
    }

    public void setStatisticsClass(Class stat_class) {
        this.stat_class = stat_class;
    }

    public void setStatisticsBuilder(StatisticsBuilder builder) {
        this.stats_builder = builder;
    }

    public StatisticsBuilder getStatisticsBuilder() {
        return this.stats_builder;
    }

    public String getSourceName() {
        return this.source_name;
    }

    public String getType() {
        return "?";
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country.toLowerCase();
    }

    public TimeZone getTimeZone() {
        return this.timezone;
    }

    public void setTimeZone(String time_zone_id) {
        this.timezone = TimeZone.getTimeZone(time_zone_id);
    }

    public void setTimeZone(TimeZone time_zone) {
        this.timezone = time_zone;
    }

    public abstract InputStreamVector getLogInputStreams();

    public LogFormat getLogFormatAsLogFormat() {
        return this.log_format;
    }

    public void setLogFormat(LogFormat log_format) {
        this.log_format = log_format;
    }

    public String getLogFormat() {
        if (this.log_format == null) {
            return null;
        }
        return this.log_format.getClass().getName();
    }

    public void setLogFormat(String log_format_class) {
        LogFormat lf = new ApacheCombined3();
        if (log_format_class != null) {
            try {
                lf = (LogFormat)Class.forName(log_format_class).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.log_format = lf;
    }

    public void setAutoDownloadUsed(boolean auto_download) {
        throw new RuntimeException("deprecated, replaced by setAutoDownload(boolean)");
    }

    public void setAutoDownload(boolean auto_download) {
        this.auto_download = auto_download;
    }

    public void setAutoDownload(String auto_download) {
        this.auto_download = Boolean.getBoolean(auto_download);
    }

    public boolean isAutoDownloadUsed() {
        return this.auto_download;
    }

    public void addRobotTrap(RobotTrap trap) {
        this.robot_traps.add(trap);
    }

    public Vector getRobotTrap() {
        return this.robot_traps;
    }

    public boolean isRobotTrap(String url) {
        int i = 0;
        while (i < this.robot_traps.size()) {
            RobotTrap a = (RobotTrap)this.robot_traps.get(i);
            if (a.getUrl().equals(url)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public InputStreamVector getLogInputStreams(File[] files, boolean recursive) {
        InputStreamVector input_streams = new InputStreamVector();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                if (recursive) {
                    InputStreamVector temp_is = this.getLogInputStreams(files[i].listFiles(), recursive);
                    input_streams.addAll(temp_is);
                    input_streams.total_size += temp_is.total_size;
                }
            } else {
                String filename = files[i].getName();
                if (filename.endsWith(".zip")) {
                    try {
                        ZipFile zf = new ZipFile(files[i]);
                        Enumeration<? extends ZipEntry> e = zf.entries();
                        while (e.hasMoreElements()) {
                            ZipEntryLogEntryFile lef = new ZipEntryLogEntryFile(e.nextElement(), zf);
                            lef.setLogFormat(this.getLogFormatAsLogFormat());
                            lef.setDataSource(this);
                            input_streams.addElement(lef);
                            input_streams.total_size += lef.getContentLength();
                        }
                    }
                    catch (Exception e2) {
                        System.out.println(files[i]);
                        e2.printStackTrace();
                    }
                } else if (filename.endsWith(".gz")) {
                    try {
                        GZipFileLogEntryFile gzlef = new GZipFileLogEntryFile(files[i]);
                        gzlef.setLogFormat(this.getLogFormatAsLogFormat());
                        gzlef.setDataSource(this);
                        input_streams.addElement(gzlef);
                        input_streams.total_size += gzlef.getContentLength();
                    }
                    catch (Exception e) {
                        System.out.println("error while reading gzipped file: " + files[i]);
                        e.printStackTrace();
                    }
                } else {
                    try {
                        FileLogEntryFile flef = new FileLogEntryFile(files[i]);
                        flef.setLogFormat(this.getLogFormatAsLogFormat());
                        flef.setDataSource(this);
                        input_streams.addElement(flef);
                        input_streams.total_size += flef.getContentLength();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
        return input_streams;
    }

    public Host getHost() {
        return this.host;
    }

    public String toString() {
        return this.source_name;
    }
}

