/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.ConfigParser;
import ch.kronospace.logpsychoanalyst.Host;
import ch.kronospace.logpsychoanalyst.PrintStreamLogger;
import ch.kronospace.logpsychoanalyst.VirtualHost;
import ch.kronospace.logpsychoanalyst.application.Application;
import ch.kronospace.logpsychoanalyst.application.ApplicationDetector;
import ch.kronospace.logpsychoanalyst.application.Service;
import ch.kronospace.logpsychoanalyst.application.ServiceLocation;
import ch.kronospace.logpsychoanalyst.geography.IPGeographyUtil;
import ch.kronospace.logpsychoanalyst.geography.MaxMindGeoIPFree;
import ch.kronospace.logpsychoanalyst.report.ReportBuilder;
import ch.kronospace.logpsychoanalyst.report.ReportBuilderFactory;
import ch.kronospace.tools.DiskTools;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Echo {
    static boolean debug = false;

    public static void loadPackageClassFiles(File dir, String package_name) {
        boolean force_jar = false;
        if (debug) {
            System.out.println("loading package: " + package_name);
        }
        final String report_package_name = String.valueOf(package_name) + '.';
        File local_dir = new File(dir, report_package_name.replace('.', File.separatorChar));
        if (!force_jar && !local_dir.exists()) {
            if (debug) {
                System.out.println(String.valueOf(local_dir.getAbsolutePath()) + " not found; looking in the parent dir");
            }
            local_dir = new File(dir.getParentFile(), report_package_name.replace('.', File.separatorChar));
        }
        if (!force_jar && local_dir.exists()) {
            local_dir.listFiles(new FileFilter(){

                public boolean accept(File f) {
                    String name = f.getName();
                    if (name.endsWith(".class") && name.indexOf(36) == -1) {
                        if (debug) {
                            System.out.println("filename=" + name);
                        }
                        try {
                            Class.forName(String.valueOf(report_package_name) + name.substring(0, name.length() - ".class".length()));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return false;
                }
            });
        } else {
            try {
                JarFile f = new JarFile(new File(dir, "logpsychoanalyst.jar"));
                String directory_name = report_package_name.replace('.', '/');
                Enumeration<JarEntry> e = f.entries();
                while (e.hasMoreElements()) {
                    String name;
                    JarEntry je = e.nextElement();
                    String entry_name = je.getName();
                    if (!entry_name.startsWith(directory_name) || !entry_name.endsWith(".class") || entry_name.indexOf(36) != -1 || (name = entry_name.substring(directory_name.length(), entry_name.length() - ".class".length())).indexOf("/") >= 0) continue;
                    if (debug) {
                        System.out.println(String.valueOf(entry_name) + " " + name);
                    }
                    try {
                        Class.forName(String.valueOf(report_package_name) + name);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }
        if (debug) {
            System.out.println("termine");
        }
    }

    public void some_code_to_use_in_GUI() {
        Host h = null;
        Echo.loadPackageClassFiles(new File("lib"), "ch.kronospace.logpsychoanalyst.application");
        Vector<VirtualHost> virtual_hosts = new Vector<VirtualHost>();
        Iterator services = Service.getRegisteredServices().iterator();
        while (services.hasNext()) {
            Service service = (Service)services.next();
            if (debug) {
                System.out.println(service.toString());
            }
            Iterator service_locations = service.getLocations().iterator();
            while (service_locations.hasNext()) {
                ServiceLocation loc = (ServiceLocation)service_locations.next();
                if (debug) {
                    System.out.println("  " + loc.toString());
                }
                Enumeration e = loc.getApplicationDetectors().elements();
                while (e.hasMoreElements()) {
                    ApplicationDetector detector = (ApplicationDetector)e.nextElement();
                    if (debug) {
                        System.out.println("    " + detector.toString());
                    }
                    detector.detect();
                    Enumeration e2 = detector.getApplications().elements();
                    while (e2.hasMoreElements()) {
                        Application app = (Application)e2.nextElement();
                        if (debug) {
                            System.out.println("      " + app.toString());
                        }
                        Enumeration e3 = app.getVirtualHosts().elements();
                        while (e3.hasMoreElements()) {
                            VirtualHost vhost = (VirtualHost)e3.nextElement();
                            if (debug) {
                                System.out.println("        " + vhost.toString());
                            }
                            virtual_hosts.add(vhost);
                        }
                    }
                }
            }
        }
        if (debug) {
            System.out.println();
        }
        Enumeration e = virtual_hosts.elements();
        while (e.hasMoreElements()) {
            VirtualHost vhost = (VirtualHost)e.nextElement();
            if (vhost.getSourceName().indexOf(h.getDomainName()) == -1) continue;
            h.addDataSource(vhost);
        }
    }

    public static void updateProgram(String app) {
        System.out.print("Looking for upgrades on LPA web site...");
        File local_main_lib = new File("lib/logpsychoanalyst.jar");
        long local_main_lib_date = local_main_lib.lastModified();
        long distant_main_lib_date = 0L;
        try {
            URL distant_main_lib = new URL("http://www.logpsychoanalyst.com/download/logpsychoanalyst.jar");
            URLConnection urlConn = distant_main_lib.openConnection();
            urlConn.setDoInput(true);
            urlConn.setDoOutput(true);
            urlConn.setUseCaches(false);
            urlConn.setRequestProperty("Referer", "LPA-Application-" + app);
            distant_main_lib_date = urlConn.getLastModified();
            if (distant_main_lib_date != 0L) {
                if (distant_main_lib_date / 60000L <= local_main_lib_date / 60000L) {
                    System.out.println("  : up-to-date.");
                } else {
                    System.out.println("  : outdated! I download the new one...");
                    local_main_lib.delete();
                    DiskTools.copy(urlConn.getInputStream(), local_main_lib);
                }
            } else {
                System.out.println("  : unable to get the date (no connection?)!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] argv) {
        try {
            PrintStream log_file = new PrintStream("lpa.log");
            PrintStreamLogger sout = new PrintStreamLogger(System.out, log_file);
            PrintStreamLogger serr = new PrintStreamLogger(System.err, log_file);
            System.setOut(sout);
            System.setErr(serr);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        if (debug) {
            System.out.println("current dir=" + new File("./").getAbsolutePath());
        }
        String ua_string = "LogPsychoAnalyst/0.1 (" + System.getProperty("os.name") + " " + System.getProperty("os.version") + "; +http://www.logpsychoanalyst.com/bot.html)";
        System.setProperty("http.agent", ua_string);
        Echo.loadPackageClassFiles(new File("lib"), "ch.kronospace.logpsychoanalyst.logformat");
        Echo.loadPackageClassFiles(new File("lib"), "ch.kronospace.logpsychoanalyst.report");
        Echo.loadPackageClassFiles(new File("lib"), "ch.kronospace.logpsychoanalyst.plugins");
        Echo.loadPackageClassFiles(new File("lib"), "ch.kronospace.logpsychoanalyst.plugins.report");
        Echo.loadPackageClassFiles(new File("lib"), "ch.kronospace.logpsychoanalyst.plugins.visit");
        Echo.loadPackageClassFiles(new File("lib"), "ch.kronospace.logpsychoanalyst.plugins.advisor");
        System.out.println("Geolocation database loading and updating...");
        MaxMindGeoIPFree geoip = new MaxMindGeoIPFree(new File("data/maxmind_geoip_free"));
        if (geoip.getLastDatabaseDate() + 2419200000L < System.currentTimeMillis()) {
            geoip.downloadUpdate();
        }
        IPGeographyUtil.registerProvider(geoip);
        Echo.updateProgram("ProcessHost");
        System.out.println("Parse host configuration files...");
        new ConfigParser();
        Host h = null;
        if (ConfigParser.configs.size() <= 0) {
            System.out.println("WARNING: no configuration file found in the hosts directory");
            return;
        }
        h = (Host)ConfigParser.configs.elementAt(0);
        System.out.println("Processing host...");
        h.getStatisticsBuilder().processLogFiles(h);
        Vector report_builders = ReportBuilderFactory.getAvailableReportBuilders(h.getStatisticsClass());
        try {
            ReportBuilder report_builder = (ReportBuilder)((Class)report_builders.firstElement()).newInstance();
            report_builder.setStatisticsBuilder(h.getStatisticsBuilder());
            report_builder.buildReport(h.getStatisticsBuilder().getStatistics());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Done!");
    }
}

