/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.DataSource;
import ch.kronospace.logpsychoanalyst.Host;
import ch.kronospace.logpsychoanalyst.ISP;
import ch.kronospace.logpsychoanalyst.InputStreamVector;
import ch.kronospace.logpsychoanalyst.database.ISPDatabase;
import ch.kronospace.logpsychoanalyst.database.ISPDatabaseParser;
import ch.kronospace.logpsychoanalyst.geography.IPGeographyUtil;
import ch.kronospace.logpsychoanalyst.report.HTTPStatisticsBuilder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Vector;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class FTPDataSource
extends DataSource {
    private String ip_server = null;
    String ftp_server = null;
    String ftp_username = null;
    String ftp_password = null;
    private ISP isp = null;
    private String ftp_directory = null;
    private String log_file_regexp = null;
    private File local_log_directory = null;
    static /* synthetic */ Class class$0;

    public FTPDataSource() {
        this.xml_comment = "\n\n  FTP Data Source: log files are downloaded from a FTP server.\n    The information about the connection are shared in two: the server name,\n    username and password are given here, while the informations about the\n    way the log files are stored is given by information from isp_database.xml.\n    Thus, to have a FTPDataSource, the ISP must be in the ISP database.\n  \n    Syntax:\n      <FTPDataSource ftpname=\"url of the ftp server\"\n                     [ftpip=\"ip address of the server\"]\n                     username=\"the username\"\n                     password=\"the password\"\n                     autodownload=\"true|false\">\n         [<Alias name=\"any web address leading to this web site\"/>]\n      </FTPDataSource>\n\n    Notes:\n      1) the 'ftpip' is not mandatory if the domain name->IP\n         conversion can be done automatically (internet connection\n         required).\n";
    }

    public FTPDataSource(Host host) {
        this.xml_comment = "\n\n  FTP Data Source: log files are downloaded from a FTP server.\n    The information about the connection are shared in two: the server name,\n    username and password are given here, while the informations about the\n    way the log files are stored is given by information from isp_database.xml.\n    Thus, to have a FTPDataSource, the ISP must be in the ISP database.\n  \n    Syntax:\n      <FTPDataSource ftpname=\"url of the ftp server\"\n                     [ftpip=\"ip address of the server\"]\n                     username=\"the username\"\n                     password=\"the password\"\n                     autodownload=\"true|false\">\n         [<Alias name=\"any web address leading to this web site\"/>]\n      </FTPDataSource>\n\n    Notes:\n      1) the 'ftpip' is not mandatory if the domain name->IP\n         conversion can be done automatically (internet connection\n         required).\n";
        this.setHost(host);
    }

    public void setData(DataSource ds) {
        super.setData(ds);
        FTPDataSource ds2 = (FTPDataSource)ds;
        this.ip_server = ds2.getServerIP();
        this.ftp_server = ds2.getServerName();
        this.ftp_username = ds2.getUsername();
        this.ftp_password = ds2.getPassword();
        this.isp = ds2.getIspAsIsp();
        this.ftp_directory = ds2.getDistantDirectory2();
        this.log_file_regexp = ds2.getLogFilenameRegExp2();
        this.local_log_directory = ds2.getLocalLogDirectory();
        this.xml_comment = ds2.getXMLComment();
    }

    public void setHost(Host host) {
        this.host = host;
        this.local_log_directory = new File(host.getConfigDirectory(), "ftp_datasource");
        if (!this.local_log_directory.exists()) {
            this.local_log_directory.mkdir();
        }
        this.setStatisticsBuilder(new HTTPStatisticsBuilder());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ch.kronospace.logpsychoanalyst.report.HTTPStatistics");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setStatisticsClass(clazz);
        this.source_name = host.getDomainName();
    }

    public File getLocalLogDirectory() {
        return this.local_log_directory;
    }

    public void setServerIP(String ip) {
        if (this.ip_server == null) {
            this.ip_server = ip;
            this.setISPdataFromIP(ip);
        }
    }

    private void setISPdataFromIP(String ip) {
        if (ip == null) {
            return;
        }
        String ip2 = ip;
        try {
            ip2 = InetAddress.getByName(ip).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (!ip2.matches("[\\d\\.]+")) {
            return;
        }
        this.ip_server = ip2;
        ISPDatabase isp_database = ISPDatabaseParser.getDefaultDatabase();
        ISP isp = isp_database.getISP(ip2);
        if (isp != null) {
            System.out.println(isp.name);
            this.setCountry(IPGeographyUtil.getCountryCode(ip2));
            this.setConfigFromISP(isp);
        }
    }

    public void setConfigFromISP(ISP isp) {
        this.setTimeZone(isp.getTimeZone());
        this.setDistantDirectory(isp.getLogDirectory());
        this.setLogFilenameRegExp(isp.getLogFilenameRegExp());
        this.setLogFormat(isp.getLogFormatAsLogFormat());
    }

    public String getServerIP() {
        return this.ip_server;
    }

    public void addISP(ISP isp) {
        this.isp = isp;
        this.setConfigFromISP(isp);
    }

    public Vector getISP() {
        Vector<ISP> v = new Vector<ISP>();
        v.add(this.isp);
        return v;
    }

    public ISP getIspAsIsp() {
        return this.isp;
    }

    public void setServerName(String name) {
        this.ftp_server = name;
        this.setISPdataFromIP(name);
    }

    public String getServerName() {
        return this.ftp_server;
    }

    public void setUsername(String username) {
        this.ftp_username = username;
    }

    public void setPassword(String password) {
        this.ftp_password = password;
    }

    public String getUsername() {
        return this.ftp_username;
    }

    public String getPassword() {
        return this.ftp_password;
    }

    public void setDistantDirectory(String ftp_directory) {
        this.ftp_directory = ftp_directory;
        if (ftp_directory != null && ftp_directory.endsWith("/")) {
            this.ftp_directory = String.valueOf(this.ftp_directory) + '/';
        }
    }

    public String getDistantDirectory2() {
        return this.ftp_directory;
    }

    public void setLogFilenameRegExp(String log_file_regexp) {
        this.log_file_regexp = log_file_regexp;
    }

    public String getLogFilenameRegExp2() {
        return this.log_file_regexp;
    }

    public InputStreamVector getLogInputStreams() {
        this.downloadLogFiles();
        return this.getLogInputStreams(this.local_log_directory.listFiles(), true);
    }

    public void downloadLogFiles() {
        boolean debug = true;
        if (this.local_log_directory == null || !this.local_log_directory.exists()) {
            if (debug) {
                System.out.println("FTPDataSource.downloadLogFiles(): error, local_directory doesn't exist. Log files were not downloaded.");
            }
            return;
        }
        if (this.ftp_directory == null) {
            if (debug) {
                System.out.println("FTPDataSource.downloadLogFiles(): error, ftp_directory cannot be null. Log files were not downloaded.");
            }
            return;
        }
        if (this.log_file_regexp == null) {
            if (debug) {
                System.out.println("FTPDataSource.downloadLogFiles(): error, log_file_regexp cannot be null. Log files were not downloaded.");
            }
            return;
        }
        boolean error = false;
        FTPClient f = null;
        try {
            boolean logged;
            int reply;
            f = new FTPClient();
            f.connect(this.ftp_server);
            if (debug) {
                System.out.println("Connected to " + this.ftp_server + ".");
            }
            if (debug) {
                System.out.print(f.getReplyString());
            }
            if (!FTPReply.isPositiveCompletion((int)(reply = f.getReplyCode()))) {
                f.disconnect();
                if (debug) {
                    System.err.println("FTP server refused connection (bad server name or no internet connection).");
                }
                return;
            }
            if (debug) {
                System.out.println("Login...");
            }
            if (logged = f.login(this.ftp_username, this.ftp_password)) {
                if (debug) {
                    System.out.println("Login passed.");
                }
            } else if (debug) {
                System.out.println("Login failed!!");
            }
            FTPFile[] files = f.listFiles(this.ftp_directory);
            if (debug) {
                System.out.println("Files:");
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            long downloaded_size = 0L;
            int i = 0;
            while (i < files.length) {
                String name;
                if (debug) {
                    System.out.print("  " + files[i]);
                }
                if ((name = files[i].getName()).matches(this.log_file_regexp)) {
                    String local_name;
                    File local_file;
                    String name_extension = name.substring(name.lastIndexOf(46) + 1);
                    if (debug) {
                        System.out.print("  *");
                    }
                    if (!(local_file = new File(this.local_log_directory, local_name = "access_log_" + df.format(files[i].getTimestamp().getTime()) + "." + name_extension)).exists()) {
                        f.setFileType(2);
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(local_file));
                        boolean success = f.retrieveFile(String.valueOf(this.ftp_directory) + files[i].getName(), (OutputStream)out);
                        if (success) {
                            downloaded_size += files[i].getSize();
                        } else if (debug) {
                            System.out.println("error downloading the file!!");
                        }
                        out.close();
                    }
                }
                if (debug) {
                    System.out.println();
                }
                ++i;
            }
            if (debug) {
                System.out.println(String.valueOf(downloaded_size) + " bytes downloaded.");
            }
            f.logout();
        }
        catch (UnknownHostException e) {
            error = true;
            System.out.println("Error: could not connect to the FTPDataSource (ConnectException). Maybe there is no internet connection or the host is not responding.");
        }
        catch (ConnectException e) {
            error = true;
            System.out.println("Error: could not connect to the FTPDataSource (ConnectException). Maybe there is no internet connection or the host is not responding.");
        }
        catch (NoRouteToHostException e) {
            error = true;
            System.out.println("Error: could not connect to the FTPDataSource (NoRouteToHostException). Maybe there is no internet connection.");
        }
        catch (IOException e) {
            error = true;
            e.printStackTrace();
        }
        catch (Exception e) {
            error = true;
            e.printStackTrace();
        }
    }

    public String getType() {
        return "FTP";
    }
}

