/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.DataSource;
import ch.kronospace.logpsychoanalyst.Host;
import ch.kronospace.logpsychoanalyst.InputStreamVector;
import ch.kronospace.logpsychoanalyst.report.HTTPStatisticsBuilder;
import java.io.File;
import java.io.FileFilter;

public class FileDataSource
extends DataSource {
    private String log_file_regexp = "";
    private File local_log_directory = null;
    private String relative_dir = null;
    private boolean recursive = true;
    static /* synthetic */ Class class$0;

    public FileDataSource() {
        this.xml_comment = "\n\n FileDataSource: directory which contains the log files. Can be recursive or not.\n  The filepattern contain the regular expression which is used to match the files names which will be used. By default, match all files. The format is the one specified by Java SimpleDateFormat (dont specify the file extension to allow all extensions, like .txt, .gz, .zip)\n  The directory is relative to the current configuration file.\n  The file data source can contain more than one alias.\n\n    <FileDataSource directory=\"directory which contains the log files, relative to the present config file\"\n                    [recursive=\"recursive parsing directories, true|false, default value is true\"]\n                    [filepattern=\"a java.util.regex.Pattern text pattern format that represent which files should be taken, by default all files\"]\n                    country=\"the 2-letter country code of the server which produced these log files\"\n                    timezone=\"the 2-letter timezone id of the server which produced these log files\"\n                    logformat=\"ch.kronospace.logpsychoanalyst.logformat.ApacheCombined3\">\n       [<Alias name=\"other url that lead to the same web site, without the 'http://' prefix\"/>]*\n       [<RobotTrap url=\"the name of a page which should be viewed by robots only, e.g. /iamabot.html\"/>]*\n    </FileDataSource>\n   ";
    }

    public FileDataSource(Host host) {
        this.xml_comment = "\n\n FileDataSource: directory which contains the log files. Can be recursive or not.\n  The filepattern contain the regular expression which is used to match the files names which will be used. By default, match all files. The format is the one specified by Java SimpleDateFormat (dont specify the file extension to allow all extensions, like .txt, .gz, .zip)\n  The directory is relative to the current configuration file.\n  The file data source can contain more than one alias.\n\n    <FileDataSource directory=\"directory which contains the log files, relative to the present config file\"\n                    [recursive=\"recursive parsing directories, true|false, default value is true\"]\n                    [filepattern=\"a java.util.regex.Pattern text pattern format that represent which files should be taken, by default all files\"]\n                    country=\"the 2-letter country code of the server which produced these log files\"\n                    timezone=\"the 2-letter timezone id of the server which produced these log files\"\n                    logformat=\"ch.kronospace.logpsychoanalyst.logformat.ApacheCombined3\">\n       [<Alias name=\"other url that lead to the same web site, without the 'http://' prefix\"/>]*\n       [<RobotTrap url=\"the name of a page which should be viewed by robots only, e.g. /iamabot.html\"/>]*\n    </FileDataSource>\n   ";
        this.setHost(host);
    }

    public void setData(DataSource ds) {
        super.setData(ds);
        FileDataSource ds2 = (FileDataSource)ds;
        this.log_file_regexp = ds2.log_file_regexp;
        this.local_log_directory = ds2.local_log_directory;
        this.relative_dir = ds2.relative_dir;
        this.recursive = ds2.recursive;
    }

    public void setHost(Host host) {
        File dir;
        this.host = host;
        if (this.relative_dir == null) {
            this.relative_dir = "file_datasource";
        }
        if ((dir = new File(this.relative_dir)).isAbsolute()) {
            this.local_log_directory = dir;
        } else {
            this.local_log_directory = new File(host.getConfigDirectory(), this.relative_dir);
            if (!this.local_log_directory.exists()) {
                this.local_log_directory.mkdir();
            }
        }
        this.setStatisticsBuilder(new HTTPStatisticsBuilder());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ch.kronospace.logpsychoanalyst.report.HTTPStatistics");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setStatisticsClass(clazz);
    }

    public void setDirectory(File f) {
        this.local_log_directory = f;
    }

    public void setDirectory(String f) {
        this.relative_dir = f;
    }

    public File getDirectory() {
        return this.local_log_directory;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void setRecursive(String recursive) {
        this.recursive = Boolean.valueOf(recursive);
    }

    public String getRecursive() {
        return "" + this.recursive;
    }

    public void setFilePattern(String log_file_regexp) {
        this.log_file_regexp = log_file_regexp;
    }

    public String getFilePattern() {
        return this.log_file_regexp;
    }

    public InputStreamVector getLogInputStreams() {
        System.out.println(this.local_log_directory.getAbsolutePath());
        File[] f = null;
        f = this.local_log_directory.isDirectory() ? this.local_log_directory.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return true;
            }
        }) : new File[]{this.local_log_directory};
        System.out.println("XXXfiles :" + f.length);
        return this.getLogInputStreams(f, this.isRecursive());
    }

    public String getSourceName() {
        return this.local_log_directory.getAbsolutePath();
    }

    public String getType() {
        return "File";
    }
}

