/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.LogEntryFile;
import ch.kronospace.tools.GZIPInputStream2;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class GZipFileLogEntryFile
extends LogEntryFile {
    public static final int DEFAULT_COMPRESSION_RATIO = 20;
    private File file = null;
    private long file_length = -1L;
    private long file_last_modified = -1L;
    private GZIPInputStream2 last_opened_stream = null;

    public GZipFileLogEntryFile(File file) {
        this.file = file;
        this.file_length = file.length();
        this.file_last_modified = file.lastModified();
        super.setFileDate(this.file_last_modified);
        super.setName(file.getName());
        super.setSourceLength(this.file_length);
        this.updateContentLength();
    }

    public InputStream createInputStream() throws Exception {
        this.last_opened_stream = new GZIPInputStream2(new FileInputStream(this.file));
        this.last_opened_stream.setCompressedFileSize(this.file_length);
        return this.last_opened_stream;
    }

    public InputStream getLastCreatedInputStream() {
        return this.last_opened_stream;
    }

    public void close() {
        if (this.last_opened_stream != null) {
            try {
                this.last_opened_stream.close();
                this.last_opened_stream = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateContentLength() {
        super.setContentLength(this.last_opened_stream == null ? 20L * this.file_length : this.last_opened_stream.getCompressedFileSize() * (long)this.last_opened_stream.getInflater().getTotalOut() / (long)this.last_opened_stream.getInflater().getTotalIn());
    }
}

