/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.DailyActivityStorage;
import ch.kronospace.logpsychoanalyst.StatisticElement;
import ch.kronospace.logpsychoanalyst.StatisticElementArrayGetter;
import java.util.Calendar;
import java.util.Comparator;

public class HTTPStatisticElement
implements StatisticElement {
    public long nbr_hits = 0L;
    public long nbr_pages = 0L;
    public long nbr_prints = 0L;
    public long size = 0L;
    public long nbr_visits = 0L;
    public long last_hit_date;
    public Object user_object = null;
    public static final Comparator COMPARATOR_PAGES = new Comparator(){

        public int compare(Object o1, Object o2) {
            HTTPStatisticElement e1 = (HTTPStatisticElement)o1;
            HTTPStatisticElement e2 = (HTTPStatisticElement)o2;
            long ecart = e2.nbr_pages - e1.nbr_pages;
            if (ecart == 0L) {
                return (int)(e2.nbr_hits - e1.nbr_hits);
            }
            return (int)ecart;
        }
    };
    public static final Comparator COMPARATOR_HITS = new Comparator(){

        public int compare(Object o1, Object o2) {
            HTTPStatisticElement e1 = (HTTPStatisticElement)o1;
            HTTPStatisticElement e2 = (HTTPStatisticElement)o2;
            long delta_hits = e2.nbr_hits - e1.nbr_hits;
            return (int)delta_hits;
        }
    };
    public static final Comparator COMPARATOR_VISITS = new Comparator(){

        public int compare(Object o1, Object o2) {
            HTTPStatisticElement u1 = (HTTPStatisticElement)o1;
            HTTPStatisticElement u2 = (HTTPStatisticElement)o2;
            int r = (int)(u2.nbr_visits - u1.nbr_visits);
            if (r == 0) {
                int delta_hits = (int)(u2.nbr_hits - u1.nbr_hits);
                if (delta_hits == 0) {
                    return (int)(u2.last_hit_date - u1.last_hit_date);
                }
                return delta_hits;
            }
            return r;
        }
    };
    public static final Comparator COMPARATOR_DATE = new Comparator(){

        public int compare(Object o1, Object o2) {
            HTTPStatisticElement u1 = (HTTPStatisticElement)o1;
            HTTPStatisticElement u2 = (HTTPStatisticElement)o2;
            return (int)(u2.last_hit_date / 1000L - u1.last_hit_date / 1000L);
        }
    };
    public static final StatisticElementArrayGetter getter_hits = new StatisticElementArrayGetter(){

        public String getValueName() {
            return "Hits";
        }

        public double[] getValues(DailyActivityStorage das, long first_date, long last_date) {
            StatisticElement[] full = das.getRange(first_date, last_date);
            double[] hits = new double[full.length];
            int i = 0;
            while (i < hits.length) {
                HTTPStatisticElement el = (HTTPStatisticElement)full[i];
                hits[i] = el.nbr_hits;
                ++i;
            }
            return hits;
        }
    };
    public static final StatisticElementArrayGetter getter_pages = new StatisticElementArrayGetter(){

        public String getValueName() {
            return "Pages";
        }

        public double[] getValues(DailyActivityStorage das, long first_date, long last_date) {
            StatisticElement[] full = das.getRange(first_date, last_date);
            double[] pages = new double[full.length];
            int i = 0;
            while (i < pages.length) {
                HTTPStatisticElement el = (HTTPStatisticElement)full[i];
                pages[i] = el.nbr_pages;
                ++i;
            }
            return pages;
        }
    };
    public static final StatisticElementArrayGetter getter_visits = new StatisticElementArrayGetter(){

        public String getValueName() {
            return "Visits";
        }

        public double[] getValues(DailyActivityStorage das, long first_date, long last_date) {
            StatisticElement[] full = das.getRange(first_date, last_date);
            double[] visits = new double[full.length];
            int i = 0;
            while (i < visits.length) {
                HTTPStatisticElement el = (HTTPStatisticElement)full[i];
                visits[i] = el.nbr_visits;
                ++i;
            }
            return visits;
        }
    };
    public static final StatisticElementArrayGetter getter_sizes = new StatisticElementArrayGetter(){

        public String getValueName() {
            return "Download";
        }

        public double[] getValues(DailyActivityStorage das, long first_date, long last_date) {
            StatisticElement[] full = das.getRange(first_date, last_date);
            double[] sizes = new double[full.length];
            int i = 0;
            while (i < sizes.length) {
                HTTPStatisticElement el = (HTTPStatisticElement)full[i];
                sizes[i] = el.size;
                ++i;
            }
            return sizes;
        }
    };
    public static final StatisticElementArrayGetter getter_visits_weekdays = new StatisticElementArrayGetter(){

        public String getValueName() {
            return "Visits per weekday";
        }

        public double[] getValues(DailyActivityStorage das, long first_date, long last_date) {
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(first_date);
            int first_day_of_week = c.getFirstDayOfWeek();
            int first_weekday = c.get(7);
            StatisticElement[] full = das.getRange(first_date, last_date);
            double[] weekday_sizes = new double[8];
            int[] weekday_count = new int[8];
            int i = 0;
            while (i < full.length) {
                int weekday_index;
                HTTPStatisticElement el = (HTTPStatisticElement)full[i];
                int n = weekday_index = (14 + i + first_weekday - first_day_of_week + 1) % 7;
                weekday_sizes[n] = weekday_sizes[n] + (double)el.nbr_visits;
                int n2 = weekday_index;
                weekday_count[n2] = weekday_count[n2] + 1;
                ++i;
            }
            i = 0;
            while (i < weekday_sizes.length - 1) {
                int nbr_days = weekday_count[i];
                if (nbr_days != 0) {
                    int n = i;
                    weekday_sizes[n] = weekday_sizes[n] / (double)nbr_days;
                }
                ++i;
            }
            weekday_sizes[weekday_sizes.length - 1] = weekday_sizes[0];
            return weekday_sizes;
        }
    };
    public static final StatisticElementArrayGetter getter_pages_weekdays = new StatisticElementArrayGetter(){

        public String getValueName() {
            return "Pages per weekday";
        }

        public double[] getValues(DailyActivityStorage das, long first_date, long last_date) {
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(first_date);
            int first_day_of_week = c.getFirstDayOfWeek();
            int first_weekday = c.get(7);
            StatisticElement[] full = das.getRange(first_date, last_date);
            double[] weekday_sizes = new double[8];
            int[] weekday_count = new int[8];
            int i = 0;
            while (i < full.length) {
                int weekday_index;
                HTTPStatisticElement el = (HTTPStatisticElement)full[i];
                int n = weekday_index = (14 + i + first_weekday - first_day_of_week + 1) % 7;
                weekday_sizes[n] = weekday_sizes[n] + (double)el.nbr_pages;
                int n2 = weekday_index;
                weekday_count[n2] = weekday_count[n2] + 1;
                ++i;
            }
            i = 0;
            while (i < weekday_sizes.length - 1) {
                int nbr_days = weekday_count[i];
                if (nbr_days != 0) {
                    int n = i;
                    weekday_sizes[n] = weekday_sizes[n] / (double)nbr_days;
                }
                ++i;
            }
            weekday_sizes[weekday_sizes.length - 1] = weekday_sizes[0];
            return weekday_sizes;
        }
    };
    public static final StatisticElementArrayGetter getter_hits_weekdays = new StatisticElementArrayGetter(){

        public String getValueName() {
            return "Hits per weekday";
        }

        public double[] getValues(DailyActivityStorage das, long first_date, long last_date) {
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(first_date);
            int first_day_of_week = c.getFirstDayOfWeek();
            int first_weekday = c.get(7);
            StatisticElement[] full = das.getRange(first_date, last_date);
            double[] weekday_sizes = new double[8];
            int[] weekday_count = new int[8];
            int i = 0;
            while (i < full.length) {
                int weekday_index;
                HTTPStatisticElement el = (HTTPStatisticElement)full[i];
                int n = weekday_index = (14 + i + first_weekday - first_day_of_week + 1) % 7;
                weekday_sizes[n] = weekday_sizes[n] + (double)el.nbr_hits;
                int n2 = weekday_index;
                weekday_count[n2] = weekday_count[n2] + 1;
                ++i;
            }
            i = 0;
            while (i < weekday_sizes.length - 1) {
                int nbr_days = weekday_count[i];
                if (nbr_days != 0) {
                    int n = i;
                    weekday_sizes[n] = weekday_sizes[n] / (double)nbr_days;
                }
                ++i;
            }
            weekday_sizes[weekday_sizes.length - 1] = weekday_sizes[0];
            return weekday_sizes;
        }
    };
    public static final StatisticElementArrayGetter getter_sizes_weekdays = new StatisticElementArrayGetter(){

        public String getValueName() {
            return "Download per weekday";
        }

        public double[] getValues(DailyActivityStorage das, long first_date, long last_date) {
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(first_date);
            int first_day_of_week = c.getFirstDayOfWeek();
            int first_weekday = c.get(7);
            StatisticElement[] full = das.getRange(first_date, last_date);
            double[] weekday_sizes = new double[8];
            int[] weekday_count = new int[8];
            int i = 0;
            while (i < full.length) {
                int weekday_index;
                HTTPStatisticElement el = (HTTPStatisticElement)full[i];
                int n = weekday_index = (14 + i + first_weekday - first_day_of_week + 1) % 7;
                weekday_sizes[n] = weekday_sizes[n] + (double)el.size;
                int n2 = weekday_index;
                weekday_count[n2] = weekday_count[n2] + 1;
                ++i;
            }
            i = 0;
            while (i < weekday_sizes.length - 1) {
                int nbr_days = weekday_count[i];
                if (nbr_days != 0) {
                    int n = i;
                    weekday_sizes[n] = weekday_sizes[n] / (double)nbr_days;
                }
                ++i;
            }
            weekday_sizes[weekday_sizes.length - 1] = weekday_sizes[0];
            return weekday_sizes;
        }
    };

    public HTTPStatisticElement() {
    }

    public HTTPStatisticElement(Object user_object) {
        this.user_object = user_object;
    }

    public void merge(StatisticElement ua) {
        HTTPStatisticElement ua2 = (HTTPStatisticElement)ua;
        this.nbr_hits += ua2.nbr_hits;
        this.nbr_pages += ua2.nbr_pages;
        this.nbr_prints += ua2.nbr_prints;
        this.size += ua2.size;
        this.nbr_visits += ua2.nbr_visits;
        if (ua2.last_hit_date > this.last_hit_date) {
            this.last_hit_date = ua2.last_hit_date;
        }
    }

    public void reset() {
        this.nbr_hits = 0L;
        this.nbr_pages = 0L;
        this.size = 0L;
        this.nbr_visits = 0L;
        this.last_hit_date = 0L;
        this.nbr_prints = 0L;
    }

    public long getValue(int index) {
        throw new RuntimeException(" should be implemented by subclasses");
    }

    public long getTotal(int index) {
        throw new RuntimeException(" should be implemented by subclasses");
    }

    public void setDate(long date_long) {
        this.last_hit_date = date_long;
    }

    public long getDate() {
        return this.last_hit_date;
    }

    public Object clone() {
        HTTPStatisticElement e = new HTTPStatisticElement();
        e.nbr_hits = this.nbr_hits;
        e.nbr_pages = this.nbr_pages;
        e.nbr_visits = this.nbr_visits;
        e.nbr_prints = this.nbr_prints;
        e.last_hit_date = this.last_hit_date;
        e.user_object = this.user_object;
        return e;
    }

    public String getName() {
        return null;
    }

    public String getName(String param) {
        return this.getName();
    }

    public Object getUserObject() {
        return this.user_object;
    }

    public void incHits() {
        ++this.nbr_hits;
    }

    public void incPages() {
        ++this.nbr_pages;
    }

    public void incPrints() {
        ++this.nbr_prints;
    }

    public void incSize(long size) {
        this.size += size;
    }

    public String toString() {
        return String.valueOf(this.nbr_visits) + "/" + this.nbr_pages + "/" + this.nbr_hits + "/" + this.size + "/" + this.last_hit_date;
    }
}

