/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.tools.XMLCommentedElement;
import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;

public class HistoryGraphEvent
implements Comparable,
XMLCommentedElement {
    private Calendar date;
    private String event_name;
    private Color color;
    public static Color[] available_colors = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.CYAN, Color.MAGENTA, Color.BLACK};
    public static int nbr_of_events = 0;
    public static SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
    public static Random rand = new Random();
    protected String xml_comment = "\n\n  HistoryGraphEvents: these are special events on your web site (e.g. opening, new marketing campaign, closing).\n  The format is the following:\n\n    <HistoryGraphEvent name=\"event_name\" date=\"event_date\" [color=\"event_color\"]/>\n\n  date format is YYYYMMDD\n  color format is 0xRRGGBB. The color attribute is not mandatory (automatic).\n";

    public HistoryGraphEvent() {
        this.color = nbr_of_events < available_colors.length ? available_colors[nbr_of_events] : new Color(rand.nextInt(0x1FFFFFF));
        ++nbr_of_events;
    }

    public HistoryGraphEvent(Calendar date, String event_name, Color color) {
        this.date = date;
        this.event_name = event_name;
        this.color = color;
    }

    public String getXMLComment() {
        return this.xml_comment;
    }

    public void setDefaultXMLComment(String comment) {
        this.xml_comment = comment;
    }

    public void setDateAsCalendar(Calendar c) {
        this.date = (Calendar)c.clone();
    }

    public void setDate(String date_str) {
        try {
            Date d = df.parse(date_str);
            this.date = Calendar.getInstance();
            this.date.setTime(d);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getDate() {
        return df.format(this.date.getTime());
    }

    public Calendar getCalendar() {
        return this.date;
    }

    public void setName(String name) {
        this.event_name = name;
    }

    public String getName() {
        return this.event_name;
    }

    public void setColor(String color_str) {
        if (color_str.startsWith("0x")) {
            color_str = color_str.substring(2);
        }
        this.color = new Color(Integer.parseInt(color_str, 16));
    }

    public void setColorAsColor(Color c) {
        this.color = c;
    }

    public String getColor() {
        String color_str = Integer.toHexString(this.color.getRGB() & 0xFFFFFF);
        if (color_str.length() < 6) {
            color_str = String.valueOf("000000".substring(color_str.length())) + color_str;
        }
        return "0x" + color_str;
    }

    public Color getColorAsColor() {
        return this.color;
    }

    public int compareTo(Object o) {
        if (o.getClass() != this.getClass()) {
            return 0;
        }
        HistoryGraphEvent event = (HistoryGraphEvent)o;
        return (int)((this.getCalendar().getTimeInMillis() - event.getCalendar().getTimeInMillis()) / 1000L);
    }
}

