/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.DataSource;
import ch.kronospace.logpsychoanalyst.HiddenVisitFilter;
import ch.kronospace.logpsychoanalyst.HistoryGraphEvent;
import ch.kronospace.logpsychoanalyst.HostUserAgent;
import ch.kronospace.logpsychoanalyst.HostUserAgentList;
import ch.kronospace.logpsychoanalyst.MultipleProxy;
import ch.kronospace.logpsychoanalyst.PluginProperties;
import ch.kronospace.logpsychoanalyst.ProcessingOptions;
import ch.kronospace.logpsychoanalyst.ProductReferer;
import ch.kronospace.logpsychoanalyst.ProductRefererGroup;
import ch.kronospace.logpsychoanalyst.ProductRefererKeywords;
import ch.kronospace.logpsychoanalyst.Proxy;
import ch.kronospace.logpsychoanalyst.URLAlias;
import ch.kronospace.logpsychoanalyst.URLAliasParam;
import ch.kronospace.logpsychoanalyst.URLGroupParameters;
import ch.kronospace.logpsychoanalyst.report.StatisticsBuilder;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.jdom.Element;

public class Host {
    private Vector datasources = new Vector();
    private Vector hidden_visit_filters = new Vector();
    private Vector proxies = new Vector();
    private Vector multiple_proxies = new Vector();
    private Vector host_useragents = new Vector();
    private Vector host_useragents_list = new Vector();
    private Vector events = new Vector();
    private Vector url_aliases = new Vector();
    private Vector url_aliases_params = new Vector();
    private Vector plugins_properties = new Vector();
    String domain_name;
    private File config_directory = null;
    File config_file = null;
    Element root = null;
    Vector product_referer_search_engine_keywords = new Vector();
    Vector product_referer_groups = new Vector();
    private ProcessingOptions processing_options = new ProcessingOptions();
    private Vector product_referers = new Vector();

    public Host() {
    }

    public Host(String domain_name, File config_directory) {
        this.setDomainName(domain_name);
        this.setCurrentDirectory(config_directory);
    }

    public void setCurrentDirectory(File config_directory) {
        this.config_directory = config_directory;
        this.config_file = new File(config_directory, "config.xml");
        Enumeration e = this.datasources.elements();
        while (e.hasMoreElements()) {
            DataSource ds = (DataSource)e.nextElement();
            ds.setHost(this);
        }
    }

    public void setDomainName(String domain_name) {
        this.domain_name = domain_name;
    }

    public File getConfigFile() {
        return this.config_file;
    }

    public File getConfigDirectory() {
        return this.config_directory;
    }

    public void setConfigDirectory(File config_directory) {
        this.config_directory = config_directory;
    }

    public String getDomainName() {
        return this.domain_name;
    }

    public Class getStatisticsClass() {
        return ((DataSource)this.datasources.firstElement()).getStatisticsClass();
    }

    public StatisticsBuilder getStatisticsBuilder() {
        return ((DataSource)this.datasources.firstElement()).getStatisticsBuilder();
    }

    public void addProductReferer(ProductReferer product_referer) {
        this.product_referers.add(product_referer);
        if (product_referer instanceof ProductRefererGroup) {
            this.product_referer_groups.add(((ProductRefererGroup)product_referer).getGroupID());
        } else {
            this.product_referer_search_engine_keywords.add(((ProductRefererKeywords)product_referer).getSearchEngineKeywordsArray());
        }
    }

    public Vector getProductReferer() {
        return this.product_referers;
    }

    public void addProcessingOptions(ProcessingOptions processing_options) {
        this.processing_options = processing_options;
    }

    public ProcessingOptions getProcessingOptionsAsProcessingOptions() {
        return this.processing_options;
    }

    public Vector getProcessingOptions() {
        Vector<ProcessingOptions> v = new Vector<ProcessingOptions>();
        v.add(this.processing_options);
        return v;
    }

    public void addURLAlias(URLAlias url_alias) {
        this.url_aliases.add(url_alias);
    }

    public Vector getURLAlias() {
        return this.url_aliases;
    }

    public void addURLAliasParam(URLAliasParam url_alias_param) {
        this.url_aliases_params.add(url_alias_param);
    }

    public Vector getURLAliasParam() {
        return this.url_aliases_params;
    }

    public void addPluginProperties(PluginProperties plugin_properties) {
        this.plugins_properties.add(plugin_properties);
    }

    public Vector getPluginProperties() {
        return this.plugins_properties;
    }

    public PluginProperties getPluginProperties(String className) {
        Enumeration e = this.plugins_properties.elements();
        while (e.hasMoreElements()) {
            PluginProperties p = (PluginProperties)e.nextElement();
            if (!p.getClassName().equals(className)) continue;
            return p;
        }
        return null;
    }

    public void addURLGroupParameters(URLGroupParameters url_group_parameters) {
    }

    public void addDataSource(DataSource ds) {
        if (ds == null) {
            throw new RuntimeException("null argument");
        }
        ds.setHost(this);
        this.datasources.add(ds);
    }

    public Vector getDataSource() {
        return this.datasources;
    }

    public void addHiddenVisitFilter(HiddenVisitFilter hv) {
        this.hidden_visit_filters.add(hv);
    }

    public Vector getHiddenVisitFilter() {
        return this.hidden_visit_filters;
    }

    public void addProxy(Proxy ds) {
        this.proxies.add(ds);
    }

    public Vector getProxy() {
        return this.proxies;
    }

    public void addMultipleProxy(MultipleProxy ds) {
        this.multiple_proxies.add(ds);
    }

    public Vector getMultipleProxy() {
        return this.multiple_proxies;
    }

    public void addHostUserAgent(HostUserAgent ds) {
        this.host_useragents.add(ds);
    }

    public Vector getHostUserAgent() {
        return this.host_useragents;
    }

    public void addHostUserAgentList(HostUserAgentList ds) {
        this.host_useragents_list.add(ds);
    }

    public Vector getHostUserAgentList() {
        return this.host_useragents_list;
    }

    public void addHistoryGraphEvent(HistoryGraphEvent event) {
        this.events.add(event);
    }

    public Vector getHistoryGraphEvent() {
        return this.events;
    }

    public Vector getProductRefererSearchEngineKeywords() {
        return this.product_referer_search_engine_keywords;
    }

    public Vector getProductRefererGroups() {
        return this.product_referer_groups;
    }

    public String toString() {
        return this.domain_name;
    }
}

