/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.HostUserAgent;
import ch.kronospace.logpsychoanalyst.database.UserAgentDatabaseParser;
import ch.kronospace.logpsychoanalyst.geography.IPGeographyUtil;
import ch.kronospace.tools.XMLCommentedElement;

public class HostUserAgentList
extends HostUserAgent
implements XMLCommentedElement {
    private long[] ip_addresses = null;
    protected String xml_comment = null;

    public HostUserAgentList() {
        this.url = "";
        this.icon = "unknown";
    }

    public HostUserAgentList(long ip) {
        this.url = "";
        this.icon = "unknown";
        this.setIp(ip);
    }

    public String getXMLComment() {
        return this.xml_comment;
    }

    public void setDefaultXMLComment(String comment) {
        this.xml_comment = comment;
    }

    public void setIp(String ip_addresses_str) {
        String[] ips = ip_addresses_str.split(", ");
        this.ip_addresses = new long[ips.length];
        int i = 0;
        while (i < this.ip_addresses.length) {
            if (ips[i].indexOf("*") < 0) {
                this.ip_addresses[i] = IPGeographyUtil.getIPAsLong(ips[i]);
            }
            ++i;
        }
        super.setIp(this.ip_addresses[0]);
    }

    public String getIp() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.ip_addresses.length) {
            buf.append(IPGeographyUtil.getIP(this.ip_addresses[i]));
            buf.append(", ");
            ++i;
        }
        return buf.length() > 0 ? buf.substring(0, buf.length() - ", ".length()) : "";
    }

    public boolean matchesHostByIp(String ip_address) {
        long ip_to_look = IPGeographyUtil.getIPAsLong(ip_address);
        int i = 0;
        while (i < this.ip_addresses.length) {
            if (this.ip_addresses[i] == ip_to_look) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setFamilyID(String familyid) {
        this.family = UserAgentDatabaseParser.getDefaultDatabase().getUserAgentFamily(familyid);
    }

    public String getFamilyID() {
        return this.family.getId();
    }

    public String toString() {
        return this.name;
    }
}

