/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.Alias;
import ch.kronospace.logpsychoanalyst.DefaultPage;
import ch.kronospace.logpsychoanalyst.geography.IPGeographyUtil;
import ch.kronospace.logpsychoanalyst.logformat.ApacheCombined3;
import ch.kronospace.logpsychoanalyst.logformat.LogFormat;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.Vector;

public class ISP {
    public String name = null;
    public String first_ip = null;
    public String last_ip = null;
    public String country = null;
    public TimeZone timezone = null;
    public String isp_url = null;
    public String log_url = null;
    public String log_directory = null;
    public String log_file_regexp = null;
    public LogFormat log_format = null;
    private Vector v_default_pages = new Vector();
    private Vector v_aliases = new Vector();

    public void setData(ISP isp) {
        this.name = isp.name;
        this.first_ip = isp.first_ip;
        this.last_ip = isp.last_ip;
        this.country = isp.country;
        this.timezone = isp.timezone;
        this.isp_url = isp.isp_url;
        this.log_url = isp.log_url;
        this.log_directory = isp.log_directory;
        this.log_file_regexp = isp.log_file_regexp;
        this.log_format = isp.log_format;
        this.v_default_pages = (Vector)isp.v_default_pages.clone();
        this.v_aliases = (Vector)isp.v_aliases.clone();
    }

    public boolean isInRange(String ip) {
        if (ip == null) {
            return false;
        }
        long first_ip_long = IPGeographyUtil.getIPAsLong(this.first_ip);
        long last_ip_long = IPGeographyUtil.getIPAsLong(this.last_ip);
        long ip_long = IPGeographyUtil.getIPAsLong(ip);
        return ip_long >= first_ip_long && ip_long <= last_ip_long;
    }

    public void setLogDirectory(String dir) {
        this.log_directory = dir;
    }

    public String getLogDirectory() {
        return this.log_directory;
    }

    public TimeZone getTimeZone() {
        return this.timezone;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setLogServerURL(String url) {
        this.log_url = url;
    }

    public String getLogServerURL() {
        return this.log_url;
    }

    public void setLogFilenameRegExp(String log_file_regexp) {
        this.log_file_regexp = log_file_regexp;
    }

    public String getLogFilenameRegExp() {
        return this.log_file_regexp;
    }

    public void setLogFormat(LogFormat log_format) {
        this.log_format = log_format;
    }

    public LogFormat getLogFormatAsLogFormat() {
        return this.log_format;
    }

    public String getLogFormat() {
        if (this.log_format == null) {
            return null;
        }
        return this.log_format.getClass().getName();
    }

    public void setLogFormat(String log_format_class) {
        LogFormat lf = new ApacheCombined3();
        if (log_format_class != null) {
            try {
                lf = (LogFormat)Class.forName(log_format_class).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.log_format = lf;
    }

    public Enumeration default_pages() {
        return this.v_default_pages.elements();
    }

    public void addDefaultPage(DefaultPage default_page) {
        this.v_default_pages.add(default_page);
    }

    public Vector getDefaultPage() {
        return this.v_default_pages;
    }

    public Enumeration aliases() {
        return this.v_aliases.elements();
    }

    public void addAlias(String alias) {
        throw new RuntimeException("deprecated replaced by addAlias(Alias)");
    }

    public void addAlias(Alias alias) {
        this.v_aliases.add(alias);
    }

    public Vector getAlias() {
        return this.v_aliases;
    }
}

