/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.DataSource;
import ch.kronospace.logpsychoanalyst.logformat.LogFormat;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

public abstract class LogEntryFile {
    private long first_entry_date = -1L;
    private long source_last_modified_date = -1L;
    private long source_length = -1L;
    private long content_length = -1L;
    private long previous_content_length = -1L;
    private String name = null;
    private LogFormat log_format = null;
    private DataSource data_source = null;

    public void setLogFormat(LogFormat log_format) {
        this.log_format = log_format;
    }

    public void setDataSource(DataSource data_source) {
        this.data_source = data_source;
    }

    public void close() {
    }

    public abstract InputStream createInputStream() throws Exception;

    public long getFirstEntryDate() {
        if (this.first_entry_date < 0L) {
            try {
                InputStream is = this.createInputStream();
                this.log_format.setBufferedReader(new BufferedReader(new InputStreamReader(is)));
                this.log_format.parse(this.log_format.getNextEntry());
                this.first_entry_date = this.log_format.getDate().getTimeInMillis();
                is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.first_entry_date;
    }

    public void setFirstEntryDate(long first_entry_date) {
        throw new RuntimeException("not implemented yet");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getFileDate() {
        return this.source_last_modified_date;
    }

    public void setFileDate(long date) {
        this.source_last_modified_date = date;
    }

    public long getSourceLength() {
        return this.source_length;
    }

    public void setSourceLength(long source_length) {
        this.source_length = source_length;
    }

    public long getContentLength() {
        return this.content_length;
    }

    public void setContentLength(long content_length) {
        this.previous_content_length = this.content_length;
        this.content_length = content_length;
    }

    public void updateContentLength() {
    }

    public long getPreviousContentLength() {
        return this.previous_content_length;
    }
}

