/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.visualization.AbstractRenderer;
import edu.uci.ics.jung.visualization.ArrowFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.QuadCurve2D;
import java.util.Iterator;

public class NetworkActivityRenderer
extends AbstractRenderer {
    public static final String VERTEX_ACTIVITY_KEY = "activity";
    public static final String VERTEX_INPUT_KEY = "input";
    public static final String VERTEX_OUTPUT_KEY = "output";
    public static final String VERTEX_LABEL_KEY = "name";
    public static final String EDGE_ACTIVITY_KEY = "activity";
    private int min_activity_disk_width = 10;
    private int max_activity_disk_width = 40;
    private int max_vertex_activity = 100;
    private int max_input = 100;
    private int max_output = 100;
    private int min_edge_activity_width = 0;
    private int max_edge_activity_width = 4;
    private int max_edge_activity = 100;
    public static final Color ACTIVITY_DISK_COLOR = new Color(201, 228, 255);
    GeneralPath arrow = ArrowFactory.getNotchedArrow((float)10.0f, (float)15.0f, (float)5.0f);

    public void init(Graph g) {
        Iterator iter = g.getVertices().iterator();
        while (iter.hasNext()) {
            int vertex_output;
            int vertex_input;
            Vertex v = (Vertex)iter.next();
            int vertex_activity = ((Number)v.getUserDatum((Object)"activity")).intValue();
            if (vertex_activity > this.max_vertex_activity) {
                this.max_vertex_activity = vertex_activity;
            }
            if ((vertex_input = ((Number)v.getUserDatum((Object)VERTEX_INPUT_KEY)).intValue()) > this.max_input) {
                this.max_input = vertex_input;
            }
            if ((vertex_output = ((Number)v.getUserDatum((Object)VERTEX_OUTPUT_KEY)).intValue()) <= this.max_output) continue;
            this.max_output = vertex_output;
        }
        iter = g.getEdges().iterator();
        while (iter.hasNext()) {
            Edge e = (Edge)iter.next();
            int edge_activity = ((Number)e.getUserDatum((Object)"activity")).intValue();
            if (edge_activity <= this.max_edge_activity) continue;
            this.max_edge_activity = edge_activity;
        }
    }

    public int getRadius(Vertex v) {
        int vertex_activity = ((Number)v.getUserDatum((Object)"activity")).intValue();
        int activity_disk_width = vertex_activity * (this.max_activity_disk_width - this.min_activity_disk_width) / this.max_vertex_activity + this.min_activity_disk_width;
        return activity_disk_width / 2;
    }

    public void paintVertex(Graphics g, Vertex v, int x, int y) {
        int vertex_activity = ((Number)v.getUserDatum((Object)"activity")).intValue();
        int vertex_input = ((Number)v.getUserDatum((Object)VERTEX_INPUT_KEY)).intValue();
        int vertex_output = ((Number)v.getUserDatum((Object)VERTEX_OUTPUT_KEY)).intValue();
        String vertex_label = (String)v.getUserDatum((Object)VERTEX_LABEL_KEY);
        int activity_disk_width = this.getRadius(v) * 2;
        int activity_disk_x0 = x - activity_disk_width / 2;
        int activity_disk_y0 = y - activity_disk_width / 2;
        g.setColor(ACTIVITY_DISK_COLOR);
        g.fillOval(activity_disk_x0, activity_disk_y0, activity_disk_width, activity_disk_width);
        g.setColor(Color.BLACK);
        g.drawOval(activity_disk_x0, activity_disk_y0, activity_disk_width, activity_disk_width);
        int input_disk_width = activity_disk_width / 3;
        int input_disk_x0 = activity_disk_x0;
        int input_disk_y0 = activity_disk_y0 + activity_disk_width - input_disk_width;
        int green = 255 - 255 * vertex_input / this.max_input;
        g.setColor(new Color(green, 255, green));
        g.fillOval(input_disk_x0, input_disk_y0, input_disk_width, input_disk_width);
        int output_disk_width = input_disk_width;
        int output_disk_x0 = activity_disk_x0 + activity_disk_width - output_disk_width;
        int output_disk_y0 = input_disk_y0;
        int red = 255 - 255 * vertex_output / this.max_output;
        g.setColor(new Color(255, red, red));
        g.fillOval(output_disk_x0, output_disk_y0, output_disk_width, output_disk_width);
        g.setColor(Color.BLACK);
        int act_str_x0 = activity_disk_x0 + activity_disk_width / 6;
        g.drawString("" + vertex_activity, act_str_x0, activity_disk_y0 + activity_disk_width * 2 / 3);
        g.drawString(vertex_label, activity_disk_x0 + activity_disk_width, activity_disk_y0 + activity_disk_width / 3);
    }

    public void paintEdge(Graphics g, Edge e, int x1, int y1, int x2, int y2) {
        Pair pair = e.getEndpoints();
        Vertex v1 = (Vertex)pair.getFirst();
        Vertex v2 = (Vertex)pair.getSecond();
        int wv = this.getRadius(v2);
        g.setColor(Color.DARK_GRAY);
        int edge_activity = ((Number)e.getUserDatum((Object)"activity")).intValue();
        float line_width = edge_activity * (this.max_edge_activity_width - this.min_edge_activity_width) / this.max_edge_activity + this.min_edge_activity_width;
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(line_width));
        int dx = x2 - x1;
        int dy = y2 - y1;
        if (v1.equals(v2)) {
            g2.drawOval(x1 - 2 * wv, y1 - 2 * wv, 2 * wv, 2 * wv);
        } else {
            boolean line_draw = false;
            if (line_draw) {
                g2.drawLine(x1, y1, x2, y2);
                double alpha = Math.atan2(dy, dx);
                AffineTransform at1 = new AffineTransform();
                at1.rotate(alpha);
                Shape arrow2 = at1.createTransformedShape(this.arrow);
                AffineTransform at2 = new AffineTransform();
                double L = Math.sqrt(dx * dx + dy * dy);
                at2.translate(x2 - (int)((double)(wv * dx) / L), y2 - (int)((double)(wv * dy) / L));
                Shape arrow3 = at2.createTransformedShape(arrow2);
                g2.fill(arrow3);
                g.drawString("" + edge_activity, (x1 + x2) / 2, (y1 + y2) / 2);
            } else {
                int deltax = dx > 0 ? 1 : -1;
                int deltay = dy > 0 ? 1 : -1;
                int px = (x1 + x2) / 2;
                int py = (y1 + y2) / 2;
                if (Math.abs(dx) > Math.abs(dy)) {
                    py += 20 * deltax;
                } else {
                    px += 20 * deltay;
                }
                QuadCurve2D.Double curve = new QuadCurve2D.Double(x1, y1, px, py, x2, y2);
                g2.draw(curve);
                dx = x2 - px;
                dy = y2 - py;
                double alpha = Math.atan2(dy, dx);
                AffineTransform at1 = new AffineTransform();
                at1.rotate(alpha);
                Shape arrow2 = at1.createTransformedShape(this.arrow);
                AffineTransform at2 = new AffineTransform();
                double L = Math.sqrt(dx * dx + dy * dy);
                at2.translate(x2 - (int)((double)(wv * dx) / L), y2 - (int)((double)(wv * dy) / L));
                Shape arrow3 = at2.createTransformedShape(arrow2);
                g2.fill(arrow3);
                g.drawString("" + edge_activity, px, py);
            }
        }
    }
}

