/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.HTTPStatisticElement;
import ch.kronospace.logpsychoanalyst.MultipleProxy;
import ch.kronospace.logpsychoanalyst.Proxy;
import ch.kronospace.logpsychoanalyst.Visit;
import java.util.Vector;

public class RecognizedHost
extends HTTPStatisticElement {
    public long ip_address;
    public String host_name = null;
    private Vector visits = new Vector();
    private MultipleProxy multiple_proxy = null;
    private int nbr_proxy_votes = 0;

    public RecognizedHost(long ip_address) {
        this.ip_address = ip_address;
    }

    public RecognizedHost(MultipleProxy multiple_proxy) {
        this.ip_address = ((Proxy)multiple_proxy.getProxy().firstElement()).getIPAsLong();
        this.multiple_proxy = multiple_proxy;
    }

    public boolean equals(Object o) {
        if (o.getClass() != this.getClass()) {
            return false;
        }
        RecognizedHost h = (RecognizedHost)o;
        return h.ip_address == this.ip_address;
    }

    public int getNbrProxyVotes() {
        return this.nbr_proxy_votes;
    }

    public void setNbrProxyVotes(int i) {
        this.nbr_proxy_votes = i;
    }

    public void incNbrProxyVotes() {
        ++this.nbr_proxy_votes;
    }

    public int hashCode() {
        return (int)this.ip_address;
    }

    public void addVisit(Visit v) {
        this.visits.add(v);
    }

    public Vector getVisits() {
        return this.visits;
    }

    public void setHostName(String host_name) {
        this.host_name = host_name;
    }

    public String getHostName() {
        if (this.host_name != null) {
            return this.host_name;
        }
        return this.getIPAsString();
    }

    public String getName() {
        if (this.multiple_proxy != null) {
            return this.multiple_proxy.getName();
        }
        return this.getHostName();
    }

    public String getIPAsString() {
        int a = (int)(this.ip_address >> 24) & 0xFF;
        int b = (int)(this.ip_address >> 16) & 0xFF;
        int c = (int)(this.ip_address >> 8) & 0xFF;
        int d = (int)(this.ip_address >> 0) & 0xFF;
        return a + "." + b + "." + c + "." + d;
    }

    public String getReverseIPAsString() {
        int a = (int)(this.ip_address >> 24) & 0xFF;
        int b = (int)(this.ip_address >> 16) & 0xFF;
        int c = (int)(this.ip_address >> 8) & 0xFF;
        int d = (int)(this.ip_address >> 0) & 0xFF;
        return d + "." + c + "." + b + "." + a;
    }

    public byte[] getIPAsByteArray() {
        byte a = (byte)((int)(this.ip_address >> 24) & 0xFF);
        byte b = (byte)((int)(this.ip_address >> 16) & 0xFF);
        byte c = (byte)((int)(this.ip_address >> 8) & 0xFF);
        byte d = (byte)((int)(this.ip_address >> 0) & 0xFF);
        return new byte[]{a, b, c, d};
    }

    public String toString() {
        return String.valueOf(this.getHostName()) + " (" + this.getIPAsString() + ")       (" + this.nbr_pages + " pages, " + this.nbr_hits + " hits, " + this.size + " bytes)";
    }
}

