/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.DailyActivityStorage;
import ch.kronospace.logpsychoanalyst.DailyActivityStorageOwner;
import ch.kronospace.logpsychoanalyst.HTTPStatisticElement;
import java.util.Comparator;

public class RecognizedPlugin
extends HTTPStatisticElement
implements DailyActivityStorageOwner {
    private DailyActivityStorage daily_activity_storage = new DailyActivityStorage();
    public String plugin_name;
    public static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            RecognizedPlugin p1 = (RecognizedPlugin)o1;
            RecognizedPlugin p2 = (RecognizedPlugin)o2;
            return (int)(p2.nbr_visits - p1.nbr_visits);
        }

        public boolean equals(Object o) {
            return true;
        }
    };

    public RecognizedPlugin() {
    }

    public RecognizedPlugin(String plugin_name) {
        this.plugin_name = plugin_name;
        this.daily_activity_storage.setName(plugin_name.replaceAll("<.*> ", ""));
        this.daily_activity_storage.setEmptyActivity(new RecognizedPlugin());
    }

    public DailyActivityStorage getDailyActivityStorage() {
        return this.daily_activity_storage;
    }

    public boolean equals(Object o) {
        if (o.getClass() != this.getClass()) {
            return false;
        }
        RecognizedPlugin p = (RecognizedPlugin)o;
        return p.plugin_name.equals(this.plugin_name);
    }

    public int hashCode() {
        return this.plugin_name.hashCode();
    }

    public long getTotal(int index) {
        return this.nbr_visits + this.nbr_hits + this.nbr_pages;
    }

    public long getValue(int index) {
        long value;
        long nbr_installed_predicted = this.nbr_hits * this.nbr_visits / Math.max(1L, this.nbr_visits + this.nbr_pages);
        if (index == 1) {
            value = this.nbr_visits;
        } else if (index == 2) {
            value = nbr_installed_predicted;
        } else if (index == 3) {
            value = this.nbr_hits - nbr_installed_predicted;
        } else if (index == 4) {
            value = this.nbr_pages;
        } else {
            throw new RuntimeException("unexpected argument");
        }
        return value;
    }

    public String getName(String unknown_url) {
        return this.plugin_name;
    }

    public String toString() {
        return String.valueOf(this.getName()) + "    (" + this.nbr_pages + " pages, " + this.nbr_hits + " hits, " + this.size + " bytes)";
    }

    public Object clone() {
        RecognizedPlugin p = this.plugin_name != null ? new RecognizedPlugin(this.plugin_name) : new RecognizedPlugin();
        p.nbr_visits = this.nbr_visits;
        p.nbr_pages = this.nbr_pages;
        p.nbr_hits = this.nbr_hits;
        return p;
    }
}

