/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.DailyActivityStorage;
import ch.kronospace.logpsychoanalyst.DailyActivityStorageOwner;
import ch.kronospace.logpsychoanalyst.HTTPStatisticElement;
import java.awt.Dimension;

public class RecognizedScreenSize
extends HTTPStatisticElement
implements DailyActivityStorageOwner {
    private DailyActivityStorage daily_activity_storage = new DailyActivityStorage();
    public Dimension screen_size;

    public RecognizedScreenSize() {
    }

    public RecognizedScreenSize(Dimension screen_size) {
        this.screen_size = screen_size;
        this.daily_activity_storage.setName(this.getNameNoHTML());
        this.daily_activity_storage.setShortName(this.getShortNameNoHTML());
    }

    public DailyActivityStorage getDailyActivityStorage() {
        return this.daily_activity_storage;
    }

    public String getName() {
        if (this.screen_size.width == -1 || this.screen_size.height == -1) {
            return "Unknown screen size";
        }
        return this.screen_size.width + " x " + this.screen_size.height + " &nbsp; (" + this.getQuotient((float)this.screen_size.width / (float)this.screen_size.height) + ")";
    }

    public String getNameNoHTML() {
        if (this.screen_size.width == -1 || this.screen_size.height == -1) {
            return "Unknown screen size";
        }
        return this.screen_size.width + " x " + this.screen_size.height + "  (" + this.getQuotient((float)this.screen_size.width / (float)this.screen_size.height) + ")";
    }

    public String getShortNameNoHTML() {
        if (this.screen_size.width == -1 || this.screen_size.height == -1) {
            return "Unknown";
        }
        return this.screen_size.width + "x" + this.screen_size.height;
    }

    public String getQuotient(float n) {
        float min_erreur = Float.MAX_VALUE;
        int min_index = 0;
        int i = 2;
        while (i < 10) {
            float erreur = Math.abs((float)Math.round(n * (float)i) - n * (float)i);
            if (erreur < min_erreur) {
                min_erreur = erreur;
                min_index = i;
            }
            ++i;
        }
        return min_index + ":" + Math.round(n * (float)min_index);
    }
}

