/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.DailyActivityStorage;
import ch.kronospace.logpsychoanalyst.DailyActivityStorageOwner;
import ch.kronospace.logpsychoanalyst.HTTPStatisticElement;
import ch.kronospace.logpsychoanalyst.RecognizedOS;
import ch.kronospace.logpsychoanalyst.UserAgent;
import java.util.Enumeration;
import java.util.Hashtable;

public class RecognizedUserAgent
extends HTTPStatisticElement
implements DailyActivityStorageOwner {
    public String version;
    public RecognizedOS recognized_os = null;
    public UserAgent useragent = null;
    private Hashtable ht_page_last_view_date = new Hashtable();
    private DailyActivityStorage daily_activity_storage = new DailyActivityStorage();
    private boolean robots_txt_hit = false;
    private boolean robot_trap_hit = false;

    public RecognizedUserAgent() {
    }

    public RecognizedUserAgent(UserAgent useragent, String version) {
        this.useragent = useragent;
        this.version = version;
    }

    public RecognizedOS getRecognizedOS() {
        return this.recognized_os;
    }

    public void setRecognizedOS(RecognizedOS os) {
        this.recognized_os = os;
    }

    public void setPageViewDate(String page_URL, long view_date) {
        Long current_last_date = (Long)this.ht_page_last_view_date.get(page_URL);
        if (current_last_date == null || view_date > current_last_date) {
            this.ht_page_last_view_date.put(page_URL, new Long(view_date));
        }
    }

    public void merge(RecognizedUserAgent a) {
        super.merge(a);
        this.daily_activity_storage.merge(a.getDailyActivityStorage());
        Enumeration e = a.getPageLastDateTable().keys();
        while (e.hasMoreElements()) {
            String key_page = (String)e.nextElement();
            Long current_date = (Long)this.getPageLastDateTable().get(key_page);
            Long page_date = (Long)a.getPageLastDateTable().get(key_page);
            if (current_date != null && (page_date == null || page_date <= current_date)) continue;
            this.getPageLastDateTable().put(key_page, page_date);
        }
        this.setHitRobotsTxtOR(a.isRobotsTxtHited());
        this.setHitRobotTrapOR(a.isRobotTrapHited());
    }

    public DailyActivityStorage getDailyActivityStorage() {
        return this.daily_activity_storage;
    }

    public void setHitRobotsTxtOR(boolean robots_txt_hit) {
        this.robots_txt_hit |= robots_txt_hit;
    }

    public boolean isRobotsTxtHited() {
        return this.robots_txt_hit;
    }

    public void setHitRobotTrapOR(boolean robot_trap_hit) {
        this.robot_trap_hit |= robot_trap_hit;
    }

    public boolean isRobotTrapHited() {
        return this.robot_trap_hit;
    }

    public boolean equals(Object o) {
        if (o.getClass() != this.getClass()) {
            return false;
        }
        RecognizedUserAgent ua = (RecognizedUserAgent)o;
        return ua.useragent.getId().equals(this.useragent.getId()) && ua.version.equals(this.version);
    }

    public int hashCode() {
        return (String.valueOf(this.useragent.getId()) + "_" + this.version).hashCode();
    }

    public UserAgent getUserAgent() {
        return this.useragent;
    }

    public Hashtable getPageLastDateTable() {
        return this.ht_page_last_view_date;
    }

    public String toString() {
        return String.valueOf(this.useragent.getFamily().getId()) + "/" + this.useragent.getId() + "_" + this.version + " (" + this.nbr_pages + " pages, " + this.nbr_hits + " hits, " + this.size + " bytes)";
    }
}

