/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.DailyActivityStorage;
import ch.kronospace.logpsychoanalyst.DailyActivityStorageOwner;
import ch.kronospace.logpsychoanalyst.HTTPStatisticElement;
import ch.kronospace.logpsychoanalyst.IntegerCounter;
import ch.kronospace.logpsychoanalyst.SearchEngineKeywords;
import ch.kronospace.tools.HTMLTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;

public class SearchEngineStatisticElement
extends HTTPStatisticElement
implements DailyActivityStorageOwner {
    private DailyActivityStorage daily_activity_storage = new DailyActivityStorage();
    public Hashtable ht_keywords = new Hashtable();

    public DailyActivityStorage getDailyActivityStorage() {
        return this.daily_activity_storage;
    }

    public void addKeywords(String[] args) {
        SearchEngineKeywords key = new SearchEngineKeywords(args);
        IntegerCounter count = (IntegerCounter)this.ht_keywords.get(key);
        if (count == null) {
            count = new IntegerCounter();
            count.object = key;
            this.ht_keywords.put(key, count);
        }
        count.inc();
    }

    public void addKeywords(SearchEngineKeywords key, IntegerCounter count) {
        IntegerCounter old_count = (IntegerCounter)this.ht_keywords.get(key);
        if (old_count == null) {
            old_count = new IntegerCounter();
            old_count.object = key;
            this.ht_keywords.put(key, old_count);
        }
        old_count.inc(count.i);
    }

    public IntegerCounter getCount(SearchEngineKeywords key) {
        return (IntegerCounter)this.ht_keywords.get(key);
    }

    public void removeKeywords(SearchEngineKeywords key) {
        IntegerCounter count = (IntegerCounter)this.ht_keywords.remove(key);
        if (count != null) {
            this.nbr_visits -= (long)count.i;
        }
    }

    public List getKeyphrasesWithKeywords(String[] keywords) {
        ArrayList<SearchEngineKeywords> list = new ArrayList<SearchEngineKeywords>();
        Enumeration e = this.ht_keywords.keys();
        while (e.hasMoreElements()) {
            SearchEngineKeywords key = (SearchEngineKeywords)e.nextElement();
            if (!key.hasKeywords(keywords)) continue;
            list.add(key);
        }
        return list;
    }

    public Hashtable getKeywordHistogram() {
        Hashtable<String, IntegerCounter> ht_keywords2 = new Hashtable<String, IntegerCounter>();
        List<String> stopwords = Arrays.asList(ResourceBundle.getBundle("lang.Referer").getString("stopwords").split("\\s"));
        Enumeration e = this.ht_keywords.keys();
        while (e.hasMoreElements()) {
            SearchEngineKeywords key = (SearchEngineKeywords)e.nextElement();
            IntegerCounter key_count = (IntegerCounter)this.ht_keywords.get(key);
            String[] keywords = key.getKeywords();
            int i = 0;
            while (i < keywords.length) {
                String kw = HTMLTools.cleanFromHex(keywords[i]);
                kw = kw.replaceAll("\\\"", "");
                if (!stopwords.contains(kw = kw.replaceAll("%", "")) && kw.length() > 0) {
                    IntegerCounter count = (IntegerCounter)ht_keywords2.get(kw);
                    if (count == null) {
                        count = new IntegerCounter();
                        count.object = kw;
                        ht_keywords2.put(kw, count);
                    }
                    count.i += key_count.i;
                }
                ++i;
            }
        }
        return ht_keywords2;
    }

    public boolean hasKeywords() {
        return this.ht_keywords.size() > 0;
    }

    public String getKeywordsString() {
        String result = "";
        Enumeration e = this.ht_keywords.keys();
        while (e.hasMoreElements()) {
            SearchEngineKeywords key = (SearchEngineKeywords)e.nextElement();
            IntegerCounter count = (IntegerCounter)this.ht_keywords.get(key);
            result = String.valueOf(result) + key.toString() + " (" + count.i + " hits)\n";
        }
        return result;
    }

    public void reset() {
        super.reset();
        this.ht_keywords.clear();
    }

    public void merge(SearchEngineStatisticElement stat) {
        super.merge(stat);
        this.daily_activity_storage.merge(stat.getDailyActivityStorage());
        Enumeration e = stat.ht_keywords.keys();
        while (e.hasMoreElements()) {
            SearchEngineKeywords key = (SearchEngineKeywords)e.nextElement();
            IntegerCounter count = (IntegerCounter)stat.ht_keywords.get(key);
            this.addKeywords(key, count);
        }
    }
}

