/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.DailyActivityStorage;
import ch.kronospace.logpsychoanalyst.DailyDownloadSpeed;
import ch.kronospace.logpsychoanalyst.DailyVisitDuration;
import ch.kronospace.logpsychoanalyst.HTTPStatisticElement;
import ch.kronospace.logpsychoanalyst.HitIncrementer;
import ch.kronospace.logpsychoanalyst.PageIncrementer;
import ch.kronospace.logpsychoanalyst.RecognizedPlugin;
import ch.kronospace.logpsychoanalyst.RecognizedUserAgent;
import ch.kronospace.logpsychoanalyst.RecognizedUserAgentFamily;
import ch.kronospace.logpsychoanalyst.StatisticsTable;
import ch.kronospace.logpsychoanalyst.URLGroupManager;
import ch.kronospace.logpsychoanalyst.UserAgentFamily;
import ch.kronospace.logpsychoanalyst.Visit;
import ch.kronospace.logpsychoanalyst.VisitIncrementer;
import ch.kronospace.logpsychoanalyst.VisitMap;
import ch.kronospace.logpsychoanalyst.report.HTTPStatistics;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class StatisticBag {
    private VisitIncrementer visit_incrementer = new VisitIncrementer();
    private PageIncrementer page_incrementer = new PageIncrementer();
    private HitIncrementer hit_incrementer = new HitIncrementer();
    public String visitor_type;
    public URLGroupManager url_group_manager = new URLGroupManager();
    public Hashtable ht_undetailed_visits = new Hashtable();
    public StatisticsTable ht_screen_size = new StatisticsTable("Screen size", "Screen size", HTTPStatisticElement.COMPARATOR_VISITS);
    public StatisticsTable ht_unknown_os;
    public StatisticsTable histo_useragent_families;
    public Hashtable histo_useragents;
    public StatisticsTable histo_country;
    public StatisticsTable histo_hosts;
    public StatisticsTable histo_os;
    public Hashtable histo_urls;
    public StatisticsTable histo_mime_type;
    public Hashtable open_visits;
    public ArrayList closed_visits;
    public StatisticsTable installed_plugins_histo;
    public StatisticsTable alias_histo;
    public StatisticsTable ht_languages;
    public Visit zero_duration_visit;
    public int nbr_zero_duration_visits;
    public int[] histo_visit_duration;
    public long total_visit_length;
    public VisitMap visit_map;
    public RecognizedUserAgent useragent_full_range;
    public HTTPStatisticElement[] activity_hours;
    public DailyActivityStorage daily_activity;
    public DailyVisitDuration daily_visit_duration;
    public DailyDownloadSpeed daily_download_speed;
    public int nbr_bins_download_speed_histo;
    public int max_download_speed;
    public int min_download_speed;
    public int[] download_speed_histo;
    public int nbr_unknown_download_speed;

    public StatisticBag(String visitor_type, int nbr_bins_visit_duration) {
        this.ht_screen_size.setIcon("screen_size.png");
        this.ht_screen_size.setColumns("VD");
        this.ht_screen_size.setHelp("screen_size.html");
        this.ht_screen_size.setDetails("screen_size_details.html");
        this.ht_screen_size.setUnknown(null);
        this.ht_unknown_os = new StatisticsTable("Unknown OS", "HTTP User-Agent string", HTTPStatisticElement.COMPARATOR_VISITS);
        this.histo_useragent_families = new StatisticsTable("User-Agent families", "User-Agent family", HTTPStatisticElement.COMPARATOR_VISITS);
        this.histo_useragents = new Hashtable();
        this.histo_country = new StatisticsTable("Countries", "Country", HTTPStatisticElement.COMPARATOR_VISITS);
        this.histo_country.setIcon("country.png");
        this.histo_country.setColumns("VPHB");
        this.histo_country.setHelp("country.html");
        this.histo_country.setDetails("country_details.html");
        this.histo_country.setUnknown(null);
        this.histo_hosts = new StatisticsTable("Hosts", "Host", HTTPStatisticElement.COMPARATOR_VISITS);
        this.histo_os = new StatisticsTable("Operating System", "OS", HTTPStatisticElement.COMPARATOR_VISITS);
        this.histo_os.setIcon("os.png");
        this.histo_os.setDetails("os_details.html");
        this.histo_os.setUnknown("os_unknown.html");
        this.histo_urls = new Hashtable(50000);
        this.histo_mime_type = new StatisticsTable("Mime-types", "Mime-type", HTTPStatisticElement.COMPARATOR_VISITS);
        this.histo_mime_type.setColumns("HB");
        this.histo_mime_type.setDetails("mimetype_details.html");
        this.histo_mime_type.setHelp("mime_type.html");
        this.open_visits = new Hashtable(200000);
        this.closed_visits = new ArrayList(50000);
        this.installed_plugins_histo = new StatisticsTable("Installed plugins", "Plugin", RecognizedPlugin.COMPARATOR);
        this.installed_plugins_histo.setColumnName(1, "Supported");
        this.installed_plugins_histo.setColumnName(2, "Supported (predicted)");
        this.installed_plugins_histo.setColumnName(3, "Unsupported (predicted)");
        this.installed_plugins_histo.setColumnName(4, "Unsupported");
        this.installed_plugins_histo.setColumns("1234");
        this.alias_histo = new StatisticsTable("Aliases", "Alias", HTTPStatisticElement.COMPARATOR_VISITS);
        this.alias_histo.setColumns("V");
        this.ht_languages = new StatisticsTable("Languages", "Language", HTTPStatisticElement.COMPARATOR_VISITS);
        this.ht_languages.setColumns("VD");
        this.ht_languages.setDetails("languages_details.html");
        this.zero_duration_visit = null;
        this.nbr_zero_duration_visits = 0;
        this.histo_visit_duration = null;
        this.total_visit_length = 0L;
        this.visit_map = null;
        this.useragent_full_range = new RecognizedUserAgent(null, "");
        this.activity_hours = new HTTPStatisticElement[HTTPStatistics.nbr_bins_server_activity_hours];
        this.daily_activity = new DailyActivityStorage();
        this.daily_visit_duration = new DailyVisitDuration();
        this.daily_download_speed = new DailyDownloadSpeed();
        this.nbr_bins_download_speed_histo = 10;
        this.max_download_speed = 0x6400000;
        this.min_download_speed = 240;
        this.download_speed_histo = new int[this.nbr_bins_download_speed_histo];
        this.nbr_unknown_download_speed = 0;
        this.visitor_type = visitor_type;
        this.histo_visit_duration = new int[nbr_bins_visit_duration];
        this.visit_map = new VisitMap();
        int i = 0;
        while (i < this.activity_hours.length) {
            this.activity_hours[i] = new HTTPStatisticElement();
            ++i;
        }
    }

    public void displayMemoryUsage() {
        System.out.println("  Undetailed visits size=" + this.ht_undetailed_visits.size());
        System.out.println("  Useragents histo size=" + this.histo_useragents.size());
        System.out.println("  Country histo size=" + this.histo_country.size());
        System.out.println("  Host histo size=" + this.histo_hosts.size());
        System.out.println("  URLs histo size=" + this.histo_urls.size());
        System.out.println("  Mime-type histo size=" + this.histo_mime_type.size());
        System.out.println("  Open visits size=" + this.open_visits.size());
        System.out.println("  Closed visits size=" + this.closed_visits.size());
    }

    public void mergeUserAgents(Hashtable ht_user_agent) {
        Iterator iter = ht_user_agent.values().iterator();
        while (iter.hasNext()) {
            RecognizedUserAgent recognized_useragent = (RecognizedUserAgent)iter.next();
            if (!recognized_useragent.getUserAgent().getFamily().getVisitorType().equals(this.visitor_type)) continue;
            RecognizedUserAgent ua_from_histo = (RecognizedUserAgent)this.histo_useragents.get(recognized_useragent);
            if (ua_from_histo == null) {
                this.histo_useragents.put(recognized_useragent, recognized_useragent);
                ua_from_histo = recognized_useragent;
            } else {
                ua_from_histo.merge(recognized_useragent);
            }
            UserAgentFamily family = recognized_useragent.getUserAgent().getFamily();
            RecognizedUserAgentFamily rec_family = (RecognizedUserAgentFamily)this.histo_useragent_families.get(family);
            if (rec_family == null) {
                rec_family = new RecognizedUserAgentFamily(family);
                this.histo_useragent_families.put(family, rec_family);
            }
            rec_family.merge(recognized_useragent);
            rec_family.addRecognizedUADailyActivity(recognized_useragent);
            this.useragent_full_range.merge(recognized_useragent);
        }
    }

    public void computePluginHistogram() {
        Iterator e = this.closed_visits.iterator();
        while (e.hasNext()) {
            Visit v = (Visit)e.next();
            int i = 0;
            while (i < Visit.supported_plugins.length) {
                int state;
                String plugin_name = Visit.supported_plugins[i];
                RecognizedPlugin plugin = (RecognizedPlugin)this.installed_plugins_histo.get(plugin_name);
                if (plugin == null) {
                    plugin = new RecognizedPlugin(plugin_name);
                    this.installed_plugins_histo.put(plugin_name, plugin);
                }
                if ((state = v.isPluginInstalled(plugin_name)) == 1) {
                    ++plugin.nbr_visits;
                    plugin.getDailyActivityStorage().update(v.getLastVisitedPageDate(), this.visit_incrementer);
                } else if (state == 0) {
                    ++plugin.nbr_pages;
                    plugin.getDailyActivityStorage().update(v.getLastVisitedPageDate(), this.page_incrementer);
                } else {
                    ++plugin.nbr_hits;
                    plugin.getDailyActivityStorage().update(v.getLastVisitedPageDate(), this.hit_incrementer);
                }
                ++i;
            }
        }
    }

    public HTTPStatisticElement getTotal(Hashtable ht_statistic_element) {
        HTTPStatisticElement total = new HTTPStatisticElement();
        Iterator iter = ht_statistic_element.values().iterator();
        while (iter.hasNext()) {
            HTTPStatisticElement el = (HTTPStatisticElement)iter.next();
            total.merge(el);
        }
        return total;
    }
}

