/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.HTTPStatisticElement;
import ch.kronospace.logpsychoanalyst.StatisticElementFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;

public class StatisticsTable
extends Hashtable {
    private static final long serialVersionUID = -591266532989897972L;
    protected String name = null;
    protected String icon = null;
    protected String help = null;
    protected String columns = "VPHBD";
    protected String details = null;
    protected String unknown = null;
    protected String first_column_name = null;
    protected String[] column_name = new String[10];
    public int nbr_displayed_rows_in_summary = 10;
    private ArrayList array_list = null;
    private Comparator comp = null;
    private StatisticElementFilter filter = null;

    public StatisticsTable(String table_name, String first_column_name, StatisticElementFilter filter) {
        this.setName(table_name);
        this.filter = filter;
        this.first_column_name = first_column_name;
        this.column_name[0] = first_column_name;
    }

    public StatisticsTable(String table_name, String first_column_name, Comparator comp) {
        this.setName(table_name);
        this.comp = comp;
        this.first_column_name = first_column_name;
        this.column_name[0] = first_column_name;
    }

    public StatisticElementFilter getStatisticElementFilter() {
        return this.filter;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public String getHelp() {
        return this.help;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public String getDetails() {
        return this.details;
    }

    public void setUnknown(String unknown) {
        this.unknown = unknown;
    }

    public String getUnknown() {
        return this.unknown;
    }

    public void setColumns(String columns) {
        this.columns = columns;
    }

    public String getColumns() {
        return this.columns;
    }

    public String getFirstColumnName() {
        return this.first_column_name;
    }

    public void setColumnName(int index, String name) {
        this.column_name[index] = name;
    }

    public String getColumnName(int index) {
        return this.column_name[index];
    }

    public void resetTotal() {
        this.array_list = null;
    }

    public ArrayList getArrayList() {
        if (this.array_list == null) {
            this.sort();
        }
        return this.array_list;
    }

    public HTTPStatisticElement getTotal() {
        if (this.values().size() == 0) {
            return new HTTPStatisticElement();
        }
        HTTPStatisticElement total = (HTTPStatisticElement)((HTTPStatisticElement)this.values().iterator().next()).clone();
        total.reset();
        Iterator e = this.values().iterator();
        while (e.hasNext()) {
            total.merge((HTTPStatisticElement)e.next());
        }
        return total;
    }

    public HTTPStatisticElement getTotalTop() {
        if (this.array_list == null) {
            this.sort();
        }
        if (this.values().size() == 0) {
            return new HTTPStatisticElement();
        }
        HTTPStatisticElement total_top = (HTTPStatisticElement)((HTTPStatisticElement)this.values().iterator().next()).clone();
        total_top.reset();
        int i = 0;
        Iterator e = this.array_list.iterator();
        while (e.hasNext() && i < this.nbr_displayed_rows_in_summary) {
            total_top.merge((HTTPStatisticElement)e.next());
            ++i;
        }
        return total_top;
    }

    public void setComparator(Comparator comp) {
        this.comp = comp;
    }

    public void sort() {
        if (this.comp != null) {
            this.sort(this.comp);
        } else {
            this.sort(HTTPStatisticElement.COMPARATOR_VISITS);
        }
    }

    public void sort(Comparator comp) {
        this.array_list = new ArrayList(this.values());
        Collections.sort(this.array_list, comp);
    }
}

