/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.DailyActivityStorage;
import ch.kronospace.logpsychoanalyst.StatisticElement;
import ch.kronospace.logpsychoanalyst.StatisticElementArrayGetter;
import java.util.Comparator;

public class TerminalValidationStatus
implements StatisticElement {
    public long nbr_granted = 0L;
    public long nbr_denied = 0L;
    public long nbr_error = 0L;
    public static final StatisticElementArrayGetter GETTER_GRANTED = new StatisticElementArrayGetter(){

        public String getValueName() {
            return "granted";
        }

        public double[] getValues(DailyActivityStorage das, long first_date, long last_date) {
            StatisticElement[] elements = das.getRange(first_date, last_date);
            double[] values = new double[elements.length];
            int i = 0;
            while (i < elements.length) {
                TerminalValidationStatus el = (TerminalValidationStatus)elements[i];
                values[i] = el.nbr_granted;
                ++i;
            }
            return values;
        }
    };
    public static final StatisticElementArrayGetter GETTER_DENIED = new StatisticElementArrayGetter(){

        public String getValueName() {
            return "denied";
        }

        public double[] getValues(DailyActivityStorage das, long first_date, long last_date) {
            StatisticElement[] elements = das.getRange(first_date, last_date);
            double[] values = new double[elements.length];
            int i = 0;
            while (i < elements.length) {
                TerminalValidationStatus el = (TerminalValidationStatus)elements[i];
                values[i] = el.nbr_denied;
                ++i;
            }
            return values;
        }
    };
    public static final StatisticElementArrayGetter GETTER_ERROR = new StatisticElementArrayGetter(){

        public String getValueName() {
            return "error";
        }

        public double[] getValues(DailyActivityStorage das, long first_date, long last_date) {
            StatisticElement[] elements = das.getRange(first_date, last_date);
            double[] values = new double[elements.length];
            int i = 0;
            while (i < elements.length) {
                TerminalValidationStatus el = (TerminalValidationStatus)elements[i];
                values[i] = el.nbr_error;
                ++i;
            }
            return values;
        }
    };
    private static String[] self_data_names = new String[]{"granted", "denied", "error"};
    private static double[] self_data = new double[3];
    public static final Comparator COMPARATOR_GRANTED = new Comparator(){

        public int compare(Object o1, Object o2) {
            TerminalValidationStatus t1 = (TerminalValidationStatus)o1;
            TerminalValidationStatus t2 = (TerminalValidationStatus)o2;
            return (int)(t1.nbr_granted - t2.nbr_granted);
        }
    };

    public double[] getData() {
        TerminalValidationStatus.self_data[0] = this.nbr_granted;
        TerminalValidationStatus.self_data[1] = this.nbr_denied;
        TerminalValidationStatus.self_data[2] = this.nbr_error;
        return self_data;
    }

    public String[] getDataNames() {
        return self_data_names;
    }

    public int[][] getDataGroups() {
        int[][] nArrayArray = new int[1][];
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        nArrayArray[0] = nArray;
        return nArrayArray;
    }

    public void merge(StatisticElement ua) {
        TerminalValidationStatus ts = (TerminalValidationStatus)ua;
        this.nbr_granted = ts.nbr_granted;
        this.nbr_denied = ts.nbr_denied;
        this.nbr_error = ts.nbr_error;
    }

    public void reset() {
        this.nbr_granted = 0L;
        this.nbr_denied = 0L;
        this.nbr_error = 0L;
    }

    public Object clone() {
        TerminalValidationStatus el = new TerminalValidationStatus();
        el.nbr_granted = this.nbr_granted;
        el.nbr_denied = this.nbr_denied;
        el.nbr_error = this.nbr_error;
        return el;
    }

    public String toString() {
        throw new RuntimeException("not yet implemented");
    }
}

