/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.HTTPStatisticElement;
import ch.kronospace.logpsychoanalyst.RecognizedURL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class URLGroup
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = -6813046803829977867L;
    public String directory_name = null;
    public String file_name = null;
    public RecognizedURL stat = null;
    public String group_id = null;

    public URLGroup() {
        this.stat = new RecognizedURL("root group");
        this.setAllowsChildren(true);
    }

    public URLGroup(RecognizedURL rurl) {
        this.stat = rurl;
        this.setAllowsChildren(false);
    }

    public URLGroup(String url_regexp, String group_name) {
        throw new RuntimeException("deprecated");
    }

    public boolean matches(RecognizedURL rurl) {
        throw new RuntimeException("deprecated");
    }

    public String getDirectoryName() {
        return this.directory_name;
    }

    public String getDirectoryNameHTML() {
        return this.getDirectoryNameHTML(0);
    }

    public String getDirectoryNameHTML(int nbr_subdir) {
        String double_dot_str = "";
        int i = 0;
        while (i < nbr_subdir) {
            double_dot_str = String.valueOf(double_dot_str) + "../";
            ++i;
        }
        return "<img border=0 src=" + double_dot_str + "images/urlgroup.png> " + this.directory_name;
    }

    public void setDirectoryName(String directory_name) {
        this.directory_name = directory_name;
        this.group_id = "" + directory_name.hashCode();
    }

    public void setFileName(String file_name) {
        this.file_name = file_name;
    }

    public String getFileName() {
        return this.file_name;
    }

    public RecognizedURL getRecognizedURL() {
        return this.stat;
    }

    public void computeTotals() {
        this.stat.reset();
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            URLGroup group = (URLGroup)e.nextElement();
            if (group.getAllowsChildren()) {
                group.computeTotals();
            }
            this.stat.merge(group.stat);
        }
    }

    public void sort(Comparator comp) {
        Collections.sort(this.children, comp);
    }

    public void sort() {
        this.sort(new Comparator(){

            public int compare(Object o1, Object o2) {
                RecognizedURL u1 = ((URLGroup)o1).stat;
                RecognizedURL u2 = ((URLGroup)o2).stat;
                return HTTPStatisticElement.COMPARATOR_PAGES.compare(u1, u2);
            }
        });
    }
}

