/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.DailyActivityStorage;
import ch.kronospace.logpsychoanalyst.DailyActivityStorageOwner;
import ch.kronospace.logpsychoanalyst.HTTPStatisticElement;
import ch.kronospace.logpsychoanalyst.IntegerCounter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;

public class UnknownUserAgent
extends HTTPStatisticElement
implements DailyActivityStorageOwner {
    public String useragent_string;
    private Hashtable ht_page_last_view_date = new Hashtable();
    private Hashtable ht_page_hits = new Hashtable();
    private DailyActivityStorage daily_activity_storage = new DailyActivityStorage();
    private boolean robots_txt_hit = false;
    private boolean robot_trap_hit = false;
    public ArrayList hosts = new ArrayList();

    public UnknownUserAgent() {
    }

    public UnknownUserAgent(String useragent_string) {
        this.useragent_string = useragent_string;
    }

    public void addHost(String host, boolean robots_txt_hit, boolean robot_trap_hit) {
        if (!this.hosts.contains(host)) {
            this.hosts.add(host);
        }
        this.robot_trap_hit |= robot_trap_hit;
        this.robots_txt_hit |= robots_txt_hit;
    }

    public boolean isRobotsTxtHited() {
        return this.robots_txt_hit;
    }

    public boolean isRobotTrapHited() {
        return this.robot_trap_hit;
    }

    public DailyActivityStorage getDailyActivityStorage() {
        return this.daily_activity_storage;
    }

    public void setPageViewDate(String page_URL, long view_date) {
        IntegerCounter count = (IntegerCounter)this.ht_page_hits.get(page_URL);
        if (count == null) {
            count = new IntegerCounter(page_URL);
            this.ht_page_hits.put(page_URL, count);
        }
        count.inc();
        Long current_last_date = (Long)this.ht_page_last_view_date.get(page_URL);
        if (current_last_date == null || view_date > current_last_date) {
            this.ht_page_last_view_date.put(page_URL, new Long(view_date));
        }
    }

    public Hashtable getPageLastDateTable() {
        return this.ht_page_last_view_date;
    }

    public int getNbrHits(String page) {
        IntegerCounter count = (IntegerCounter)this.ht_page_hits.get(page);
        if (count != null) {
            return count.i;
        }
        return 0;
    }

    public ArrayList getHosts() {
        Collections.sort(this.hosts);
        return this.hosts;
    }

    public void setTime(long last_visit_time) {
        this.last_hit_date = last_visit_time;
    }

    public String getUAString() {
        return this.useragent_string;
    }

    public String getName() {
        return this.useragent_string;
    }
}

