/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.DataSource;
import ch.kronospace.logpsychoanalyst.FilePatternComparator;
import ch.kronospace.logpsychoanalyst.Host;
import ch.kronospace.logpsychoanalyst.InputStreamVector;
import ch.kronospace.logpsychoanalyst.PrefixSuffixFileFilter;
import ch.kronospace.logpsychoanalyst.logformat.LogFormat;
import java.io.File;
import java.text.DateFormat;
import java.text.Format;
import java.util.Arrays;

public class VirtualHost
extends DataSource {
    private File access_log_dir;
    private Format access_log_file_pattern;
    private PrefixSuffixFileFilter access_log_file_filter;
    private boolean access_log_recursive = false;
    private File log_dir;
    private Format log_file_pattern;
    private LogFormat log_log_format;
    private PrefixSuffixFileFilter log_file_filter;

    public VirtualHost() {
    }

    public VirtualHost(String source_name) {
        this.source_name = source_name;
    }

    public void setHostName(String name) {
        throw new RuntimeException("not yet implemented");
    }

    public void setHost(Host h) {
        throw new RuntimeException("not yet implemented");
    }

    public void setAccessLogger(File dir, boolean recursive, PrefixSuffixFileFilter file_filter, Format file_pattern, LogFormat log_format) {
        this.access_log_dir = dir;
        this.access_log_recursive = recursive;
        this.setLogFormat(log_format);
        this.access_log_file_pattern = file_pattern;
        if (file_filter == null) {
            file_filter = new PrefixSuffixFileFilter("", "", "all files", recursive);
        }
        this.access_log_file_filter = file_filter;
    }

    public void setLogger(File dir, PrefixSuffixFileFilter file_filter, Format file_pattern, LogFormat log_format) {
        this.log_dir = dir;
        this.log_log_format = log_format;
        this.log_file_pattern = file_pattern;
        this.log_file_filter = file_filter;
    }

    public InputStreamVector getLogInputStreams() {
        File[] files = this.access_log_dir.listFiles(this.access_log_file_filter);
        Arrays.sort(files, new FilePatternComparator((DateFormat)this.access_log_file_pattern));
        return this.getLogInputStreams(files, this.access_log_recursive);
    }
}

