/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.DefaultPage;
import ch.kronospace.logpsychoanalyst.VirtualHost;
import ch.kronospace.logpsychoanalyst.logformat.LogFormat;
import ch.kronospace.logpsychoanalyst.report.StatisticsBuilder;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class VirtualHostParser
extends DefaultHandler {
    private static VirtualHostParser default_parser = null;
    private VirtualHost vhost = null;
    public static boolean debug = false;

    public static VirtualHostParser getDefaultParser() {
        if (default_parser == null) {
            default_parser = new VirtualHostParser();
        }
        return default_parser;
    }

    public VirtualHost getVirtualHost(String filename) {
        System.out.println("parsing " + filename);
        this.vhost = new VirtualHost();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new File(filename), (DefaultHandler)this);
        }
        catch (SAXParseException e) {
            System.out.println("exception at line " + e.getLineNumber() + ", column " + e.getColumnNumber() + " :");
            e.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return this.vhost;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        if (eName.equals("HostName")) {
            this.vhost.setHostName(attrs.getValue("name"));
        }
        if (eName.equals("DefaultPage")) {
            this.vhost.addDefaultPage(new DefaultPage(attrs.getValue("name")));
        }
        if (eName.equals("TimeZone")) {
            this.vhost.setTimeZone(attrs.getValue("name"));
        }
        if (eName.equals("LogFilenamePattern")) {
            File f = new File(attrs.getValue("dir"));
            boolean recursive = attrs.getValue("recursive").equals("true");
            String pattern = attrs.getValue("pattern");
            Locale loc = new Locale(attrs.getValue("locale"));
            SimpleDateFormat df = new SimpleDateFormat(pattern, loc);
            LogFormat log_format = null;
            try {
                log_format = (LogFormat)Class.forName("loganalyst.logformat." + attrs.getValue("logformat")).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.vhost.setAccessLogger(f, recursive, null, df, log_format);
        }
        if (eName.equals("Statistics")) {
            Class<?> stat = null;
            try {
                stat = Class.forName("loganalyst.report." + attrs.getValue("classname"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.vhost.setStatisticsClass(stat);
        }
        if (eName.equals("StatisticsBuilder")) {
            StatisticsBuilder builder = null;
            try {
                builder = (StatisticsBuilder)Class.forName("loganalyst.report." + attrs.getValue("classname")).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.vhost.setStatisticsBuilder(builder);
        }
    }

    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (debug) {
            String s = new String(buf, offset, len);
            System.out.println(s);
        }
    }
}

