/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.HTTPStatisticElement;
import ch.kronospace.logpsychoanalyst.RecognizedHost;
import ch.kronospace.logpsychoanalyst.RecognizedOS;
import ch.kronospace.logpsychoanalyst.RecognizedURL;
import ch.kronospace.logpsychoanalyst.RecognizedUserAgent;
import ch.kronospace.logpsychoanalyst.StatisticElementFullUpdater;
import ch.kronospace.logpsychoanalyst.VisitedURL;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;

public class Visit
extends HTTPStatisticElement {
    public static final String PLUGIN_JAVA = "<img src=images/useragent_icon/java.png> Java";
    public static final String PLUGIN_REALPLAYER = "<img src=images/useragent_icon/realplayer.png> RealPlayer";
    public static final String PLUGIN_ACROBAT_READER = "<img src=images/useragent_icon/adobe.png> AcrobatReader";
    public static final String PLUGIN_WMA_PLAYER = "<img src=images/useragent_icon/wmp.png> WMAPlayer";
    public static final String PLUGIN_FLASH = "<img src=images/useragent_icon/flash.png> Flash";
    public static final String PLUGIN_SHOCKWAVE = "<img src=images/useragent_icon/shockwave.png> Shockwave";
    public static final String PLUGIN_QUICKTIME = "<img src=images/useragent_icon/quicktime.png> Quicktime";
    public static final String PLUGIN_JAVASCRIPT = "<img src=images/mimetypes/script.png> Javascript";
    public static final String PLUGIN_JAVA_WEB_START = "<img src=images/useragent_icon/java.png> Java Web Start";
    public static final String PLUGIN_SVG = "<img src=images/useragent_icon/svg.png> SVG";
    public static final String[] supported_plugins = new String[]{"<img src=images/useragent_icon/java.png> Java", "<img src=images/useragent_icon/realplayer.png> RealPlayer", "<img src=images/useragent_icon/adobe.png> AcrobatReader", "<img src=images/useragent_icon/wmp.png> WMAPlayer", "<img src=images/useragent_icon/flash.png> Flash", "<img src=images/useragent_icon/shockwave.png> Shockwave", "<img src=images/useragent_icon/quicktime.png> Quicktime", "<img src=images/mimetypes/script.png> Javascript", "<img src=images/useragent_icon/java.png> Java Web Start", "<img src=images/useragent_icon/svg.png> SVG"};
    private String visit_id = null;
    private String visitor_id = null;
    private ArrayList visited_pages = new ArrayList();
    private Hashtable installed_plugins = new Hashtable();
    RecognizedOS os;
    public RecognizedHost host;
    public RecognizedUserAgent useragent;
    public boolean is_internal_referer = false;
    private boolean unsorted_visit = true;
    private boolean is_alias_detected = false;
    public Hashtable ht_languages = new Hashtable();
    private Dimension screen_size = new Dimension(-1, -1);
    public float download_speed = -1.0f;
    private long downloaded_bytes = 0L;
    long visit_duration = -1L;
    private long first_url_size = -1L;
    long first_hit_date = 0L;

    public Visit(RecognizedHost host, long first_hit_date) {
        this.first_hit_date = first_hit_date;
        this.setDate(first_hit_date);
        this.setRecognizedHost(host);
    }

    public void setRecognizedHost(RecognizedHost new_host) {
        if (new_host == null) {
            return;
        }
        this.host = new_host;
        this.host.addVisit(this);
    }

    public void setOS(RecognizedOS os) {
        this.os = os;
    }

    public RecognizedOS getOS() {
        return this.os;
    }

    public void setAliasRecognized(boolean is_alias_detected) {
        this.is_alias_detected = is_alias_detected;
    }

    public boolean isAliasRecognized() {
        return this.is_alias_detected;
    }

    public void setVisitID(String visit_id) {
        this.visit_id = visit_id;
    }

    public void setVisitorID(String visitor_id) {
        this.visitor_id = visitor_id;
    }

    public String getVisitorID() {
        return this.visitor_id;
    }

    public String getVisitID() {
        return this.visit_id;
    }

    public void setScreenSize(int screen_width, int screen_height) {
        this.screen_size = new Dimension(screen_width, screen_height);
    }

    public Dimension getScreenSize() {
        return this.screen_size;
    }

    public void resetLanguagePreferences() {
        this.ht_languages.clear();
    }

    public void addLanguage(String language, float preference) {
        this.ht_languages.put(language, new Float(preference));
    }

    public void addVisitedURL(VisitedURL url, long url_size) {
        if (this.visited_pages == null) {
            return;
        }
        if (url.getURL() != null && this.getUserAgent() != null) {
            this.getUserAgent().setPageViewDate(url.getURL().url, url.getDate());
        }
        if (url.is_page && this.visited_pages.size() > 1) {
            this.computeDownloadSpeed();
        }
        if (this.getUserAgent() != null) {
            StatisticElementFullUpdater stat_el_full_updater = new StatisticElementFullUpdater();
            stat_el_full_updater.nbr_visits = 0L;
            stat_el_full_updater.nbr_pages = url.is_page ? 1 : 0;
            stat_el_full_updater.nbr_hits = 1L;
            stat_el_full_updater.size = url_size;
            this.getUserAgent().getDailyActivityStorage().update(url.getDate(), stat_el_full_updater);
        }
        this.downloaded_bytes += url_size;
        if (this.first_url_size < 0L) {
            this.first_url_size = url_size;
        }
        this.visited_pages.add(url);
        this.setDate(url.getDate());
    }

    public void computeDownloadSpeed() {
        long duration;
        if (this.download_speed < 0.0f && (duration = this.getLastVisitedPageDate() - this.getFirstHitDate()) > 0L) {
            this.download_speed = (float)(Math.max(0L, this.downloaded_bytes - this.first_url_size) * 1000L) / (float)duration;
        }
    }

    public long getFirstHitDate() {
        return this.first_hit_date;
    }

    public long getVisitDuration() {
        if (this.visit_duration >= 0L) {
            return this.visit_duration;
        }
        if (this.visited_pages != null && this.visited_pages.size() < 2) {
            return 0L;
        }
        long duration = ((VisitedURL)this.visited_pages.get(this.visited_pages.size() - 1)).getDate() - ((VisitedURL)this.visited_pages.get(0)).getDate();
        if (duration < 0L) {
            if (this.unsorted_visit) {
                Collections.sort(this.visited_pages, VisitedURL.DATE_COMPARATOR);
                this.unsorted_visit = false;
                duration = this.getVisitDuration();
            } else {
                System.out.println("ERROR: negative visit duration. Please submit a bug");
                System.out.println(this.visited_pages + "\n");
                throw new RuntimeException("negative visit duration after sorting");
            }
        }
        return duration;
    }

    public void clearVisitedURLs() {
        this.visit_duration = this.getVisitDuration();
        if (this.visited_pages == null) {
            return;
        }
        this.visited_pages.clear();
        this.visited_pages = null;
    }

    public void clearInstalledPlugins() {
        if (this.installed_plugins == null) {
            return;
        }
        this.installed_plugins.clear();
        this.installed_plugins = null;
    }

    public void packVisitedURLs() {
        this.visit_duration = this.getVisitDuration();
        if (this.visited_pages == null) {
            return;
        }
        ArrayList<VisitedURL> new_visited_pages = new ArrayList<VisitedURL>();
        Iterator e = this.visited_pages.iterator();
        while (e.hasNext()) {
            VisitedURL vu = (VisitedURL)e.next();
            if (!vu.is_page) continue;
            int index = new_visited_pages.indexOf(vu);
            if (index < 0) {
                new_visited_pages.add(vu);
                continue;
            }
            VisitedURL old_vu = (VisitedURL)new_visited_pages.get(index);
            if (vu.getDate() <= old_vu.getDate()) continue;
            new_visited_pages.set(index, vu);
        }
        this.visited_pages.clear();
        this.visited_pages = new_visited_pages;
    }

    public void addInstalledPlugin(String plugin_name, boolean installed) {
        this.installed_plugins.put(plugin_name, new Boolean(installed));
    }

    public int isPluginInstalled(String plugin_name) {
        if (this.installed_plugins == null) {
            return -1;
        }
        Boolean b = (Boolean)this.installed_plugins.get(plugin_name);
        if (b != null) {
            boolean installed = b;
            if (installed) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public Hashtable getInstalledPlugins() {
        return this.installed_plugins;
    }

    public long getLastVisitedPageDate() {
        if (this.visited_pages == null || this.visited_pages.size() == 0) {
            return this.first_hit_date;
        }
        return ((VisitedURL)this.visited_pages.get(this.visited_pages.size() - 1)).getDate();
    }

    public ArrayList getVisitedPages() {
        if (this.visited_pages == null) {
            return new ArrayList();
        }
        return this.visited_pages;
    }

    public String getLastVisitedPage() {
        if (this.visited_pages == null) {
            return "";
        }
        int i = this.visited_pages.size() - 1;
        while (i >= 0) {
            RecognizedURL rurl;
            VisitedURL vu = (VisitedURL)this.visited_pages.get(i);
            if (vu.is_page && (rurl = vu.getURL()) != null) {
                return rurl.url;
            }
            --i;
        }
        return null;
    }

    public boolean containsAnyPages(ArrayList pages) {
        if (this.visited_pages == null) {
            return false;
        }
        int i = this.visited_pages.size() - 1;
        while (i >= 0) {
            RecognizedURL rurl;
            VisitedURL vu = (VisitedURL)this.visited_pages.get(i);
            if (vu.is_page && (rurl = vu.getURL()) != null && pages.contains(rurl.url)) {
                return true;
            }
            --i;
        }
        return false;
    }

    public RecognizedUserAgent getUserAgent() {
        return this.useragent;
    }

    public void setUserAgent(RecognizedUserAgent useragent) {
        this.useragent = useragent;
    }

    public String toString() {
        String name = null;
        if (this.host != null) {
            name = this.host.getHostName();
        }
        if (this.useragent != null) {
            name = String.valueOf(name) + "/" + this.useragent.toString();
        }
        return String.valueOf(name) + "    (" + this.nbr_pages + " pages, " + this.nbr_hits + " hits, " + this.size + " bytes)";
    }
}

