/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst;

import ch.kronospace.logpsychoanalyst.IntegerCounter;
import ch.kronospace.logpsychoanalyst.NetworkActivityRenderer;
import edu.uci.ics.jung.graph.DirectedEdge;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.graph.filters.GeneralVertexAcceptFilter;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.DirectedSparseVertex;
import edu.uci.ics.jung.utils.GraphUtils;
import edu.uci.ics.jung.utils.UserDataContainer;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.SpringLayout;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JFrame;

public class VisitMap {
    private Layout mVisualizer;
    private VisualizationViewer mVizViewer;
    private Graph g = new DirectedSparseGraph();
    private StringLabeller labeller = StringLabeller.getLabeller((Graph)this.g);
    public static final String STATISTIC_ELEMENT_KEY = "loganalyst.HTTPStatisticElement";
    String filename = null;

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void addEntryPoint(String url) {
        Vertex node1 = this.labeller.getVertex(url);
        if (node1 == null) {
            node1 = this.g.addVertex((Vertex)new DirectedSparseVertex());
            try {
                this.labeller.setLabel(node1, url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            node1.addUserDatum((Object)"activity", (Object)new IntegerCounter(1), (UserDataContainer.CopyAction)new UserDataContainer.CopyAction.Shared());
            node1.addUserDatum((Object)"input", (Object)new IntegerCounter(1), (UserDataContainer.CopyAction)new UserDataContainer.CopyAction.Shared());
            node1.addUserDatum((Object)"output", (Object)new IntegerCounter(0), (UserDataContainer.CopyAction)new UserDataContainer.CopyAction.Shared());
            node1.addUserDatum((Object)"name", (Object)url, (UserDataContainer.CopyAction)new UserDataContainer.CopyAction.Shared());
        } else {
            IntegerCounter count = (IntegerCounter)node1.getUserDatum((Object)"input");
            count.inc();
            IntegerCounter count2 = (IntegerCounter)node1.getUserDatum((Object)"activity");
            count2.inc();
        }
    }

    public void addExitPoint(String url) {
        if (url == null) {
            return;
        }
        Vertex node1 = this.labeller.getVertex(url);
        if (node1 == null) {
            throw new AssertionError((Object)("the exit page should have been in the graph (" + url + ")"));
        }
        IntegerCounter count = (IntegerCounter)node1.getUserDatum((Object)"output");
        count.inc();
    }

    public void addMapSegment(String url_from, String url_to) {
        Vertex node2;
        Vertex node1 = this.labeller.getVertex(url_from);
        if (node1 == null) {
            node1 = this.g.addVertex((Vertex)new DirectedSparseVertex());
            try {
                this.labeller.setLabel(node1, url_from);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            node1.addUserDatum((Object)"activity", (Object)new IntegerCounter(1), (UserDataContainer.CopyAction)new UserDataContainer.CopyAction.Shared());
            node1.addUserDatum((Object)"input", (Object)new IntegerCounter(0), (UserDataContainer.CopyAction)new UserDataContainer.CopyAction.Shared());
            node1.addUserDatum((Object)"output", (Object)new IntegerCounter(0), (UserDataContainer.CopyAction)new UserDataContainer.CopyAction.Shared());
            node1.addUserDatum((Object)"name", (Object)url_from, (UserDataContainer.CopyAction)new UserDataContainer.CopyAction.Shared());
        }
        if ((node2 = this.labeller.getVertex(url_to)) == null) {
            node2 = this.g.addVertex((Vertex)new DirectedSparseVertex());
            try {
                this.labeller.setLabel(node2, url_to);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            node2.addUserDatum((Object)"activity", (Object)new IntegerCounter(1), (UserDataContainer.CopyAction)new UserDataContainer.CopyAction.Shared());
            node2.addUserDatum((Object)"input", (Object)new IntegerCounter(0), (UserDataContainer.CopyAction)new UserDataContainer.CopyAction.Shared());
            node2.addUserDatum((Object)"output", (Object)new IntegerCounter(0), (UserDataContainer.CopyAction)new UserDataContainer.CopyAction.Shared());
            node2.addUserDatum((Object)"name", (Object)url_to, (UserDataContainer.CopyAction)new UserDataContainer.CopyAction.Shared());
        } else {
            IntegerCounter count = (IntegerCounter)node2.getUserDatum((Object)"activity");
            count.inc();
        }
        DirectedEdge edge = (DirectedEdge)node1.findEdge(node2);
        if (edge == null) {
            edge = (DirectedEdge)this.g.addEdge((Edge)new DirectedSparseEdge(node1, node2));
            edge.addUserDatum((Object)"activity", (Object)new IntegerCounter(0), (UserDataContainer.CopyAction)new UserDataContainer.CopyAction.Shared());
        }
        IntegerCounter count = (IntegerCounter)edge.getUserDatum((Object)"activity");
        count.inc();
    }

    public void display() {
        JFrame f = new JFrame();
        VertexActivityFilter filter = new VertexActivityFilter(this.g, 50);
        Graph g2 = filter.filter(this.g).assemble();
        try {
            GraphUtils.copyLabels((StringLabeller)StringLabeller.getLabeller((Graph)this.g), (StringLabeller)StringLabeller.getLabeller((Graph)g2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mVisualizer = new SpringLayout(g2);
        NetworkActivityRenderer mRenderer = new NetworkActivityRenderer();
        mRenderer.init(g2);
        if (this.mVizViewer != null) {
            f.remove((Component)this.mVizViewer);
        }
        this.mVizViewer = new VisualizationViewer(this.mVisualizer, (Renderer)mRenderer);
        this.mVizViewer.setBackground(Color.WHITE);
        f.getContentPane().add((Component)this.mVizViewer);
        this.mVizViewer.revalidate();
        this.mVizViewer.repaint();
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
        this.writeImage(this.mVizViewer, this.filename);
    }

    public void writeImage(VisualizationViewer vv, String filename) {
        int width = vv.getGraphLayout().getCurrentSize().width;
        int height = vv.getGraphLayout().getCurrentSize().height;
        Color bg = vv.getBackground();
        BufferedImage bi = new BufferedImage(width, height, 4);
        Graphics2D graphics = bi.createGraphics();
        graphics.setColor(bg);
        graphics.fillRect(0, 0, width, height);
        vv.paint((Graphics)graphics);
        try {
            ImageIO.write((RenderedImage)bi, filename.substring(filename.lastIndexOf(46) + 1), new File(filename));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public long getColor(int index_map) {
        long[] colors = new long[]{0xFFCCCCL, 0xFFCBCBL, 0xFFCACAL, 0xFFC9C9L, 0xFFC8C8L, 0xFFC8C8L, 0xFFC7C7L, 0xFFC6C6L, 0xFFC5C5L, 0xFFC4C4L, 0xFFC4C4L, 0xFFC3C3L, 0xFFC2C2L, 0xFFC1C1L, 0xFFC0C0L, 0xFFC0C0L, 0xFFBFBFL, 0xFFBEBEL, 0xFFBDBDL, 0xFFBCBCL, 0xFFBCBCL, 0xFFBBBBL, 0xFFBABAL, 0xFFB9B9L, 0xFFB8B8L, 0xFFB8B8L, 0xFFB7B7L, 0xFFB6B6L, 0xFFB5B5L, 0xFFB4B4L, 0xFFB4B4L, 0xFFB3B3L, 0xFFB2B2L, 0xFFB1B1L, 0xFFB0B0L, 0xFFB0B0L, 0xFFAFAFL, 0xFFAEAEL, 0xFFADADL, 0xFFACACL, 0xFFACACL, 0xFFABABL, 0xFFAAAAL, 0xFFA9A9L, 0xFFA8A8L, 0xFFA8A8L, 0xFFA7A7L, 0xFFA6A6L, 0xFFA5A5L, 0xFFA4A4L, 0xFFA4A4L, 0xFFA3A3L, 0xFFA2A2L, 0xFFA1A1L, 0xFFA0A0L, 0xFFA0A0L, 0xFF9F9FL, 0xFF9E9EL, 0xFF9D9DL, 0xFF9C9CL, 0xFF9C9CL, 0xFF9B9BL, 0xFF9A9AL, 0xFF9999L, 0xFF9898L, 0xFF9898L, 0xFF9797L, 0xFF9696L, 0xFF9595L, 0xFF9494L, 0xFF9494L, 0xFF9393L, 0xFF9292L, 0xFF9191L, 0xFF9090L, 0xFF9090L, 0xFF8F8FL, 0xFF8E8EL, 0xFF8D8DL, 0xFF8C8CL, 0xFF8C8CL, 0xFF8B8BL, 0xFF8A8AL, 0xFF8989L, 0xFF8888L, 0xFF8888L, 0xFF8787L, 0xFF8686L, 0xFF8585L, 0xFF8484L, 0xFF8484L, 0xFF8383L, 0xFF8282L, 0xFF8181L, 0xFF8080L, 0xFF8080L, 0xFF7F7FL, 0xFF7E7EL, 0xFF7D7DL, 0xFF7C7CL, 0xFF7C7CL, 0xFF7B7BL, 0xFF7A7AL, 0xFF7979L, 0xFF7878L, 0xFF7878L, 0xFF7777L, 0xFF7676L, 0xFF7575L, 0xFF7474L, 0xFF7474L, 0xFF7373L, 0xFF7272L, 0xFF7171L, 0xFF7070L, 0xFF7070L, 0xFF6F6FL, 0xFF6E6EL, 0xFF6D6DL, 0xFF6C6CL, 0xFF6C6CL, 0xFF6B6BL, 0xFF6A6AL, 0xFF6969L, 0xFF6868L, 0xFF6868L, 0xFF6767L, 0xFF6666L, 0xFF6565L, 0xFF6464L, 0xFF6464L, 0xFF6363L, 0xFF6262L, 0xFF6161L, 0xFF6060L, 0xFF6060L, 0xFF5F5FL, 0xFF5E5EL, 0xFF5D5DL, 0xFF5C5CL, 0xFF5C5CL, 0xFF5B5BL, 0xFF5A5AL, 0xFF5959L, 0xFF5858L, 0xFF5858L, 0xFF5757L, 0xFF5656L, 0xFF5555L, 0xFF5454L, 0xFF5454L, 0xFF5353L, 0xFF5252L, 0xFF5151L, 0xFF5050L, 0xFF5050L, 0xFF4F4FL, 0xFF4E4EL, 0xFF4D4DL, 0xFF4C4CL, 0xFF4C4CL, 0xFF4B4BL, 0xFF4A4AL, 0xFF4949L, 0xFF4848L, 0xFF4848L, 0xFF4747L, 0xFF4646L, 0xFF4545L, 0xFF4444L, 0xFF4444L, 0xFF4343L, 0xFF4242L, 0xFF4141L, 0xFF4040L, 0xFF4040L, 0xFF3F3FL, 0xFF3E3EL, 0xFF3D3DL, 0xFF3C3CL, 0xFF3C3CL, 0xFF3B3BL, 0xFF3A3AL, 0xFF3939L, 0xFF3838L, 0xFF3838L, 0xFF3737L, 0xFF3636L, 0xFF3535L, 0xFF3434L, 0xFF3434L, 0xFF3333L, 0xFF3232L, 0xFF3131L, 0xFF3030L, 0xFF3030L, 0xFF2F2FL, 0xFF2E2EL, 0xFF2D2DL, 0xFF2C2CL, 0xFF2C2CL, 0xFF2B2BL, 0xFF2A2AL, 0xFF2929L, 0xFF2828L, 0xFF2828L, 0xFF2727L, 0xFF2626L, 0xFF2525L, 0xFF2424L, 0xFF2424L, 0xFF2323L, 0xFF2222L, 0xFF2121L, 0xFF2020L, 0xFF2020L, 0xFF1F1FL, 0xFF1E1EL, 0xFF1D1DL, 0xFF1C1CL, 0xFF1C1CL, 0xFF1B1BL, 0xFF1A1AL, 0xFF1919L, 0xFF1818L, 0xFF1818L, 0xFF1717L, 0xFF1616L, 0xFF1515L, 0xFF1414L, 0xFF1414L, 0xFF1313L, 0xFF1212L, 0xFF1111L, 0xFF1010L, 0xFF1010L, 0xFF0F0FL, 0xFF0E0EL, 0xFF0D0DL, 0xFF0C0CL, 0xFF0C0CL, 0xFF0B0BL, 0xFF0A0AL, 0xFF0909L, 0xFF0808L, 0xFF0808L, 0xFF0707L, 0xFF0606L, 0xFF0505L, 0xFF0404L, 0xFF0404L, 0xFF0303L, 0xFF0202L, 0xFF0101L, 0xFF0000L, 0xFF0000L};
        return colors[index_map];
    }

    public int gray2RGB(int gray) {
        return (gray << 16) + (gray << 8) + (gray << 0);
    }

    private class VertexActivityFilter
    extends GeneralVertexAcceptFilter {
        List accepted_vertices = null;

        public VertexActivityFilter(Graph g, int nbr_displayed_nodes) {
            ArrayList s = new ArrayList(g.getVertices());
            if (s.size() > nbr_displayed_nodes) {
                Collections.sort(s, new VertexActivityComparator());
                this.accepted_vertices = new ArrayList();
                int i = 0;
                Iterator iter = s.iterator();
                while (i < nbr_displayed_nodes && iter.hasNext()) {
                    Vertex v = (Vertex)iter.next();
                    this.accepted_vertices.add(v);
                    ++i;
                }
            } else {
                this.accepted_vertices = s;
            }
        }

        public void setAcceptedVertices(List accepted_vertices) {
            this.accepted_vertices = accepted_vertices;
        }

        public boolean acceptVertex(Vertex v) {
            return this.accepted_vertices.contains(v);
        }

        public String getName() {
            return "VertexActivityFilter";
        }
    }

    private class VertexActivityComparator
    implements Comparator {
        private VertexActivityComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1.getClass() != o2.getClass()) {
                return -1;
            }
            IntegerCounter e1 = (IntegerCounter)((Vertex)o1).getUserDatum((Object)"activity");
            IntegerCounter e2 = (IntegerCounter)((Vertex)o2).getUserDatum((Object)"activity");
            return e1.compareTo(e2);
        }

        public boolean compare(Object o1) {
            return o1.getClass().equals(this.getClass());
        }
    }
}

