/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.application;

import ch.kronospace.logpsychoanalyst.application.ApplicationDetector;
import ch.kronospace.logpsychoanalyst.application.ServiceLocation;
import java.util.Collection;
import java.util.Hashtable;
import javax.swing.JPanel;

public abstract class Service {
    private static Hashtable registered_services = new Hashtable();
    private Hashtable ht_service_locations = new Hashtable();

    public static void registerApplicationDetector(ApplicationDetector app) {
        Service service = (Service)registered_services.get(app.getService());
        if (service == null) {
            try {
                service = (Service)app.getService().newInstance();
                registered_services.put(app.getService(), service);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        service.registerServiceLocation(app);
    }

    public void registerServiceLocation(ApplicationDetector app) {
        ServiceLocation service_location = (ServiceLocation)this.ht_service_locations.get(app.getServiceLocation());
        if (service_location == null) {
            try {
                service_location = (ServiceLocation)app.getServiceLocation().newInstance();
                this.ht_service_locations.put(app.getServiceLocation(), service_location);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        service_location.registerApplicationDetector(app);
    }

    public static Collection getRegisteredServices() {
        return registered_services.values();
    }

    public Collection getLocations() {
        return this.ht_service_locations.values();
    }

    public abstract JPanel getPanel();
}

